/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.serviio.dlna.H264Profile;
import org.serviio.library.local.metadata.extractor.embedded.h264.AnnexBNALUnitReader;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapper;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapperImpl;
import org.serviio.library.local.metadata.extractor.embedded.h264.NALUnit;
import org.serviio.library.local.metadata.extractor.embedded.h264.NALUnitType;
import org.serviio.library.local.metadata.extractor.embedded.h264.SeqParameterSet;

public class AVCHeader {
    private byte[] buffer;
    private Integer profile;
    private Integer level;
    private Integer refFrames;
    private boolean constrained;

    public AVCHeader(byte[] buffer) {
        this.buffer = buffer;
    }

    public void parse() throws IOException {
        BufferWrapper nal;
        BufferWrapperImpl ibw = new BufferWrapperImpl(this.buffer);
        AnnexBNALUnitReader nalUnitReader = new AnnexBNALUnitReader(ibw);
        while ((nal = nalUnitReader.nextNALUnit()) != null) {
            NALUnit nu = NALUnit.read(nal);
            if (nu.type != NALUnitType.SPS) continue;
            SeqParameterSet param = SeqParameterSet.read(nal);
            this.profile = param.profile_idc;
            this.level = param.level_idc;
            this.refFrames = param.num_ref_frames;
            this.constrained = param.constraint_set_1_flag;
            break;
        }
    }

    public H264Profile getProfile() {
        return this.profile != null ? H264Profile.getByCode(this.profile, this.constrained) : null;
    }

    public String getLevel() {
        return this.level != null ? this.convertLevelToString((float)this.level.intValue() / 10.0f) : null;
    }

    public Integer getRefFrames() {
        return this.refFrames;
    }

    private String convertLevelToString(float level) {
        NumberFormat df = DecimalFormat.getInstance(Locale.ENGLISH);
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(1);
        return df.format(level);
    }
}

