/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.AbstractLocalFileExtractor;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.XPathUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBMCExtractor
extends AbstractLocalFileExtractor {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private static final DateFormat DATE_FORMAT2 = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.XBMC;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException {
        if (fileType == MediaFileType.VIDEO) {
            File folder = mediaFile.getParentFile();
            if (folder != null && folder.exists() && folder.isDirectory()) {
                File nfoFile = this.findFileInFolder(folder, "movie.nfo", false);
                if (nfoFile == null) {
                    nfoFile = this.findFileInFolder(folder, FileUtils.getFileNameWithoutExtension(mediaFile) + ".nfo", false);
                }
                if (nfoFile != null) {
                    boolean validFile = this.validateXBMCNfoFile(nfoFile);
                    if (validFile) {
                        this.log.debug(String.format("Found XBMC NFO file %s. Will try to extract metadata from it.", nfoFile.getName()));
                        MetadataFile metadataFile = new MetadataFile(this.getExtractorType(), FileUtils.getLastModifiedDate(nfoFile), nfoFile.getName(), mediaFile);
                        return metadataFile;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void retrieveMetadata(LocalItemMetadata metadata, File xmlFile, File mediaFile) throws IOException, InvalidMediaFormatException {
        FileInputStream xmlStream;
        block7: {
            xmlStream = null;
            try {
                xmlStream = new FileInputStream(xmlFile);
                Node rootNode = XPathUtil.getRootNode(xmlStream);
                if (rootNode == null) break block7;
                Node movieNode = XPathUtil.getNode(rootNode, "//movie");
                Node tvNode = XPathUtil.getNode(rootNode, "//episodedetails");
                if (movieNode != null) {
                    this.retrieveMovieMetadata((VideoMetadata)metadata, movieNode);
                } else if (tvNode != null) {
                    this.retrieveEpisodeMetadata((VideoMetadata)metadata, tvNode, mediaFile);
                }
            }
            catch (XPathExpressionException e) {
                try {
                    throw new InvalidMediaFormatException(String.format("File '%s' couldn't be parsed: %s", xmlFile.getPath(), e.getMessage()));
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(xmlStream);
                    throw throwable;
                }
            }
        }
        FileUtils.closeQuietly(xmlStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateXBMCNfoFile(File xmlFile) throws IOException {
        boolean bl;
        FileInputStream xmlStream;
        block5: {
            this.log.debug(String.format("Checking if file '%s' is a XBMC NFO file", xmlFile.getName()));
            xmlStream = null;
            xmlStream = new FileInputStream(xmlFile);
            Node rootNode = XPathUtil.getRootNode(xmlStream);
            if (rootNode == null) break block5;
            Node movieNode = XPathUtil.getNode(rootNode, "//movie");
            Node tvNode = XPathUtil.getNode(rootNode, "//episodedetails");
            if (movieNode == null && tvNode == null) break block5;
            this.log.debug(String.format("File '%s' is a valid XBMC file", xmlFile.getName()));
            boolean bl2 = true;
            FileUtils.closeQuietly(xmlStream);
            return bl2;
        }
        try {
            this.log.debug(String.format("File '%s' is not a XBMC file", xmlFile.getName()));
            bl = false;
        }
        catch (XPathExpressionException e) {
            boolean bl3;
            try {
                this.log.error(String.format("File '%s' couldn't be parsed:%s", xmlFile.getPath(), e.getMessage()));
                bl3 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(xmlStream);
                throw throwable;
            }
            FileUtils.closeQuietly(xmlStream);
            return bl3;
        }
        FileUtils.closeQuietly(xmlStream);
        return bl;
    }

    private void retrieveMovieMetadata(VideoMetadata metadata, Node movieNode) throws IOException, InvalidMediaFormatException {
        this.log.debug("Parsing NFO file for movie metadata");
        try {
            this.retrieveSharedData(metadata, movieNode);
            metadata.setGenre(StringUtils.trim(XPathUtil.getNodeValue(movieNode, "genre[1]")));
            metadata.setContentType(ContentType.MOVIE);
            metadata.setMPAARating(this.getMPAARating(StringUtils.trim(XPathUtil.getNodeValue(movieNode, "mpaa"))));
        }
        catch (XPathExpressionException e) {
            throw new InvalidMediaFormatException(String.format("Error during parsing XBMC movie NFO file: %s", e.getMessage()));
        }
    }

    private void retrieveEpisodeMetadata(VideoMetadata metadata, Node tvNode, File mediaFile) throws IOException, InvalidMediaFormatException {
        this.log.debug("Parsing NFO file for TV metadata");
        try {
            Node showNode = this.getSeriesFileRootNode(mediaFile);
            this.retrieveSharedData(metadata, tvNode);
            metadata.setGenre(StringUtils.trim(XPathUtil.getNodeValue(showNode, "genre[1]")));
            metadata.setSeriesName(StringUtils.trim(XPathUtil.getNodeValue(showNode, "title")));
            String seasonNumber = StringUtils.trim(XPathUtil.getNodeValue(tvNode, "season"));
            String episodeNumber = StringUtils.trim(XPathUtil.getNodeValue(tvNode, "episode"));
            metadata.setSeasonNumber(ObjectValidator.isNotEmpty(seasonNumber) ? Integer.valueOf(seasonNumber) : null);
            metadata.setEpisodeNumber(ObjectValidator.isNotEmpty(episodeNumber) ? Integer.valueOf(episodeNumber) : null);
            String airedDate = StringUtils.trim(XPathUtil.getNodeValue(tvNode, "aired"));
            Date aired = this.parseDate(airedDate);
            if (aired != null) {
                metadata.setDate(aired);
            }
            metadata.setContentType(ContentType.EPISODE);
        }
        catch (XPathExpressionException e) {
            throw new InvalidMediaFormatException(String.format("Error during parsing XBMC TV NFO file: %s", e.getMessage()));
        }
    }

    private void retrieveSharedData(VideoMetadata metadata, Node rootNode) throws XPathExpressionException {
        String year;
        metadata.setTitle(StringUtils.trim(XPathUtil.getNodeValue(rootNode, "title")));
        metadata.setDescription(StringUtils.trim(XPathUtil.getNodeValue(rootNode, "plot")));
        metadata.setActors(this.getActors(XPathUtil.getNodeSet(rootNode, "actor")));
        metadata.setDirectors(Collections.singletonList(XPathUtil.getNodeValue(rootNode, "director")));
        String releaseDate = StringUtils.trim(XPathUtil.getNodeValue(rootNode, "releasedate"));
        if (ObjectValidator.isEmpty(releaseDate) && ObjectValidator.isNotEmpty(year = StringUtils.trim(XPathUtil.getNodeValue(rootNode, "year")))) {
            releaseDate = "01/01/" + year;
        }
        metadata.setDate(this.parseDate(releaseDate));
        String imdbId = XPathUtil.getNodeValue(rootNode, "id");
        if (ObjectValidator.isNotEmpty(imdbId) && imdbId.startsWith("tt")) {
            metadata.getOnlineIdentifiers().put(OnlineDBIdentifier.IMDB, imdbId.trim());
        }
    }

    private List<String> getActors(NodeList actorsNodeList) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        if (actorsNodeList != null && actorsNodeList.getLength() > 0) {
            for (int i = 0; i < actorsNodeList.getLength(); ++i) {
                Node castNode = actorsNodeList.item(i);
                result.add(StringUtils.trim(XPathUtil.getNodeValue(castNode, "name")));
            }
        }
        return result;
    }

    private Node getSeriesFileRootNode(File mediaFile) throws IOException {
        FileInputStream xmlStream;
        File seriesNfo;
        block5: {
            Node showNode;
            seriesNfo = this.findShowNfoFile(mediaFile);
            xmlStream = null;
            xmlStream = new FileInputStream(seriesNfo);
            Node rootNode = XPathUtil.getRootNode(xmlStream);
            if (rootNode == null || (showNode = XPathUtil.getNode(rootNode, "tvshow")) == null) break block5;
            Node node = showNode;
            FileUtils.closeQuietly(xmlStream);
            return node;
        }
        try {
            try {
                throw new IOException(String.format("File '%s' is not a XBMC show file", seriesNfo.getPath()));
            }
            catch (XPathExpressionException e) {
                throw new IOException(String.format("File '%s' couldn't be parsed: %s", seriesNfo.getPath(), e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(xmlStream);
            throw throwable;
        }
    }

    private File findShowNfoFile(File mediaFile) throws IOException {
        File seriesNfo = null;
        for (File folder = mediaFile.getParentFile(); seriesNfo == null && folder != null; folder = folder.getParentFile()) {
            seriesNfo = this.findFileInFolder(folder, "tvshow.nfo", false);
        }
        if (seriesNfo == null) {
            throw new IOException(String.format("Cannot find tvshow.nfo file for %s, skipping XBMC metadata extraction", mediaFile.getPath()));
        }
        return seriesNfo;
    }

    private Date parseDate(String date) {
        if (ObjectValidator.isNotEmpty(date)) {
            try {
                return DATE_FORMAT.parse(date);
            }
            catch (ParseException e) {
                try {
                    return DATE_FORMAT2.parse(date);
                }
                catch (ParseException e2) {
                    this.log.debug("Cannot parse release date: " + date);
                }
            }
        }
        return null;
    }

    private MPAARating getMPAARating(String mpaaRating) {
        if (ObjectValidator.isNotEmpty(mpaaRating)) {
            String normalizedRating = StringUtils.localeSafeToLowercase(mpaaRating);
            if (normalizedRating.indexOf("rated pg-13") > -1 || normalizedRating.equals("pg-13")) {
                return MPAARating.PG13;
            }
            if (normalizedRating.indexOf("rated pg") > -1 || normalizedRating.equals("pg")) {
                return MPAARating.PG;
            }
            if (normalizedRating.indexOf("rated g") > -1 || normalizedRating.equals("g")) {
                return MPAARating.G;
            }
            if (normalizedRating.indexOf("rated r") > -1 || normalizedRating.equals("r")) {
                return MPAARating.R;
            }
            if (normalizedRating.indexOf("rated nc") > -1 || normalizedRating.equals("nc-17")) {
                return MPAARating.NC17;
            }
        }
        return null;
    }
}

