/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.AbstractLocalFileExtractor;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.XPathUtil;
import org.serviio.util.XmlUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwissCenterExtractor
extends AbstractLocalFileExtractor {
    private static final NamespaceContext namespaceContext = new SwissCenterNamespaceContext();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");

    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.SWISSCENTER;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException {
        if (fileType == MediaFileType.VIDEO) {
            File folder = mediaFile.getParentFile();
            if (folder != null && folder.exists() && folder.isDirectory()) {
                String fileName = FileUtils.getFileNameWithoutExtension(mediaFile) + ".xml";
                File xmlFile = this.findFileInFolder(folder, fileName, false);
                if (xmlFile != null) {
                    boolean validFile = this.validateSwisscenterFile(xmlFile);
                    if (validFile) {
                        MetadataFile metadataFile = new MetadataFile(this.getExtractorType(), FileUtils.getLastModifiedDate(xmlFile), xmlFile.getName(), mediaFile);
                        return metadataFile;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void retrieveMetadata(LocalItemMetadata metadata, File xmlFile, File mediaFile) throws IOException, InvalidMediaFormatException {
        try {
            Node rootNode = XPathUtil.getRootNode(this.readXML(xmlFile));
            if (rootNode != null) {
                Node movieNode = XPathUtil.getNode(rootNode, "sc:movie", namespaceContext);
                Node tvNode = XPathUtil.getNode(rootNode, "sc:tv", namespaceContext);
                if (movieNode != null) {
                    this.retrieveMovieMetadata((VideoMetadata)metadata, movieNode);
                } else if (tvNode != null) {
                    this.retrieveEpisodeMetadata((VideoMetadata)metadata, tvNode);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new InvalidMediaFormatException(String.format("File '%s' couldn't be parsed: %s", xmlFile.getPath(), XPathUtil.getParseExceptionMessage(e)));
        }
    }

    private String readXML(File xmlFile) throws IOException {
        return XmlUtils.normalizeXML(StringUtils.readFileAsString(xmlFile, "UTF-8"));
    }

    private boolean validateSwisscenterFile(File xmlFile) throws IOException {
        this.log.debug(String.format("Checking if file '%s' is a Swisscenter file", xmlFile.getName()));
        try {
            Node rootNode = XPathUtil.getRootNode(this.readXML(xmlFile));
            if (rootNode != null) {
                Node movieNode = XPathUtil.getNode(rootNode, "sc:movie", namespaceContext);
                Node tvNode = XPathUtil.getNode(rootNode, "sc:tv", namespaceContext);
                if (movieNode != null || tvNode != null) {
                    this.log.debug(String.format("File '%s' is a valid Swisscenter file", xmlFile.getName()));
                    return true;
                }
            }
            this.log.debug(String.format("File '%s' is not a Swisscenter file", xmlFile.getName()));
            return false;
        }
        catch (XPathExpressionException e) {
            this.log.error(String.format("File '%s' couldn't be parsed:%s", xmlFile.getPath(), XPathUtil.getParseExceptionMessage(e)));
            return false;
        }
    }

    private void retrieveMovieMetadata(VideoMetadata metadata, Node movieNode) throws IOException, InvalidMediaFormatException {
        this.log.debug("Parsing XML file for movie metadata");
        try {
            this.retrieveSharedData(metadata, movieNode);
            metadata.setMPAARating(this.getMPAARating(movieNode));
            metadata.setContentType(ContentType.MOVIE);
            String year = StringUtils.trim(XPathUtil.getNodeValue(movieNode, "sc:year", namespaceContext));
            if (ObjectValidator.isNotEmpty(year)) {
                metadata.setDate(this.parseDate("01/01/" + year));
            }
        }
        catch (XPathExpressionException e) {
            throw new InvalidMediaFormatException(String.format("Error during parsing SwissCenter movie XML file: %s", XPathUtil.getParseExceptionMessage(e)));
        }
    }

    private void retrieveEpisodeMetadata(VideoMetadata metadata, Node tvNode) throws IOException, InvalidMediaFormatException {
        this.log.debug("Parsing XML file for TV metadata");
        try {
            this.retrieveSharedData(metadata, tvNode);
            metadata.setSeriesName(StringUtils.trim(XPathUtil.getNodeValue(tvNode, "sc:programme", namespaceContext)));
            String seasonNumber = StringUtils.trim(XPathUtil.getNodeValue(tvNode, "sc:series", namespaceContext));
            String episodeNumber = StringUtils.trim(XPathUtil.getNodeValue(tvNode, "sc:episode", namespaceContext));
            metadata.setSeasonNumber(ObjectValidator.isNotEmpty(seasonNumber) ? Integer.valueOf(seasonNumber) : null);
            metadata.setEpisodeNumber(ObjectValidator.isNotEmpty(episodeNumber) ? Integer.valueOf(episodeNumber) : null);
            metadata.setContentType(ContentType.EPISODE);
        }
        catch (XPathExpressionException e) {
            throw new InvalidMediaFormatException(String.format("Error during parsing SwissCenter TV XML file: %s", XPathUtil.getParseExceptionMessage(e)));
        }
    }

    private void retrieveSharedData(VideoMetadata metadata, Node rootNode) throws XPathExpressionException {
        metadata.setTitle(StringUtils.trim(XPathUtil.getNodeValue(rootNode, "sc:title", namespaceContext)));
        metadata.setDescription(StringUtils.trim(XPathUtil.getNodeValue(rootNode, "sc:synopsis", namespaceContext)));
        metadata.setActors(this.getActors(XPathUtil.getNodeSet(rootNode, "sc:actors/sc:actor", namespaceContext)));
        metadata.setDirectors(this.getDirectors(XPathUtil.getNodeSet(rootNode, "sc:directors/sc:director", namespaceContext)));
        metadata.setGenre(StringUtils.trim(XPathUtil.getNodeValue(rootNode, "sc:genres/sc:genre[1]", namespaceContext)));
    }

    private Date parseDate(String date) {
        if (ObjectValidator.isNotEmpty(date)) {
            try {
                return DATE_FORMAT.parse(date);
            }
            catch (ParseException e) {
                this.log.debug("Cannot parse release date: " + date);
            }
        }
        return null;
    }

    private MPAARating getMPAARating(Node movieNode) throws XPathExpressionException {
        String rating = StringUtils.trim(XPathUtil.getNodeValue(movieNode, "sc:certificates/sc:certificate[@scheme='MPAA']", namespaceContext));
        if (ObjectValidator.isNotEmpty(rating)) {
            String normalizedRating = StringUtils.localeSafeToLowercase(rating);
            if (normalizedRating.equals("pg-13")) {
                return MPAARating.PG13;
            }
            if (normalizedRating.equals("pg")) {
                return MPAARating.PG;
            }
            if (normalizedRating.equals("g")) {
                return MPAARating.G;
            }
            if (normalizedRating.equals("r")) {
                return MPAARating.R;
            }
            if (normalizedRating.equals("nc-17")) {
                return MPAARating.NC17;
            }
        }
        return null;
    }

    private List<String> getActors(NodeList actorsNodeList) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        if (actorsNodeList != null && actorsNodeList.getLength() > 0) {
            for (int i = 0; i < actorsNodeList.getLength(); ++i) {
                Node castNode = actorsNodeList.item(i);
                result.add(StringUtils.trim(XPathUtil.getNodeValue(castNode, "sc:name", namespaceContext)));
            }
        }
        return result;
    }

    private List<String> getDirectors(NodeList directorsNodeList) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        if (directorsNodeList != null && directorsNodeList.getLength() > 0) {
            for (int i = 0; i < directorsNodeList.getLength(); ++i) {
                Node castNode = directorsNodeList.item(i);
                result.add(StringUtils.trim(XPathUtil.getNodeValue(castNode, ".", namespaceContext)));
            }
        }
        return result;
    }

    private static class SwissCenterNamespaceContext
    implements NamespaceContext {
        private SwissCenterNamespaceContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("sc")) {
                return "http://www.swisscenter.co.uk";
            }
            return "";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        public Iterator<?> getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

