/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.serviio.config.Configuration;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.AbstractLocalFileExtractor;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.XPathUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MyMoviesExtractor
extends AbstractLocalFileExtractor {
    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.MYMOVIES;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException {
        if (fileType == MediaFileType.VIDEO) {
            File folder = mediaFile.getParentFile();
            if (folder != null && folder.exists() && folder.isDirectory()) {
                File xmlFile = this.findFileInFolder(folder, "mymovies.xml", true);
                if (xmlFile != null) {
                    boolean validFile = this.validateMyMoviesFile(xmlFile);
                    if (validFile) {
                        this.log.debug("Found MyMovies file. Will try to extract metadata from it.");
                        MetadataFile metadataFile = new MetadataFile(this.getExtractorType(), FileUtils.getLastModifiedDate(xmlFile), xmlFile.getName(), mediaFile);
                        return metadataFile;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void retrieveMetadata(LocalItemMetadata metadata, File xmlFile, File mediaFile) throws IOException, InvalidMediaFormatException {
        FileInputStream xmlStream;
        block7: {
            xmlStream = null;
            try {
                xmlStream = new FileInputStream(xmlFile);
                Node rootNode = XPathUtil.getRootNode(xmlStream);
                if (rootNode == null) break block7;
                VideoMetadata vd = (VideoMetadata)metadata;
                Node titleNode = XPathUtil.getNode(rootNode, "Title");
                if (Configuration.isMetadataUseOriginalTitle()) {
                    vd.setTitle(StringUtils.trim(XPathUtil.getNodeValue(titleNode, "OriginalTitle")));
                } else {
                    vd.setTitle(StringUtils.trim(XPathUtil.getNodeValue(titleNode, "LocalTitle")));
                }
                vd.setDirectors(Collections.singletonList(StringUtils.trim(XPathUtil.getNodeValue(titleNode, "Persons/Person[@Type='2'][1]/Name"))));
                vd.setActors(this.getActors(titleNode));
                vd.setDescription(StringUtils.trim(XPathUtil.getNodeValue(titleNode, "Description")));
                vd.setGenre(StringUtils.trim(XPathUtil.getNodeValue(titleNode, "Genres/Genre[1]")));
                vd.setContentType(ContentType.MOVIE);
                String imdbId = XPathUtil.getNodeValue(titleNode, "IMDB");
                if (ObjectValidator.isNotEmpty(imdbId)) {
                    vd.getOnlineIdentifiers().put(OnlineDBIdentifier.IMDB, imdbId.trim());
                }
            }
            catch (XPathExpressionException e) {
                try {
                    throw new InvalidMediaFormatException(String.format("File '%s' couldn't be parsed: %s", xmlFile.getPath(), e.getMessage()));
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(xmlStream);
                    throw throwable;
                }
            }
        }
        FileUtils.closeQuietly(xmlStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMyMoviesFile(File xmlFile) throws IOException {
        boolean bl;
        FileInputStream xmlStream;
        block5: {
            Node titleNode;
            this.log.debug(String.format("Checking if file '%s' is a MyMovies XML file", xmlFile.getName()));
            xmlStream = null;
            xmlStream = new FileInputStream(xmlFile);
            Node rootNode = XPathUtil.getRootNode(xmlStream);
            if (rootNode == null || (titleNode = XPathUtil.getNode(rootNode, "Title")) == null) break block5;
            this.log.debug(String.format("File '%s' is a valid MyMovies XML file", xmlFile.getName()));
            boolean bl2 = true;
            FileUtils.closeQuietly(xmlStream);
            return bl2;
        }
        try {
            this.log.debug(String.format("File '%s' is not a MyMovies XML file", xmlFile.getName()));
            bl = false;
        }
        catch (XPathExpressionException e) {
            boolean bl3;
            try {
                this.log.error(String.format("File '%s' couldn't be parsed: %s", xmlFile.getPath(), e.getMessage()));
                bl3 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(xmlStream);
                throw throwable;
            }
            FileUtils.closeQuietly(xmlStream);
            return bl3;
        }
        FileUtils.closeQuietly(xmlStream);
        return bl;
    }

    private List<String> getActors(Node titleNode) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        NodeList actorsNodeList = XPathUtil.getNodeSet(titleNode, "Persons/Person[@Type='1']");
        if (actorsNodeList != null && actorsNodeList.getLength() > 0) {
            for (int i = 0; i < actorsNodeList.getLength(); ++i) {
                Node personNode = actorsNodeList.item(i);
                result.add(StringUtils.trim(XPathUtil.getNodeValue(personNode, "Name")));
            }
        }
        return result;
    }
}

