/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.library.entities.MetadataExtractorConfig;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.metadata.MediaFileType;

public class MetadataExtractorFactory {
    private static MetadataExtractorFactory instance;
    private Map<MediaFileType, List<MetadataExtractor>> extractors = new HashMap<MediaFileType, List<MetadataExtractor>>();

    private MetadataExtractorFactory() {
        this.configure();
    }

    public static MetadataExtractorFactory getInstance() {
        if (instance == null) {
            instance = new MetadataExtractorFactory();
        }
        return instance;
    }

    public void configure() {
        this.extractors.clear();
        this.extractors.put(MediaFileType.AUDIO, this.buildExtractorsForMediaType(MediaFileType.AUDIO));
        this.extractors.put(MediaFileType.VIDEO, this.buildExtractorsForMediaType(MediaFileType.VIDEO));
        this.extractors.put(MediaFileType.IMAGE, this.buildExtractorsForMediaType(MediaFileType.IMAGE));
    }

    public List<MetadataExtractor> getExtractors(MediaFileType fileType) {
        return this.extractors.get((Object)fileType);
    }

    private List<MetadataExtractor> buildExtractorsForMediaType(MediaFileType type) {
        ArrayList<MetadataExtractor> extractors = new ArrayList<MetadataExtractor>();
        extractors.add(ExtractorType.EMBEDDED.getExtractorInstance());
        List<MetadataExtractorConfig> configs = MediaService.getMetadataExtractorConfigs(type);
        for (MetadataExtractorConfig config : configs) {
            extractors.add(config.getExtractorType().getExtractorInstance());
        }
        return extractors;
    }
}

