/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.IOException;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MetadataFactory;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.metadata.MediaFileType;

public abstract class MetadataExtractor {
    public LocalItemMetadata extract(File mediaFile, MediaFileType fileType, Repository repository) throws IOException, InvalidMediaFormatException, MetadataSourceNotAccessibleException {
        LocalItemMetadata metadata = MetadataFactory.getMetadataInstance(fileType);
        MetadataFile metadataFile = this.getMetadataFile(mediaFile, fileType, repository);
        if (metadataFile != null) {
            metadata.getMetadataFiles().add(metadataFile);
            this.retrieveMetadata(metadataFile, metadata);
            metadataFile = null;
            return metadata;
        }
        return null;
    }

    public abstract ExtractorType getExtractorType();

    public abstract boolean isMetadataUpdated(File var1, MediaItem var2, MetadataDescriptor var3);

    protected abstract MetadataFile getMetadataFile(File var1, MediaFileType var2, Repository var3) throws IOException, MetadataSourceNotAccessibleException;

    protected abstract void retrieveMetadata(MetadataFile var1, LocalItemMetadata var2) throws IOException, InvalidMediaFormatException, MetadataSourceNotAccessibleException;
}

