/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import org.serviio.library.local.metadata.extractor.CoverImageInFolderExtractor;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MyMoviesExtractor;
import org.serviio.library.local.metadata.extractor.SwissCenterExtractor;
import org.serviio.library.local.metadata.extractor.XBMCExtractor;
import org.serviio.library.local.metadata.extractor.embedded.EmbeddedMetadataExtractor;
import org.serviio.library.local.metadata.extractor.video.OnlineVideoSourcesMetadataExtractor;

public enum ExtractorType {
    EMBEDDED{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new EmbeddedMetadataExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 0;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return false;
        }
    }
    ,
    COVER_IMAGE_IN_FOLDER{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new CoverImageInFolderExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 10;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return false;
        }
    }
    ,
    ONLINE_VIDEO_SOURCES{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new OnlineVideoSourcesMetadataExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 1;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return true;
        }
    }
    ,
    SWISSCENTER{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new SwissCenterExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 2;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return true;
        }
    }
    ,
    XBMC{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new XBMCExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 2;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return true;
        }
    }
    ,
    MYMOVIES{

        @Override
        public MetadataExtractor getExtractorInstance() {
            return new MyMoviesExtractor();
        }

        @Override
        public int getDefaultPriority() {
            return 2;
        }

        @Override
        public boolean isDescriptiveMetadataExtractor() {
            return true;
        }
    };


    public abstract MetadataExtractor getExtractorInstance();

    public abstract int getDefaultPriority();

    public abstract boolean isDescriptiveMetadataExtractor();
}

