/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.AbstractLocalFileExtractor;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.CollectionUtils;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverImageInFolderExtractor
extends AbstractLocalFileExtractor {
    private static final Logger log = LoggerFactory.getLogger(CoverImageInFolderExtractor.class);
    private static final String[] AUDIO_FILES = new String[]{"folder.jpg", "cover.jpg", "front_cover.jpg", ".*\\[front\\].jpg", "albumart.jpg"};
    private static final String[] VIDEO_FILES = new String[]{"dvdcover.jpg", "folder.jpg", "movie.jpg", ".*poster.*.jpg"};
    private static final String[] VIDEO_FILES_EXTENSIONS = new String[]{"-poster", "-thumb"};
    private Pattern[] audioPatterns;
    private Pattern[] videoPatterns;

    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.COVER_IMAGE_IN_FOLDER;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException {
        if (fileType == MediaFileType.AUDIO || fileType == MediaFileType.VIDEO) {
            final Pattern[] regexPatterns = this.precompileRegexPatterns(mediaFile, fileType);
            File folder = mediaFile.getParentFile();
            if (folder != null && folder.exists() && folder.isDirectory()) {
                File[] foundFiles = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return CoverImageInFolderExtractor.this.fileMatches(file, regexPatterns) > -1;
                    }
                });
                if (foundFiles.length > 0) {
                    File imageFile = this.findFileByPriority(foundFiles, regexPatterns);
                    log.debug(String.format("Found cover image %s", imageFile.getName()));
                    MetadataFile metadataFile = new MetadataFile(this.getExtractorType(), FileUtils.getLastModifiedDate(imageFile), imageFile.getName(), mediaFile);
                    return metadataFile;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void retrieveMetadata(LocalItemMetadata metadata, File imageFile, File mediaFile) throws IOException, InvalidMediaFormatException {
        try {
            ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
            ImageDescriptor image = new ImageDescriptor(FileUtils.readFileBytes(imageFile), imageInfo.getMimeType());
            if (metadata instanceof AudioMetadata) {
                ((AudioMetadata)metadata).setCoverImage(image);
            } else if (metadata instanceof VideoMetadata) {
                ((VideoMetadata)metadata).setCoverImage(image);
            }
        }
        catch (ImageReadException e) {
            throw new InvalidMediaFormatException(String.format("Cannot read cover image %s: %s", imageFile.getName(), e.getMessage()));
        }
    }

    protected Pattern[] precompileRegexPatterns(File mediaFile, MediaFileType fileType) {
        Pattern[] compiledPatterns = null;
        if (fileType == MediaFileType.AUDIO) {
            if (this.audioPatterns == null) {
                this.audioPatterns = this.compilePatterns(AUDIO_FILES);
            }
            compiledPatterns = this.audioPatterns;
        } else {
            int i;
            if (this.videoPatterns == null) {
                this.videoPatterns = this.compilePatterns(VIDEO_FILES);
            }
            compiledPatterns = new Pattern[this.videoPatterns.length + VIDEO_FILES_EXTENSIONS.length + 1];
            String fileNameBase = FileUtils.getFileNameWithoutExtension(mediaFile);
            String[] fileNameBaseExtensions = CollectionUtils.concatenateArrays(new String[]{""}, VIDEO_FILES_EXTENSIONS);
            for (i = 0; i < fileNameBaseExtensions.length; ++i) {
                String extension = fileNameBaseExtensions[i];
                String literalizedFileName = Pattern.quote(fileNameBase + extension) + "\\.(jpg|tbn|thm|png)";
                compiledPatterns[i] = Pattern.compile(literalizedFileName, 2);
            }
            for (i = fileNameBaseExtensions.length; i < compiledPatterns.length; ++i) {
                compiledPatterns[i] = this.videoPatterns[i - fileNameBaseExtensions.length];
            }
        }
        return compiledPatterns;
    }

    protected int fileMatches(File f, Pattern[] regexPatterns) {
        for (int i = 0; i < regexPatterns.length; ++i) {
            Pattern pattern = regexPatterns[i];
            Matcher m = pattern.matcher(f.getName());
            if (!m.matches()) continue;
            return i;
        }
        return -1;
    }

    private Pattern[] compilePatterns(String[] patterns) {
        Pattern[] result = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            result[i] = Pattern.compile(patterns[i], 2);
        }
        return result;
    }

    private File findFileByPriority(File[] files, Pattern[] regexPatterns) {
        TreeMap<Integer, File> map = new TreeMap<Integer, File>();
        for (File file : files) {
            int index = this.fileMatches(file, regexPatterns);
            if (index <= -1) continue;
            map.put(index, file);
        }
        return map.size() > 0 ? (File)map.get(map.firstKey()) : files[0];
    }
}

