/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;
import java.util.regex.Pattern;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLocalFileExtractor
extends MetadataExtractor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isMetadataUpdated(File mediaFile, MediaItem mediaItem, MetadataDescriptor metadataDescriptor) {
        if (metadataDescriptor != null) {
            File metadataFile = new File(mediaFile.getParentFile(), metadataDescriptor.getIdentifier());
            if (metadataFile != null && metadataFile.exists()) {
                Date imageFileDate = FileUtils.getLastModifiedDate(metadataFile);
                return imageFileDate.after(metadataDescriptor.getDateUpdated());
            }
            return true;
        }
        try {
            return this.getMetadataFile(mediaFile, mediaItem.getFileType(), null) != null;
        }
        catch (IOException e) {
            return false;
        }
        catch (MetadataSourceNotAccessibleException e) {
            return false;
        }
    }

    @Override
    protected void retrieveMetadata(MetadataFile metadataDescriptor, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException, MetadataSourceNotAccessibleException {
        if (metadataDescriptor.getExtractorType() == this.getExtractorType()) {
            File mediaFile = (File)metadataDescriptor.getExtractable();
            File metadataFile = new File(mediaFile.getParentFile(), metadataDescriptor.getIdentifier());
            if (metadataFile.exists()) {
                this.retrieveMetadata(metadata, metadataFile, mediaFile);
            } else {
                this.log.warn(String.format("Metadata file '%s' has not been found", metadataFile.getPath()));
            }
        }
    }

    protected abstract void retrieveMetadata(LocalItemMetadata var1, File var2, File var3) throws IOException, InvalidMediaFormatException;

    protected File findFileInFolder(File folder, String fileName, final boolean includeHidden) {
        final Pattern fileNamePattern = Pattern.compile(Pattern.quote(fileName), 2);
        File[] foundFiles = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!includeHidden && !file.isHidden() || includeHidden) {
                    return fileNamePattern.matcher(file.getName()).matches();
                }
                return false;
            }
        });
        if (foundFiles != null && foundFiles.length > 0) {
            return foundFiles[0];
        }
        return null;
    }
}

