/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.H264Profile;
import org.serviio.dlna.SourceAspectRatio;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.library.local.H264LevelType;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.local.metadata.TransportStreamTimestamp;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.util.ObjectValidator;

public class VideoMetadata
extends LocalItemMetadata {
    private VideoContainer container;
    private Integer width;
    private Integer height;
    private Integer duration;
    private Integer channels;
    private String fps;
    private String genre;
    private Integer frequency;
    private AudioCodec audioCodec;
    private VideoCodec videoCodec;
    private String videoFourCC;
    private Integer videoStreamIndex;
    private Integer audioStreamIndex;
    private Integer bitrate;
    private Integer videoBitrate;
    private Integer audioBitrate;
    private TransportStreamTimestamp timestampType;
    private H264Profile h264Profile;
    private HashMap<H264LevelType, String> h264Levels = new HashMap();
    private String ftyp;
    private SourceAspectRatio sar;
    private List<String> actors = new ArrayList<String>();
    private List<String> directors = new ArrayList<String>();
    private List<String> producers = new ArrayList<String>();
    private MPAARating mpaaRating;
    private String seriesName;
    private Integer seasonNumber;
    private ImageDescriptor seriesCoverImage;
    private Integer episodeNumber;
    private ContentType contentType;
    private Map<OnlineDBIdentifier, String> onlineIdentifiers = new HashMap<OnlineDBIdentifier, String>();
    private List<EmbeddedSubtitles> embeddedSubtitles = new ArrayList<EmbeddedSubtitles>();

    @Override
    public void merge(LocalItemMetadata additionalMetadata) {
        if (additionalMetadata instanceof VideoMetadata) {
            VideoMetadata additionalVideoMetadata = (VideoMetadata)additionalMetadata;
            super.merge(additionalVideoMetadata);
            if (this.container == null) {
                this.setContainer(additionalVideoMetadata.getContainer());
            }
            if (this.contentType == null) {
                this.setContentType(additionalVideoMetadata.getContentType());
            }
            if (ObjectValidator.isEmpty(this.genre)) {
                this.setGenre(additionalVideoMetadata.getGenre());
            }
            if (this.audioCodec == null) {
                this.setAudioCodec(additionalVideoMetadata.getAudioCodec());
            }
            if (this.videoCodec == null) {
                this.setVideoCodec(additionalVideoMetadata.getVideoCodec());
            }
            if (this.videoFourCC == null) {
                this.setVideoFourCC(additionalVideoMetadata.getVideoFourCC());
            }
            if (this.videoStreamIndex == null) {
                this.setVideoStreamIndex(additionalVideoMetadata.getVideoStreamIndex());
            }
            if (this.audioStreamIndex == null) {
                this.setAudioStreamIndex(additionalVideoMetadata.getAudioStreamIndex());
            }
            if (this.duration == null) {
                this.setDuration(additionalVideoMetadata.getDuration());
            }
            if (this.bitrate == null) {
                this.setBitrate(additionalVideoMetadata.getBitrate());
            }
            if (this.audioBitrate == null) {
                this.setAudioBitrate(additionalVideoMetadata.getAudioBitrate());
            }
            if (this.videoBitrate == null) {
                this.setVideoBitrate(additionalVideoMetadata.getVideoBitrate());
            }
            if (this.timestampType == null) {
                this.setTimestampType(additionalVideoMetadata.getTimestampType());
            }
            if (this.h264Levels == null || this.h264Levels.size() == 0) {
                this.h264Levels.putAll(additionalVideoMetadata.getH264Levels());
            }
            if (this.h264Profile == null) {
                this.setH264Profile(additionalVideoMetadata.getH264Profile());
            }
            if (this.ftyp == null) {
                this.setFtyp(additionalVideoMetadata.getFtyp());
            }
            if (this.sar == null) {
                this.setSar(additionalVideoMetadata.getSar());
            }
            if (this.width == null) {
                this.setWidth(additionalVideoMetadata.getWidth());
            }
            if (this.height == null) {
                this.setHeight(additionalVideoMetadata.getHeight());
            }
            if (this.channels == null) {
                this.setChannels(additionalVideoMetadata.getChannels());
            }
            if (this.fps == null) {
                this.setFps(additionalVideoMetadata.getFps());
            }
            if (this.frequency == null) {
                this.setFrequency(additionalVideoMetadata.getFrequency());
            }
            if (this.actors == null || this.actors.size() == 0) {
                this.setActors(additionalVideoMetadata.getActors());
            }
            if (this.directors == null || this.directors.size() == 0) {
                this.setDirectors(additionalVideoMetadata.getDirectors());
            }
            if (this.producers == null || this.producers.size() == 0) {
                this.setProducers(additionalVideoMetadata.getProducers());
            }
            if (ObjectValidator.isEmpty(this.seriesName)) {
                this.setSeriesName(additionalVideoMetadata.getSeriesName());
            }
            if (this.seasonNumber == null) {
                this.setSeasonNumber(additionalVideoMetadata.getSeasonNumber());
            }
            if (this.episodeNumber == null) {
                this.setEpisodeNumber(additionalVideoMetadata.getEpisodeNumber());
            }
            if (this.seriesCoverImage == null) {
                this.setSeriesCoverImage(additionalVideoMetadata.getSeriesCoverImage());
            }
            if (this.onlineIdentifiers == null || this.onlineIdentifiers.size() == 0) {
                this.onlineIdentifiers.putAll(additionalVideoMetadata.getOnlineIdentifiers());
            }
            if (this.embeddedSubtitles == null || this.embeddedSubtitles.size() == 0) {
                this.embeddedSubtitles.addAll(additionalVideoMetadata.getEmbeddedSubtitles());
            }
            if (this.mpaaRating == null) {
                this.setMPAARating(additionalVideoMetadata.getMPAARating());
            }
        }
    }

    @Override
    public void fillInUnknownEntries() {
        super.fillInUnknownEntries();
        if (ObjectValidator.isEmpty(this.genre)) {
            this.setGenre("Unknown");
        }
        if (this.directors == null || this.directors.size() == 0) {
            this.setDirectors(Arrays.asList("Unknown"));
        }
        if (this.producers == null || this.producers.size() == 0) {
            this.setProducers(Arrays.asList("Unknown"));
        }
        if (this.actors == null || this.actors.size() == 0) {
            this.setActors(Arrays.asList("Unknown"));
        }
        if (this.mpaaRating == null) {
            this.setMPAARating(MPAARating.UNKNOWN);
        }
    }

    @Override
    public void validateMetadata() throws InvalidMetadataException {
        super.validateMetadata();
        if (this.contentType == null) {
            throw new InvalidMetadataException("Content type missing");
        }
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public Integer getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(Integer bitrate) {
        this.bitrate = bitrate;
    }

    public List<String> getActors() {
        return this.actors;
    }

    public void setActors(List<String> actors) {
        this.actors = actors;
    }

    public List<String> getDirectors() {
        return this.directors;
    }

    public void setDirectors(List<String> directors) {
        this.directors = directors;
    }

    public List<String> getProducers() {
        return this.producers;
    }

    public void setProducers(List<String> producers) {
        this.producers = producers;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public Integer getSeasonNumber() {
        return this.seasonNumber;
    }

    public void setSeasonNumber(Integer seasonNumber) {
        this.seasonNumber = seasonNumber;
    }

    public Integer getEpisodeNumber() {
        return this.episodeNumber;
    }

    public void setEpisodeNumber(Integer episodeNumber) {
        this.episodeNumber = episodeNumber;
    }

    public AudioCodec getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(AudioCodec audioCodec) {
        this.audioCodec = audioCodec;
    }

    public VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.videoCodec = videoCodec;
    }

    public VideoContainer getContainer() {
        return this.container;
    }

    public void setContainer(VideoContainer container) {
        this.container = container;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    public String getFps() {
        return this.fps;
    }

    public void setFps(String fps) {
        this.fps = fps;
    }

    public Integer getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(Integer videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public Integer getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(Integer audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public TransportStreamTimestamp getTimestampType() {
        return this.timestampType;
    }

    public void setTimestampType(TransportStreamTimestamp timestampType) {
        this.timestampType = timestampType;
    }

    public Integer getVideoStreamIndex() {
        return this.videoStreamIndex;
    }

    public void setVideoStreamIndex(Integer videoTrackIndex) {
        this.videoStreamIndex = videoTrackIndex;
    }

    public Integer getAudioStreamIndex() {
        return this.audioStreamIndex;
    }

    public void setAudioStreamIndex(Integer audioTrackIndex) {
        this.audioStreamIndex = audioTrackIndex;
    }

    public H264Profile getH264Profile() {
        return this.h264Profile;
    }

    public void setH264Profile(H264Profile h264Profile) {
        this.h264Profile = h264Profile;
    }

    public HashMap<H264LevelType, String> getH264Levels() {
        return this.h264Levels;
    }

    public String getFtyp() {
        return this.ftyp;
    }

    public void setFtyp(String ftyp) {
        this.ftyp = ftyp;
    }

    public Map<OnlineDBIdentifier, String> getOnlineIdentifiers() {
        return this.onlineIdentifiers;
    }

    public SourceAspectRatio getSar() {
        return this.sar;
    }

    public void setSar(SourceAspectRatio sar) {
        this.sar = sar;
    }

    public String getVideoFourCC() {
        return this.videoFourCC;
    }

    public void setVideoFourCC(String videoFourCC) {
        this.videoFourCC = videoFourCC;
    }

    public List<EmbeddedSubtitles> getEmbeddedSubtitles() {
        return this.embeddedSubtitles;
    }

    public ImageDescriptor getSeriesCoverImage() {
        return this.seriesCoverImage;
    }

    public void setSeriesCoverImage(ImageDescriptor seriesCoverImage) {
        this.seriesCoverImage = seriesCoverImage;
    }

    public MPAARating getMPAARating() {
        return this.mpaaRating;
    }

    public void setMPAARating(MPAARating mpaaRating) {
        this.mpaaRating = mpaaRating;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VideoMetadata [title=").append(this.title).append(", filePath=").append(this.filePath).append(", fileSize=").append(this.fileSize).append(", audioBitrate=").append(this.audioBitrate).append(", audioCodec=").append((Object)this.audioCodec).append(", audioStreamIndex=").append(this.audioStreamIndex).append(", bitrate=").append(this.bitrate).append(", channels=").append(this.channels).append(", container=").append((Object)this.container).append(", contentType=").append((Object)this.contentType).append(", duration=").append(this.duration).append(", episodeNumber=").append(this.episodeNumber).append(", fps=").append(this.fps).append(", frequency=").append(this.frequency).append(", h264Levels=").append(this.h264Levels).append(", h264Profile=").append((Object)this.h264Profile).append(", ftyp=").append(this.ftyp).append(", height=").append(this.height).append(", seasonNumber=").append(this.seasonNumber).append(", seriesName=").append(this.seriesName).append(", timestampType=").append((Object)this.timestampType).append(", videoBitrate=").append(this.videoBitrate).append(", videoCodec=").append((Object)this.videoCodec).append(", videoFourCC=").append(this.videoFourCC).append(", videoStreamIndex=").append(this.videoStreamIndex).append(", width=").append(this.width).append(", embeddedSubtitles=").append(this.embeddedSubtitles).append("]");
        return builder.toString();
    }
}

