/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Playlist;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.metadata.AbstractLibraryCheckerThread;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistItem;
import org.serviio.library.playlist.PlaylistParser;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistMaintainerThread
extends AbstractLibraryCheckerThread {
    private static final Logger log = LoggerFactory.getLogger(PlaylistMaintainerThread.class);
    private static final int REFRESH_INTERVAL_IN_MINUTES = 5;

    @Override
    public void run() {
        log.info("Started looking playlist changes");
        this.workerRunning = true;
        while (this.workerRunning) {
            this.searchingForFiles = true;
            List<Playlist> playlists = PlaylistService.getAllPlaylists();
            for (Playlist playlist : playlists) {
                boolean playlistUpdated = false;
                File playlistFile = new File(playlist.getFilePath());
                if (playlistFile.exists() && this.workerRunning) {
                    try {
                        if (playlist.getDateUpdated() == null || playlist.getDateUpdated().before(FileUtils.getLastModifiedDate(playlistFile))) {
                            playlistUpdated = this.addPlaylistItems(playlist, playlistFile);
                        } else if (!playlist.isAllItemsFound()) {
                            playlistUpdated = this.checkForMissingPlaylistItems(playlist);
                        }
                    }
                    catch (CannotParsePlaylistException e) {
                        log.warn("An error occured while updating playlist: ", (Object)e.getMessage());
                    }
                    catch (Exception e) {
                        log.warn("An error occured while updating playlist, will continue", (Throwable)e);
                    }
                }
                if (!playlistUpdated) continue;
                this.notifyListenersUpdate(null, playlist.getTitle());
            }
            this.searchingForFiles = false;
            try {
                if (!this.workerRunning) continue;
                this.isSleeping = true;
                Thread.sleep(300000L);
                this.isSleeping = false;
            }
            catch (InterruptedException e) {
                this.isSleeping = false;
            }
        }
        log.info("Finished looking for playlist changes");
    }

    private boolean checkForMissingPlaylistItems(Playlist playlist) throws CannotParsePlaylistException, IOException {
        log.debug(String.format("Playlist %s has unresolved items, checking if they are in the library now", playlist.getTitle()));
        ParsedPlaylist parsedPlaylist = this.parsePlaylst(playlist.getFilePath());
        List<Integer> currentItemIndexes = PlaylistService.getPlaylistItemIndices(playlist.getId());
        boolean allItemsPresent = true;
        boolean updated = false;
        for (PlaylistItem pi : parsedPlaylist.getItems()) {
            if (currentItemIndexes.contains(pi.getSequenceNumber())) continue;
            log.debug(String.format("Found playlist item that has not been added yet: %s", pi.getPath()));
            MediaItem existingMediaItem = MediaService.getMediaItem(pi.getPath(), true);
            if (existingMediaItem != null) {
                PlaylistService.addPlaylistItem(pi.getSequenceNumber(), existingMediaItem.getId(), playlist.getId());
                playlist.getFileTypes().add(existingMediaItem.getFileType());
                log.debug("Registered playlist item");
                updated = true;
                continue;
            }
            log.debug(String.format("Item '%s' cannot be resolved to an entity in the Serviio library, will try again later", pi.getPath()));
            allItemsPresent = false;
        }
        if (updated) {
            playlist.setAllItemsFound(allItemsPresent);
            PlaylistService.updatePlaylist(playlist);
        }
        return updated;
    }

    private boolean addPlaylistItems(Playlist playlist, File playlistFile) throws CannotParsePlaylistException, IOException {
        log.debug(String.format("Playlist %s has changed, updating the library", playlist.getTitle()));
        ParsedPlaylist parsedPlaylist = this.parsePlaylst(playlist.getFilePath());
        PlaylistService.removePlaylistItems(playlist.getId());
        HashSet<MediaFileType> fileTypes = new HashSet<MediaFileType>();
        boolean allItemsPresent = true;
        for (PlaylistItem pi : parsedPlaylist.getItems()) {
            MediaItem existingMediaItem = MediaService.getMediaItem(pi.getPath(), true);
            if (existingMediaItem != null) {
                PlaylistService.addPlaylistItem(pi.getSequenceNumber(), existingMediaItem.getId(), playlist.getId());
                fileTypes.add(existingMediaItem.getFileType());
                continue;
            }
            allItemsPresent = false;
        }
        playlist.setTitle(parsedPlaylist.getTitle());
        playlist.setDateUpdated(FileUtils.getLastModifiedDate(playlistFile));
        playlist.setFileTypes(fileTypes);
        playlist.setAllItemsFound(allItemsPresent);
        PlaylistService.updatePlaylist(playlist);
        return true;
    }

    private ParsedPlaylist parsePlaylst(String filePath) throws CannotParsePlaylistException, IOException {
        return PlaylistParser.getInstance().parse(filePath);
    }
}

