/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.util.ArrayList;
import java.util.List;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.ItemMetadata;
import org.serviio.util.ObjectValidator;

public abstract class LocalItemMetadata
extends ItemMetadata {
    protected long fileSize;
    protected String filePath;
    protected List<MetadataFile> metadataFiles = new ArrayList<MetadataFile>();
    private ImageDescriptor coverImage;

    public void merge(LocalItemMetadata additionalMetadata) {
        if (ObjectValidator.isEmpty(this.title)) {
            this.setTitle(additionalMetadata.getTitle());
        }
        if (ObjectValidator.isEmpty(this.author)) {
            this.setAuthor(additionalMetadata.getAuthor());
        }
        if (this.date == null) {
            this.setDate(additionalMetadata.getDate());
        }
        if (this.fileSize == 0L) {
            this.setFileSize(additionalMetadata.getFileSize());
        }
        if (ObjectValidator.isEmpty(this.filePath)) {
            this.setFilePath(additionalMetadata.getFilePath());
        }
        if (ObjectValidator.isEmpty(this.description)) {
            this.setDescription(additionalMetadata.getDescription());
        }
        if (this.coverImage == null) {
            this.setCoverImage(additionalMetadata.getCoverImage());
        }
        this.metadataFiles.addAll(additionalMetadata.getMetadataFiles());
    }

    @Override
    public void validateMetadata() throws InvalidMetadataException {
        super.validateMetadata();
        if (this.fileSize == 0L) {
            throw new InvalidMetadataException("Filesize is zero.");
        }
        if (ObjectValidator.isEmpty(this.filePath)) {
            throw new InvalidMetadataException("Filepath is empty.");
        }
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<MetadataFile> getMetadataFiles() {
        return this.metadataFiles;
    }

    public ImageDescriptor getCoverImage() {
        return this.coverImage;
    }

    public void setCoverImage(ImageDescriptor coverImage) {
        this.coverImage = coverImage;
    }
}

