/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.Playlist;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MetadataExtractorFactory;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.local.service.RepositoryService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.AbstractLibraryCheckerThread;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryUpdatesCheckerThread
extends AbstractLibraryCheckerThread {
    private static final int THREAD_SLEEP_PERIOD = 3600000;
    private static List<ExtractorType> automaticExtractors = Arrays.asList(ExtractorType.EMBEDDED, ExtractorType.COVER_IMAGE_IN_FOLDER, ExtractorType.MYMOVIES, ExtractorType.SWISSCENTER, ExtractorType.XBMC);
    private static final Logger log = LoggerFactory.getLogger(LibraryUpdatesCheckerThread.class);

    @Override
    public void run() {
        log.info("Started looking for updates to currently shared files");
        this.workerRunning = true;
        while (this.workerRunning) {
            this.searchingForFiles = true;
            List<Repository> repositories = RepositoryService.getAllRepositories();
            for (Repository repository : repositories) {
                try {
                    if (!this.workerRunning || !LibraryManager.getInstance().isRepositoryUpdatable(repository)) continue;
                    this.searchForRemovedPlaylists(repository);
                    this.searchForRemovedAndUpdatedFiles(repository);
                }
                catch (Exception e) {
                    log.warn("An error occured while scanning for items to be removed or updated, will continue", (Throwable)e);
                }
            }
            for (Repository repository : repositories) {
                try {
                    if (!this.workerRunning || !LibraryManager.getInstance().isRepositoryUpdatable(repository)) continue;
                    this.updateMetadata(repository);
                    RepositoryService.markRepositoryAsScanned(repository.getId());
                }
                catch (Exception e) {
                    log.warn("An error occured while updating metadata, will continue", (Throwable)e);
                }
            }
            this.searchingForFiles = false;
            if (Configuration.isAutomaticLibraryRefresh()) {
                try {
                    if (!this.workerRunning) continue;
                    this.isSleeping = true;
                    Thread.sleep(3600000L);
                    this.isSleeping = false;
                }
                catch (InterruptedException e) {
                    this.isSleeping = false;
                }
                continue;
            }
            this.workerRunning = false;
        }
        log.info("Finished looking for updates to currently shared files");
    }

    protected void searchForRemovedAndUpdatedFiles(Repository repository) {
        log.debug(String.format("Looking for removed/updated files in repository: %s", repository.getFolder()));
        List<MediaItem> items = MediaService.getMediaItemsInRepository(repository.getId());
        Iterator<MediaItem> itemsIt = items.iterator();
        while (this.workerRunning && itemsIt.hasNext()) {
            MediaItem item = itemsIt.next();
            File mediaFile = MediaService.getFile(item.getId());
            if (mediaFile != null && !mediaFile.exists()) {
                try {
                    log.info(String.format("Removing '%s' (%s) from Library", item.getTitle(), mediaFile.getPath()));
                    if (item.getFileType() == MediaFileType.AUDIO) {
                        AudioService.removeMusicTrackFromLibrary(item.getId());
                    } else if (item.getFileType() == MediaFileType.VIDEO) {
                        VideoService.removeVideoFromLibrary(item.getId());
                    } else {
                        ImageService.removeImageFromLibrary(item.getId());
                    }
                    this.notifyListenersRemove(item.getFileType(), mediaFile.getName());
                }
                catch (Exception e) {
                    log.warn(String.format("Cannot remove item %s from Library. Message: %s", item.getTitle(), e.getMessage()), (Throwable)e);
                }
                continue;
            }
            if (!Configuration.isSearchUpdatedFiles() || item.isDirty()) continue;
            try {
                if (mediaFile.length() != item.getFileSize().longValue()) {
                    MediaService.markMediaItemAsDirty(item.getId());
                    continue;
                }
                List<MetadataExtractor> extractors = MetadataExtractorFactory.getInstance().getExtractors(item.getFileType());
                for (MetadataExtractor extractor : extractors) {
                    MetadataDescriptor descriptor;
                    if (!this.workerRunning || !automaticExtractors.contains((Object)extractor.getExtractorType()) || !extractor.isMetadataUpdated(mediaFile, item, descriptor = MediaService.getMetadataDescriptorForMediaItem(item.getId(), extractor.getExtractorType()))) continue;
                    MediaService.markMediaItemAsDirty(item.getId());
                }
            }
            catch (Exception e) {
                log.warn(String.format("Cannot search for updated metadata for title %s. Message: %s", item.getTitle(), e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void searchForRemovedPlaylists(Repository repository) {
        log.debug(String.format("Looking for removed playlist files in repository: %s", repository.getFolder()));
        List<Playlist> playlists = PlaylistService.getPlaylistsInRepository(repository.getId());
        Iterator<Playlist> playlistIt = playlists.iterator();
        while (this.workerRunning && playlistIt.hasNext()) {
            Playlist playlist = playlistIt.next();
            File playlistFile = new File(playlist.getFilePath());
            if (playlistFile == null || playlistFile.exists()) continue;
            try {
                log.info(String.format("Removing playlist '%s' (%s) from Library", playlist.getTitle(), FileUtils.getProperFilePath(playlistFile)));
                PlaylistService.detetePlaylistAndItems(playlist.getId());
                this.notifyListenersRemove(null, playlistFile.getName());
            }
            catch (Exception e) {
                log.warn(String.format("Cannot remove playlist %s from Library. Message: %s", playlist.getTitle(), e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void updateMetadata(Repository repository) {
        List<MediaItem> mediaItems = MediaService.getDirtyMediaItemsInRepository(repository.getId());
        if (mediaItems.size() > 0) {
            log.debug(String.format("Updating dirty metadata for repository: %s", repository.getFolder()));
            Iterator<MediaItem> mediaItemsIt = mediaItems.iterator();
            while (this.workerRunning && mediaItemsIt.hasNext()) {
                MediaItem mediaItem = mediaItemsIt.next();
                try {
                    File mediaFile = MediaService.getFile(mediaItem.getId());
                    if (mediaFile == null || !mediaFile.exists()) continue;
                    MediaFileType fileType = mediaItem.getFileType();
                    LocalItemMetadata mergedMetadata = LibraryManager.getInstance().extractMetadata(mediaFile, fileType, repository);
                    if (mergedMetadata == null || !this.workerRunning) continue;
                    mergedMetadata.validateMetadata();
                    boolean updated = false;
                    if (fileType == MediaFileType.AUDIO && mergedMetadata instanceof AudioMetadata) {
                        AudioService.updateMusicTrackInLibrary((AudioMetadata)mergedMetadata, mediaItem.getId());
                        updated = true;
                    } else if (fileType == MediaFileType.VIDEO && mergedMetadata instanceof VideoMetadata) {
                        VideoService.updateVideoInLibrary((VideoMetadata)mergedMetadata, mediaItem.getId());
                        updated = true;
                    } else if (fileType == MediaFileType.IMAGE && mergedMetadata instanceof ImageMetadata) {
                        ImageService.updateImageInLibrary((ImageMetadata)mergedMetadata, mediaItem.getId());
                        updated = true;
                    } else {
                        log.error(String.format("Error during update metadata extraction for file %s. Metadata mismatch.", new Object[0]), (Object)mediaFile.getName());
                    }
                    if (!updated) continue;
                    log.info(String.format("Updated '%s' (%s) in Library", mediaItem.getTitle(), mediaFile.getPath()));
                    this.notifyListenersUpdate(fileType, mediaFile.getName());
                }
                catch (InvalidMetadataException ime) {
                    log.warn(String.format("Cannot update file %s in library because of invalid metadata. Message: %s", mediaItem.getTitle(), ime.getMessage()));
                }
                catch (Exception e) {
                    log.warn(String.format("Cannot update file %s in library because of an unexpected error. Message: %s", mediaItem.getTitle(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }
}

