/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.LibraryManager;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.local.service.RepositoryService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.AbstractLibraryCheckerThread;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.playlist.CannotParsePlaylistException;
import org.serviio.library.playlist.ParsedPlaylist;
import org.serviio.library.playlist.PlaylistParser;
import org.serviio.library.playlist.PlaylistType;
import org.serviio.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryAdditionsCheckerThread
extends AbstractLibraryCheckerThread {
    private static final Logger log = LoggerFactory.getLogger(LibraryAdditionsCheckerThread.class);

    @Override
    public void run() {
        log.info("Started looking for newly added files");
        this.workerRunning = true;
        while (this.workerRunning) {
            this.searchingForFiles = true;
            this.notifyListenersResetForAdding();
            List<Repository> repositories = RepositoryService.getAllRepositories();
            for (Repository repository : repositories) {
                try {
                    if (!this.workerRunning || !LibraryManager.getInstance().isRepositoryUpdatable(repository)) continue;
                    this.searchForNewFiles(repository.getFolder(), repository);
                    RepositoryService.markRepositoryAsScanned(repository.getId());
                }
                catch (Exception e) {
                    log.warn("An error occured while scanning for item to be added, will continue", (Throwable)e);
                }
            }
            this.searchingForFiles = false;
            if (Configuration.isAutomaticLibraryRefresh()) {
                try {
                    if (!this.workerRunning) continue;
                    this.isSleeping = true;
                    Thread.sleep(Configuration.getAutomaticLibraryRefreshInterval() * 60 * 1000);
                    this.isSleeping = false;
                }
                catch (InterruptedException e) {
                    this.isSleeping = false;
                }
                continue;
            }
            this.workerRunning = false;
        }
        log.info("Finished looking for newly added files");
    }

    protected void searchForNewFiles(File folder, Repository repository) {
        boolean searchHidden = Configuration.isSearchHiddenFiles();
        if (this.workerRunning) {
            if (folder.isDirectory() && folder.canRead()) {
                log.debug(String.format("Looking for files to share in folder: %s", folder.getAbsolutePath()));
                File[] files = folder.listFiles();
                int i = 0;
                while (this.workerRunning && files != null && i < files.length) {
                    File file;
                    if ((file = files[i++]).isDirectory()) {
                        if (!this.fileIsVisible(searchHidden, file)) continue;
                        this.searchForNewFiles(file, repository);
                        continue;
                    }
                    try {
                        if (!this.fileIsVisible(searchHidden, file)) continue;
                        String fileExtension = FileUtils.getFileExtension(file);
                        MediaFileType fileType = MediaFileType.findMediaFileTypeByExtension(fileExtension);
                        if (fileType != null && repository.getSupportedFileTypes().contains((Object)fileType)) {
                            this.addNewMediaFile(repository, file, fileType);
                            continue;
                        }
                        if (fileType != null || !PlaylistType.playlistTypeExtensionSupported(fileExtension)) continue;
                        this.addNewPlaylistFile(repository, file);
                    }
                    catch (InvalidMetadataException ime) {
                        log.warn(String.format("Cannot add file %s because of invalid metadata. Message: %s", file.getName(), ime.getMessage()));
                    }
                    catch (CannotParsePlaylistException cppe) {
                        log.warn(String.format("Cannot add playlist file %s. Message: %s", file.getName(), cppe.getMessage()), (Throwable)cppe);
                    }
                    catch (Exception e) {
                        log.warn(String.format("Cannot add file %s because of an unexpected error. Message: %s", file.getName(), e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                log.warn(String.format("Folder '%s' is either not an existing directory or cannot be read due to access rights", folder.getAbsolutePath()));
            }
        }
    }

    private void addNewMediaFile(Repository repository, File file, MediaFileType fileType) throws InvalidMetadataException {
        log.debug(String.format("Found file '%s', checking if it's already in the Library", file.getName()));
        boolean mediaPresent = MediaService.isMediaPresentInLibrary(file);
        if (!mediaPresent && file.exists() && this.workerRunning) {
            if (file.canRead()) {
                log.debug("File not in Library, will add it");
                LocalItemMetadata mergedMetadata = LibraryManager.getInstance().extractMetadata(file, fileType, repository);
                if (mergedMetadata != null && this.workerRunning) {
                    mergedMetadata.validateMetadata();
                    boolean newAdded = false;
                    if (fileType == MediaFileType.AUDIO && mergedMetadata instanceof AudioMetadata) {
                        AudioService.addMusicTrackToLibrary((AudioMetadata)mergedMetadata, repository);
                        newAdded = true;
                    } else if (fileType == MediaFileType.VIDEO && mergedMetadata instanceof VideoMetadata) {
                        VideoService.addVideoToLibrary((VideoMetadata)mergedMetadata, repository);
                        newAdded = true;
                    } else if (fileType == MediaFileType.IMAGE && mergedMetadata instanceof ImageMetadata) {
                        ImageService.addImageToLibrary((ImageMetadata)mergedMetadata, repository);
                        newAdded = true;
                    } else {
                        log.error(String.format("Error during metadata extraction for file %s. Metadata mismatch.", new Object[0]), (Object)file.getName());
                    }
                    if (newAdded) {
                        log.info(String.format("Added file '%s' (title: %s) to Library", file.getName(), mergedMetadata.getTitle()));
                        this.notifyListenersAdd(fileType, file.getName());
                    }
                }
            } else {
                log.warn(String.format("File '%s' cannot be read, probably due to access rights", file.getAbsolutePath()));
            }
        }
    }

    private void addNewPlaylistFile(Repository repository, File file) throws CannotParsePlaylistException, IOException {
        log.debug(String.format("Found playlist file '%s', checking if it's already in the Library", file.getName()));
        boolean playlistPresent = PlaylistService.isPlaylistInLibrary(file);
        if (!playlistPresent && file.exists() && this.workerRunning) {
            if (file.canRead()) {
                log.debug("Playlist file not in Library, will add it");
                String playlistFilePath = FileUtils.getProperFilePath(file);
                ParsedPlaylist playlist = PlaylistParser.getInstance().parse(playlistFilePath);
                if (playlist != null) {
                    PlaylistService.addPlaylistToLibrary(playlist, repository, playlistFilePath, null);
                    log.info(String.format("Added playlist '%s' (title: %s) to Library", file.getName(), playlist.getTitle()));
                    this.notifyListenersAdd(null, file.getName());
                }
            } else {
                log.warn(String.format("Playlist file '%s' cannot be read, probably due to access rights", file.getAbsolutePath()));
            }
        }
    }

    private boolean fileIsVisible(boolean searchHidden, File file) {
        return searchHidden || !searchHidden && !file.isHidden();
    }
}

