/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.SamplingMode;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.metadata.InvalidMetadataException;

public class ImageMetadata
extends LocalItemMetadata {
    private ImageContainer container;
    private Integer width;
    private Integer height;
    private Integer colorDepth;
    private Integer exifRotation;
    private SamplingMode chromaSubsampling;

    @Override
    public void merge(LocalItemMetadata additionalMetadata) {
        if (additionalMetadata instanceof ImageMetadata) {
            ImageMetadata additionalImageMetadata = (ImageMetadata)additionalMetadata;
            super.merge(additionalImageMetadata);
            if (this.container == null) {
                this.setContainer(additionalImageMetadata.getContainer());
            }
            if (this.width == null) {
                this.setWidth(additionalImageMetadata.getWidth());
            }
            if (this.height == null) {
                this.setHeight(additionalImageMetadata.getHeight());
            }
            if (this.colorDepth == null) {
                this.setColorDepth(additionalImageMetadata.getColorDepth());
            }
            if (this.exifRotation == null) {
                this.setExifRotation(additionalImageMetadata.getExifRotation());
            }
            if (this.chromaSubsampling == null) {
                this.setChromaSubsampling(additionalImageMetadata.getChromaSubsampling());
            }
        }
    }

    @Override
    public void fillInUnknownEntries() {
        super.fillInUnknownEntries();
    }

    @Override
    public void validateMetadata() throws InvalidMetadataException {
        super.validateMetadata();
        if (this.container == null) {
            throw new InvalidMetadataException("Unknown image file type.");
        }
        if (this.width == null) {
            throw new InvalidMetadataException("Unknown image width.");
        }
        if (this.height == null) {
            throw new InvalidMetadataException("Unknown image height.");
        }
    }

    public Integer getColorDepth() {
        return this.colorDepth;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }

    public ImageContainer getContainer() {
        return this.container;
    }

    public void setContainer(ImageContainer container) {
        this.container = container;
    }

    public Integer getExifRotation() {
        return this.exifRotation;
    }

    public void setExifRotation(Integer exifRotation) {
        this.exifRotation = exifRotation;
    }

    public SamplingMode getChromaSubsampling() {
        return this.chromaSubsampling;
    }

    public void setChromaSubsampling(SamplingMode chromaSubsampling) {
        this.chromaSubsampling = chromaSubsampling;
    }

    public String toString() {
        return String.format("ImageMetadata [title=%s, date=%s, filePath=%s, fileSize=%s, container=%s, width=%s, height=%s, colorDepth=%s, sampling=%s]", new Object[]{this.title, this.date, this.filePath, this.fileSize, this.container, this.width, this.height, this.colorDepth, this.chromaSubsampling});
    }
}

