/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import java.net.URL;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDescriptor {
    private static final Logger log = LoggerFactory.getLogger(ImageDescriptor.class);
    private byte[] imageData;
    private URL imageUrl;
    private String mimeType;
    private Integer width;
    private Integer height;

    public ImageDescriptor(byte[] imageData, String mimeType) {
        this.imageData = imageData;
        this.mimeType = mimeType;
    }

    public ImageDescriptor(Integer width, Integer height, byte[] imageData) {
        this.width = width;
        this.height = height;
        this.imageData = imageData;
    }

    public ImageDescriptor(byte[] imageData) {
        try {
            ImageInfo imageInfo = Imaging.getImageInfo((byte[])imageData);
            this.width = imageInfo.getWidth();
            this.height = imageInfo.getHeight();
            this.mimeType = imageInfo.getMimeType();
        }
        catch (Exception e) {
            log.warn("Error retrieving image data: " + e.getMessage());
        }
        this.imageData = imageData;
    }

    public ImageDescriptor(URL imageUrl) {
        this.imageUrl = imageUrl;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setImageUrl(URL imageUrl) {
        this.imageUrl = imageUrl;
    }
}

