/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata;

import org.serviio.dlna.AudioContainer;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.util.ObjectValidator;

public class AudioMetadata
extends LocalItemMetadata {
    private AudioContainer container;
    private String genre;
    private Integer releaseYear;
    private String album;
    private Integer trackNumber;
    private Integer duration;
    private String albumArtist;
    private String artist;
    private Integer discNumber;
    private Integer bitrate;
    private Integer channels;
    private Integer sampleFrequency;

    @Override
    public void merge(LocalItemMetadata additionalMetadata) {
        if (additionalMetadata instanceof AudioMetadata) {
            AudioMetadata additionalAudioMetadata = (AudioMetadata)additionalMetadata;
            super.merge(additionalAudioMetadata);
            if (this.container == null) {
                this.setContainer(additionalAudioMetadata.getContainer());
            }
            if (ObjectValidator.isEmpty(this.genre)) {
                this.setGenre(additionalAudioMetadata.getGenre());
            }
            if (this.releaseYear == null) {
                this.setReleaseYear(additionalAudioMetadata.getReleaseYear());
            }
            if (ObjectValidator.isEmpty(this.album)) {
                this.setAlbum(additionalAudioMetadata.getAlbum());
            }
            if (this.trackNumber == null) {
                this.setTrackNumber(additionalAudioMetadata.getTrackNumber());
            }
            if (this.duration == null) {
                this.setDuration(additionalAudioMetadata.getDuration());
            }
            if (ObjectValidator.isEmpty(this.albumArtist)) {
                this.setAlbumArtist(additionalAudioMetadata.getAlbumArtist());
            }
            if (ObjectValidator.isEmpty(this.artist)) {
                this.setArtist(additionalAudioMetadata.getArtist());
            }
            if (this.bitrate == null) {
                this.setBitrate(additionalAudioMetadata.getBitrate());
            }
            if (this.channels == null) {
                this.setChannels(additionalAudioMetadata.getChannels());
            }
            if (this.sampleFrequency == null) {
                this.setSampleFrequency(additionalAudioMetadata.getSampleFrequency());
            }
            if (this.discNumber == null) {
                this.setDiscNumber(additionalAudioMetadata.getDiscNumber());
            }
        }
    }

    @Override
    public void fillInUnknownEntries() {
        super.fillInUnknownEntries();
        if (ObjectValidator.isEmpty(this.genre)) {
            this.setGenre("Unknown");
        }
        if (ObjectValidator.isEmpty(this.album)) {
            this.setAlbum("Unknown");
        }
        if (ObjectValidator.isEmpty(this.albumArtist)) {
            if (ObjectValidator.isEmpty(this.artist)) {
                this.setAlbumArtist("Unknown");
            } else {
                this.setAlbumArtist(this.artist);
            }
        }
        if (ObjectValidator.isEmpty(this.artist)) {
            this.setArtist("Unknown");
        }
    }

    @Override
    public void validateMetadata() throws InvalidMetadataException {
        super.validateMetadata();
        if (this.container == null) {
            throw new InvalidMetadataException("Unknown audio file type.");
        }
        if (this.bitrate == null) {
            throw new InvalidMetadataException("Unknown bit rate.");
        }
    }

    public String getGenre() {
        return this.genre;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public Integer getReleaseYear() {
        return this.releaseYear;
    }

    public void setReleaseYear(Integer year) {
        this.releaseYear = year;
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public Integer getTrackNumber() {
        return this.trackNumber;
    }

    public void setTrackNumber(Integer trackNumber) {
        this.trackNumber = trackNumber;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public void setAlbumArtist(String albumArtist) {
        this.albumArtist = albumArtist;
    }

    public Integer getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(Integer bitrate) {
        this.bitrate = bitrate;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    public Integer getSampleFrequency() {
        return this.sampleFrequency;
    }

    public void setSampleFrequency(Integer sampleFrequency) {
        this.sampleFrequency = sampleFrequency;
    }

    public AudioContainer getContainer() {
        return this.container;
    }

    public void setContainer(AudioContainer container) {
        this.container = container;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public Integer getDiscNumber() {
        return this.discNumber;
    }

    public void setDiscNumber(Integer discNumber) {
        if (discNumber != null && discNumber < Short.MAX_VALUE) {
            this.discNumber = discNumber;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AudioMetadata [container=").append((Object)this.container).append(", genre=").append(this.genre).append(", releaseYear=").append(this.releaseYear).append(", album=").append(this.album).append(", trackNumber=").append(this.trackNumber).append(", duration=").append(this.duration).append(", albumArtist=").append(this.albumArtist).append(", artist=").append(this.artist).append(", discNumber=").append(this.discNumber).append(", bitrate=").append(this.bitrate).append(", channels=").append(this.channels).append(", sampleFrequency=").append(this.sampleFrequency).append("]");
        return builder.toString();
    }
}

