/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.library.AbstractLibraryManager;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.metadata.CDSLibraryIndexingListener;
import org.serviio.library.local.metadata.LibraryAdditionsCheckerThread;
import org.serviio.library.local.metadata.LibraryUpdatesCheckerThread;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.MetadataFactory;
import org.serviio.library.local.metadata.PlaylistMaintainerThread;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MetadataExtractorFactory;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.metadata.MediaFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryManager
extends AbstractLibraryManager {
    private static final Logger log = LoggerFactory.getLogger(LibraryManager.class);
    private static LibraryManager instance;
    private LibraryUpdatesCheckerThread libraryUpdatesCheckerThread;
    private LibraryAdditionsCheckerThread libraryAdditionsCheckerThread;
    private PlaylistMaintainerThread playlistMaintainerThread;
    private boolean updatePaused = false;

    public static LibraryManager getInstance() {
        if (instance == null) {
            instance = new LibraryManager();
        }
        return instance;
    }

    private LibraryManager() {
        this.cdsListener = new CDSLibraryIndexingListener();
    }

    public synchronized void startLibraryUpdatesCheckerThread() {
        if ((this.libraryUpdatesCheckerThread == null || this.libraryUpdatesCheckerThread != null && !this.libraryUpdatesCheckerThread.isWorkerRunning()) && !this.updatePaused) {
            this.libraryUpdatesCheckerThread = new LibraryUpdatesCheckerThread();
            this.libraryUpdatesCheckerThread.setName("LibraryUpdatesCheckerThread");
            this.libraryUpdatesCheckerThread.setDaemon(true);
            this.libraryUpdatesCheckerThread.setPriority(1);
            this.libraryUpdatesCheckerThread.addListener(this.cdsListener);
            this.libraryUpdatesCheckerThread.start();
        }
    }

    public synchronized void startLibraryAdditionsCheckerThread() {
        if ((this.libraryAdditionsCheckerThread == null || this.libraryAdditionsCheckerThread != null && !this.libraryAdditionsCheckerThread.isWorkerRunning()) && !this.updatePaused) {
            this.libraryAdditionsCheckerThread = new LibraryAdditionsCheckerThread();
            this.libraryAdditionsCheckerThread.setName("LibraryAdditionsCheckerThread");
            this.libraryAdditionsCheckerThread.setDaemon(true);
            this.libraryAdditionsCheckerThread.setPriority(2);
            this.libraryAdditionsCheckerThread.addListener(this.cdsListener);
            this.libraryAdditionsCheckerThread.start();
        }
    }

    public synchronized void startPlaylistMaintainerThread() {
        if ((this.playlistMaintainerThread == null || this.playlistMaintainerThread != null && !this.playlistMaintainerThread.isWorkerRunning()) && !this.updatePaused) {
            this.playlistMaintainerThread = new PlaylistMaintainerThread();
            this.playlistMaintainerThread.setName("PlaylistMaintainerThread");
            this.playlistMaintainerThread.setDaemon(true);
            this.playlistMaintainerThread.setPriority(2);
            this.playlistMaintainerThread.addListener(this.cdsListener);
            this.playlistMaintainerThread.start();
        }
    }

    public synchronized void stopLibraryUpdatesCheckerThread() {
        this.stopThread(this.libraryUpdatesCheckerThread);
        this.libraryUpdatesCheckerThread = null;
    }

    public synchronized void stopLibraryAdditionsCheckerThread() {
        this.stopThread(this.libraryAdditionsCheckerThread);
        this.libraryAdditionsCheckerThread = null;
    }

    public synchronized void stopPlaylistMaintainerThread() {
        this.stopThread(this.playlistMaintainerThread);
        this.playlistMaintainerThread = null;
    }

    public synchronized void pauseUpdates() {
        this.updatePaused = true;
        this.stopLibraryAdditionsCheckerThread();
        this.stopLibraryUpdatesCheckerThread();
        this.stopPlaylistMaintainerThread();
    }

    public synchronized void resumeUpdates() {
        this.updatePaused = false;
        if (Configuration.isAutomaticLibraryRefresh()) {
            this.startLibraryAdditionsCheckerThread();
            this.startLibraryUpdatesCheckerThread();
        }
        this.startPlaylistMaintainerThread();
    }

    public boolean isAdditionsInProcess() {
        return this.libraryAdditionsCheckerThread != null && this.libraryAdditionsCheckerThread.isSearchingForFiles();
    }

    public boolean isUpdatesInProcess() {
        return this.libraryUpdatesCheckerThread != null && this.libraryUpdatesCheckerThread.isSearchingForFiles();
    }

    public String getLastAddedFileName() {
        return ((CDSLibraryIndexingListener)this.cdsListener).getLastAddedFile();
    }

    public Integer getNumberOfRecentlyAddedFiles() {
        return ((CDSLibraryIndexingListener)this.cdsListener).getNumberOfAddedFiles();
    }

    public String getUpdateId(MediaFileType fileType) {
        return ((CDSLibraryIndexingListener)this.cdsListener).getUpdateId(fileType);
    }

    public LocalItemMetadata extractMetadata(File mediaFile, MediaFileType fileType, Repository repository) {
        List<MetadataExtractor> extractors = MetadataExtractorFactory.getInstance().getExtractors(fileType);
        ArrayList<LocalItemMetadata> metadataList = new ArrayList<LocalItemMetadata>(extractors.size());
        boolean dirtyMetadata = false;
        for (MetadataExtractor extractor : extractors) {
            try {
                LocalItemMetadata metadata;
                if (!this.isExtractorSupportedByRepository(extractor, repository) || (metadata = extractor.extract(mediaFile, fileType, repository)) == null) continue;
                log.debug(String.format("Metadata found via extractor %s: %s", new Object[]{extractor.getExtractorType(), metadata.toString()}));
                metadataList.add(metadata);
            }
            catch (MetadataSourceNotAccessibleException e) {
                log.warn(String.format("Extractor %s failed to connect to metadata source for file %s, will try again later: %s", new Object[]{extractor.getExtractorType(), mediaFile.getPath(), e.getMessage()}));
                dirtyMetadata = true;
            }
            catch (InvalidMediaFormatException e) {
                if (extractor.getExtractorType() == ExtractorType.EMBEDDED) {
                    log.warn(String.format("Skipping processing metadata for an unsupported file (%s). Message: %s", mediaFile.getPath(), e.getMessage()));
                    return null;
                }
                log.debug(String.format("Skipping processing metadata for an unsupported file (%s). Message: %s", mediaFile.getPath(), e.getMessage()));
            }
            catch (IOException e) {
                log.warn(String.format("Cannot read metadata of file %s via extractor %s. Message: %s", new Object[]{mediaFile.getPath(), extractor.getExtractorType(), e.getMessage()}));
                if (extractor.getExtractorType() != ExtractorType.EMBEDDED) continue;
                return null;
            }
        }
        LocalItemMetadata mergedMetadata = this.mergeMetadata(metadataList, fileType, dirtyMetadata);
        return mergedMetadata;
    }

    public void forceMetadataUpdate(MediaFileType fileType) {
        log.info(String.format("Forcing metadata update for '%s' media files", new Object[]{fileType}));
        MediaService.markMediaItemsAsDirty(fileType);
    }

    public boolean isRepositoryUpdatable(Repository rep) {
        if (rep.getLastScanned() == null) {
            return true;
        }
        return rep.isKeepScanningForUpdates();
    }

    protected LocalItemMetadata mergeMetadata(List<LocalItemMetadata> metadataList, MediaFileType fileType, boolean dirtyMetadata) {
        LocalItemMetadata mergedMetadata = MetadataFactory.getMetadataInstance(fileType);
        Collections.reverse(metadataList);
        for (LocalItemMetadata metadata : metadataList) {
            mergedMetadata.merge(metadata);
        }
        mergedMetadata.fillInUnknownEntries();
        mergedMetadata.setDirty(dirtyMetadata);
        return mergedMetadata;
    }

    private boolean isExtractorSupportedByRepository(MetadataExtractor extractor, Repository repository) {
        if (extractor.getExtractorType().isDescriptiveMetadataExtractor()) {
            return repository.isSupportsDescriptiveMetadata();
        }
        return true;
    }
}

