/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local;

import java.util.ArrayList;
import java.util.List;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.util.CollectionUtils;
import org.serviio.util.ObjectValidator;

public class EmbeddedSubtitles {
    private final Integer streamId;
    private final SubtitleCodec codec;
    private final String languageCode;
    private final boolean defaultLanguage;

    public EmbeddedSubtitles(Integer streamId, SubtitleCodec codec, String languageCode, boolean defaultLanguage) {
        this.streamId = streamId;
        this.codec = codec;
        this.languageCode = languageCode;
        this.defaultLanguage = defaultLanguage;
    }

    public static List<EmbeddedSubtitles> fromString(String databaseString) {
        ArrayList<EmbeddedSubtitles> result = new ArrayList<EmbeddedSubtitles>();
        if (ObjectValidator.isNotEmpty(databaseString)) {
            List<String> subsDefs = CollectionUtils.csvToList(databaseString, ",", true);
            for (String subDef : subsDefs) {
                String[] def = subDef.split("/");
                if (def.length != 4) {
                    return null;
                }
                Integer streamId = Integer.parseInt(def[0]);
                SubtitleCodec codec = SubtitleCodec.valueOf(def[1]);
                String languageCode = def[2];
                boolean defaultLanguage = Boolean.valueOf(def[3]);
                result.add(new EmbeddedSubtitles(streamId, codec, languageCode, defaultLanguage));
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append(this.streamId).append("/").append(this.codec.toString()).append("/").append(this.languageCode == null ? "" : this.languageCode).append("/").append(this.defaultLanguage).toString();
    }

    public Integer getStreamId() {
        return this.streamId;
    }

    public SubtitleCodec getCodec() {
        return this.codec;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public boolean isDefaultLanguage() {
        return this.defaultLanguage;
    }
}

