/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.entities;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.ObjectValidator;

public class Repository
extends PersistedEntity {
    private File folder;
    private Set<MediaFileType> supportedFileTypes;
    private boolean supportsDescriptiveMetadata;
    private boolean keepScanningForUpdates;
    private Date lastScanned;
    private List<Long> accessGroupIds;

    public Repository(File folder, Set<MediaFileType> supportedFileTypes, boolean supportsDescriptiveMetadata, boolean keepScanningForUpdates) {
        this.folder = folder;
        this.supportedFileTypes = supportedFileTypes;
        this.supportsDescriptiveMetadata = supportsDescriptiveMetadata;
        this.keepScanningForUpdates = keepScanningForUpdates;
    }

    public String getRepositoryName() {
        return ObjectValidator.isNotEmpty(this.folder.getName()) ? this.folder.getName() : this.folder.getPath();
    }

    public File getFolder() {
        return this.folder;
    }

    public Set<MediaFileType> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    public boolean isSupportsDescriptiveMetadata() {
        return this.supportsDescriptiveMetadata;
    }

    public boolean isKeepScanningForUpdates() {
        return this.keepScanningForUpdates;
    }

    public Date getLastScanned() {
        return this.lastScanned;
    }

    public void setLastScanned(Date lastScanned) {
        this.lastScanned = lastScanned;
    }

    public List<Long> getAccessGroupIds() {
        return this.accessGroupIds;
    }

    public void setAccessGroupIds(List<Long> accessGroupIds) {
        this.accessGroupIds = accessGroupIds;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Repository [id=").append(this.id).append(", folder=").append(this.folder).append(", keepScanningForUpdates=").append(this.keepScanningForUpdates).append(", lastScanned=").append(this.lastScanned).append(", supportedFileTypes=").append(this.supportedFileTypes).append(", supportsDescriptiveMetadata=").append(this.supportsDescriptiveMetadata).append("]");
        return builder.toString();
    }
}

