/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.H264Profile;
import org.serviio.dlna.SourceAspectRatio;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.VideoDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Person;
import org.serviio.library.entities.Video;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.library.local.H264LevelType;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.local.metadata.TransportStreamTimestamp;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.CollectionUtils;
import org.serviio.util.DateUtils;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoDAOImpl
extends AbstractSortableItemDao
implements VideoDAO {
    private static final Logger log = LoggerFactory.getLogger(VideoDAOImpl.class);

    @Override
    public long create(Video newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getTitle()) || ObjectValidator.isEmpty(newInstance.getFileName()) || newInstance.getFileSize() == null || newInstance.getFolderId() == null) {
            throw new InvalidArgumentException("Cannot create Video. Required data is missing.");
        }
        log.debug(String.format("Creating a new Video (title = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO media_item (file_type, title, genre_id, duration, file_size, file_name, folder_id, container, creation_date,cover_image_id, bitrate, description, sort_title, width, height, rating,order_number, season_number, series_id, acodec, vcodec, channels, fps, sample_frequency,content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, ftyp, file_path, repository_id, online_identifiers, sar, vfourcc, embedded_subtitles,release_year,dirty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, JdbcUtils.trimToMaxLength(newInstance.getTitle(), 128));
            JdbcUtils.setLongValueOnStatement(ps, 3, newInstance.getGenreId());
            JdbcUtils.setIntValueOnStatement(ps, 4, newInstance.getDuration());
            ps.setLong(5, newInstance.getFileSize());
            ps.setString(6, newInstance.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 7, newInstance.getFolderId());
            ps.setString(8, newInstance.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 9, newInstance.getDate());
            JdbcUtils.setLongValueOnStatement(ps, 10, newInstance.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 11, newInstance.getBitrate());
            JdbcUtils.setStringValueOnStatement(ps, 12, newInstance.getDescription());
            ps.setString(13, JdbcUtils.trimToMaxLength(this.createSortName(newInstance.getTitle()), 128));
            JdbcUtils.setIntValueOnStatement(ps, 14, newInstance.getWidth());
            JdbcUtils.setIntValueOnStatement(ps, 15, newInstance.getHeight());
            JdbcUtils.setStringValueOnStatement(ps, 16, newInstance.getRating().name());
            JdbcUtils.setIntValueOnStatement(ps, 17, newInstance.getEpisodeNumber());
            JdbcUtils.setIntValueOnStatement(ps, 18, newInstance.getSeasonNumber());
            JdbcUtils.setLongValueOnStatement(ps, 19, newInstance.getSeriesId());
            JdbcUtils.setStringValueOnStatement(ps, 20, newInstance.getAudioCodec() != null ? newInstance.getAudioCodec().toString() : null);
            JdbcUtils.setStringValueOnStatement(ps, 21, newInstance.getVideoCodec().toString());
            JdbcUtils.setIntValueOnStatement(ps, 22, newInstance.getChannels());
            JdbcUtils.setStringValueOnStatement(ps, 23, JdbcUtils.trimToMaxLength(newInstance.getFps(), 10));
            JdbcUtils.setIntValueOnStatement(ps, 24, newInstance.getFrequency());
            JdbcUtils.setStringValueOnStatement(ps, 25, newInstance.getContentType().toString());
            JdbcUtils.setStringValueOnStatement(ps, 26, newInstance.getTimestampType() != null ? newInstance.getTimestampType().toString() : null);
            JdbcUtils.setIntValueOnStatement(ps, 27, newInstance.getAudioBitrate());
            JdbcUtils.setIntValueOnStatement(ps, 28, newInstance.getAudioStreamIndex());
            JdbcUtils.setIntValueOnStatement(ps, 29, newInstance.getVideoStreamIndex());
            JdbcUtils.setStringValueOnStatement(ps, 30, newInstance.getH264Profile() != null ? newInstance.getH264Profile().toString() : null);
            JdbcUtils.setStringValueOnStatement(ps, 31, H264LevelType.parseToString(newInstance.getH264Levels()));
            JdbcUtils.setStringValueOnStatement(ps, 32, newInstance.getFtyp());
            ps.setString(33, newInstance.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 34, newInstance.getRepositoryId());
            JdbcUtils.setStringValueOnStatement(ps, 35, OnlineDBIdentifier.parseToString(newInstance.getOnlineIdentifiers()));
            JdbcUtils.setStringValueOnStatement(ps, 36, newInstance.getSar() != null ? newInstance.getSar().toString() : null);
            JdbcUtils.setStringValueOnStatement(ps, 37, JdbcUtils.trimToMaxLength(newInstance.getVideoFourCC(), 6));
            JdbcUtils.setStringValueOnStatement(ps, 38, CollectionUtils.listToCSV(newInstance.getEmbeddedSubtitles(), ",", true));
            ps.setInt(39, newInstance.getReleaseYear());
            ps.setInt(40, newInstance.isDirty() ? 1 : 0);
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Video with title %s", newInstance.getTitle()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a Video (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete Video with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Video read(Long id) throws PersistenceException {
        Video video;
        log.debug(String.format("Reading a Video (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels,fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, repository_id, online_identifiers, sar, vfourcc, embedded_subtitles,release_year FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            video = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Video with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return video;
    }

    @Override
    public void update(Video transientObject) throws InvalidArgumentException, PersistenceException {
        if (transientObject == null || transientObject.getId() == null || ObjectValidator.isEmpty(transientObject.getTitle()) || ObjectValidator.isEmpty(transientObject.getFileName()) || transientObject.getFileSize() == null || transientObject.getFolderId() == null) {
            throw new InvalidArgumentException("Cannot update Video. Required data is missing.");
        }
        log.debug(String.format("Updating Video (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET title = ?, file_size = ?, file_name = ?, folder_id = ?, container =?, creation_date = ?, description = ?, width = ?, height = ?, genre_id = ?, duration = ?, bitrate = ?, rating = ?, sort_title = ?, cover_image_id = ?, order_number = ?, season_number = ?, series_id = ?, dirty = ?, acodec = ?, vcodec = ?, channels = ?, fps = ?, sample_frequency = ?, content_type = ?, timestamp_type = ?, audio_bitrate = ?,audio_stream_index = ?, video_stream_index = ?, h264_profile = ?, h264_level = ?, ftyp = ?, file_path = ?,repository_id = ?, online_identifiers = ?, sar = ?, vfourcc = ?, embedded_subtitles = ?, release_year = ? WHERE id = ?");
            ps.setString(1, JdbcUtils.trimToMaxLength(transientObject.getTitle(), 128));
            ps.setLong(2, transientObject.getFileSize());
            ps.setString(3, transientObject.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 4, transientObject.getFolderId());
            ps.setString(5, transientObject.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 6, transientObject.getDate());
            JdbcUtils.setStringValueOnStatement(ps, 7, transientObject.getDescription());
            JdbcUtils.setIntValueOnStatement(ps, 8, transientObject.getWidth());
            JdbcUtils.setIntValueOnStatement(ps, 9, transientObject.getHeight());
            JdbcUtils.setLongValueOnStatement(ps, 10, transientObject.getGenreId());
            JdbcUtils.setIntValueOnStatement(ps, 11, transientObject.getDuration());
            JdbcUtils.setIntValueOnStatement(ps, 12, transientObject.getBitrate());
            JdbcUtils.setStringValueOnStatement(ps, 13, transientObject.getRating().name());
            ps.setString(14, JdbcUtils.trimToMaxLength(this.createSortName(transientObject.getTitle()), 128));
            JdbcUtils.setLongValueOnStatement(ps, 15, transientObject.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 16, transientObject.getEpisodeNumber());
            JdbcUtils.setIntValueOnStatement(ps, 17, transientObject.getSeasonNumber());
            JdbcUtils.setLongValueOnStatement(ps, 18, transientObject.getSeriesId());
            ps.setInt(19, transientObject.isDirty() ? 1 : 0);
            JdbcUtils.setStringValueOnStatement(ps, 20, transientObject.getAudioCodec() != null ? transientObject.getAudioCodec().toString() : null);
            JdbcUtils.setStringValueOnStatement(ps, 21, transientObject.getVideoCodec().toString());
            JdbcUtils.setIntValueOnStatement(ps, 22, transientObject.getChannels());
            JdbcUtils.setStringValueOnStatement(ps, 23, JdbcUtils.trimToMaxLength(transientObject.getFps(), 10));
            JdbcUtils.setIntValueOnStatement(ps, 24, transientObject.getFrequency());
            JdbcUtils.setStringValueOnStatement(ps, 25, transientObject.getContentType().toString());
            JdbcUtils.setStringValueOnStatement(ps, 26, transientObject.getTimestampType() != null ? transientObject.getTimestampType().toString() : null);
            JdbcUtils.setIntValueOnStatement(ps, 27, transientObject.getAudioBitrate());
            JdbcUtils.setIntValueOnStatement(ps, 28, transientObject.getAudioStreamIndex());
            JdbcUtils.setIntValueOnStatement(ps, 29, transientObject.getVideoStreamIndex());
            JdbcUtils.setStringValueOnStatement(ps, 30, transientObject.getH264Profile() != null ? transientObject.getH264Profile().toString() : null);
            JdbcUtils.setStringValueOnStatement(ps, 31, H264LevelType.parseToString(transientObject.getH264Levels()));
            JdbcUtils.setStringValueOnStatement(ps, 32, transientObject.getFtyp());
            ps.setString(33, transientObject.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 34, transientObject.getRepositoryId());
            JdbcUtils.setStringValueOnStatement(ps, 35, OnlineDBIdentifier.parseToString(transientObject.getOnlineIdentifiers()));
            JdbcUtils.setStringValueOnStatement(ps, 36, transientObject.getSar().toString());
            JdbcUtils.setStringValueOnStatement(ps, 37, JdbcUtils.trimToMaxLength(transientObject.getVideoFourCC(), 6));
            JdbcUtils.setStringValueOnStatement(ps, 38, CollectionUtils.listToCSV(transientObject.getEmbeddedSubtitles(), ",", true));
            ps.setInt(39, DateUtils.getYear(transientObject.getDate()));
            ps.setLong(40, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Video with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<Video> retrieveVideos(int type, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos of type %s (from=%s, count=%s) [%s]", type, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + " WHERE file_type = ? " + this.movieTypeCondition(type) + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title), lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos of type %s", type), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosCount(int type, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos of type %s [%s]", type, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item" + this.accessGroupTable(accessGroup) + " WHERE file_type = ? " + this.movieTypeCondition(type) + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos of type %s", type), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForFolder(Long folderId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos for folder %s (from=%s, count=%s) [%s]", folderId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + " WHERE file_type = ? AND folder_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForFolderCount(Long folderId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos for folder %s [%s]", folderId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and folder_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForPlaylist(Long playlistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos for playlist %s (from=%s, count=%s) [%s]", playlistId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year,p.item_order FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND media_item.file_type = ? and p.playlist_id = ?" + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY p.item_order " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, playlistId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForPlaylistCount(Long playlistId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos for playlist %s [%s]", playlistId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND p.playlist_id = ? AND media_item.file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setLong(1, playlistId);
            ps.setString(2, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForGenre(Long genreId, AccessGroup accessGroup, int startingIndex, int requestedCount, boolean filterOutSeries) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos for genre %s (from=%s, count=%s) [%s]", genreId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar,vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and genre_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries) + "ORDER BY lower(sort_title), lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, genreId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos for genre %s", genreId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForGenreCount(Long genreId, AccessGroup accessGroup, boolean filterOutSeries) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos for genre %s [%s]", genreId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and genre_id = ?" + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, genreId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos for genre %s", genreId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForPerson(Long personId, Person.RoleType role, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos for person %s with role %s (from=%s, count=%s) [%s]", new Object[]{personId, role, startingIndex, requestedCount, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(media_item.id) as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? and r.role_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(media_item.sort_title), lower(media_item.file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, personId);
            ps.setString(3, role.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos for person %s with role %s", new Object[]{personId, role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForPersonCount(Long personId, Person.RoleType role, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos for person %s with role %s [%s]", new Object[]{personId, role, accessGroup}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(DISTINCT(media_item.id)) as c FROM media_item, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? and r.role_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, personId);
            ps.setString(3, role.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos for person %s with role %s", new Object[]{personId, role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForSeriesSeason(Long seriesId, Integer season, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos for series %s season %s (from=%s, count=%s) [%s]", seriesId, season, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and series_id = ? and season_number = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY order_number, lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, seriesId);
            ps.setInt(3, season);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos for series %s season %s", seriesId, season), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForSeriesSeasonCount(Long seriesId, Integer season, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos for series %s season %s [%s]", seriesId, season, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and series_id = ? and season_number = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, seriesId);
            ps.setInt(3, season);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos for series %s season %s", seriesId, season), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<String> retrieveVideoInitials(AccessGroup accessGroup, int startingIndex, int requestedCount, boolean filterOutSeries) {
        ArrayList<String> arrayList;
        log.debug(String.format("Retrieving list of video initials (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT upper(substr(sort_title,1,1)) as letter from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries) + "ORDER BY letter " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("letter"));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of video initials", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveVideoInitialsCount(AccessGroup accessGroup, boolean filterOutSeries) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of video initials [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT upper(substr(sort_title,1,1))) as c from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of video initials", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveVideosForInitial(String initial, AccessGroup accessGroup, int startingIndex, int requestedCount, boolean filterOutSeries) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos with initial %s (from=%s, count=%s) [%s]", initial, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and substr(upper(sort_title),1,1) = ? " + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries) + "ORDER BY lower(sort_title), lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos with initial %s", initial), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveVideosForInitialCount(String initial, AccessGroup accessGroup, boolean filterOutSeries) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos with initial %s [%s]", initial, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and substr(upper(sort_title),1,1) = ?" + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos with initial %s", initial), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveLastViewedVideos(int maxReturned, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of %s last viewed videos (from=%s, count=%s) [%s]", maxReturned, startingIndex, requestedCount, accessGroup));
        int availableCount = maxReturned - startingIndex;
        if (availableCount <= 0) {
            return Collections.emptyList();
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? AND last_viewed_date IS NOT NULL " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY last_viewed_date DESC " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount < availableCount ? requestedCount : availableCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of %s last viewed videos", maxReturned), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveLastViewedVideosCount(int maxReturned, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of %s last viewed videos [%s]", maxReturned, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? AND last_viewed_date IS NOT NULL " + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count < maxReturned ? count : maxReturned;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of %s last viewed videos", maxReturned), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveLastAddedVideos(int maxReturned, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of %s last added videos (from=%s, count=%s) [%s]", maxReturned, startingIndex, requestedCount, accessGroup));
        int availableCount = maxReturned - startingIndex;
        if (availableCount <= 0) {
            return Collections.emptyList();
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY date_added DESC " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount < availableCount ? requestedCount : availableCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of %s last added videos", maxReturned), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveLastAddedVideosCount(int maxReturned, AccessGroup userProfile) {
        log.debug(String.format("Retrieving number of %s last added videos", maxReturned));
        Integer count = this.retrieveVideosCount(0, userProfile);
        return count < maxReturned ? count : maxReturned;
    }

    @Override
    public Map<Long, Integer> retrieveLastViewedEpisode(Long seriesId) {
        Map<Long, Integer> map;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving last episode for series %s", seriesId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id,season_number FROM media_item WHERE file_type = ? AND last_viewed_date IS NOT NULL AND series_id = ? ORDER BY last_viewed_date DESC FETCH FIRST 1 ROW ONLY");
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setLong(2, seriesId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            HashMap<Long, Integer> result = new HashMap<Long, Integer>();
            result.put(rs.getLong(1), rs.getInt(2));
            HashMap<Long, Integer> hashMap = result;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return hashMap;
        }
        try {
            map = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read last episode for series %s", seriesId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return map;
    }

    @Override
    public List<Integer> retrieveVideoReleaseYears(AccessGroup accessGroup, int startingIndex, int requestedCount, boolean filterOutSeries) {
        ArrayList<Integer> arrayList;
        log.debug(String.format("Retrieving list of videos' release years (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT distinct release_year FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries) + "ORDER BY release_year desc " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> years = new ArrayList<Integer>();
            while (rs.next()) {
                years.add(rs.getInt("release_year"));
            }
            arrayList = years;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of videos' release years", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveVideoReleaseYearsCount(AccessGroup accessGroup, boolean filterOutSeries) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of video release years [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT(release_year)) as c from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup) + this.seriesContentTypeCondition(filterOutSeries));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of video release years", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveMoviesForReleaseYear(Integer releaseYear, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos with release year %s (from=%s, count=%s) [%s]", releaseYear, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and release_year = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title), lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setInt(2, releaseYear);
            ps.setString(3, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos with releaseYear %s", releaseYear), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMoviesForReleaseYearCount(Integer releaseYear, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos with release year %s [%s]", releaseYear, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and release_year = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setInt(2, releaseYear);
            ps.setString(3, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos with release year %s", releaseYear), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MPAARating> retrieveMovieRatings(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        ArrayList<MPAARating> arrayList;
        log.debug(String.format("Retrieving list of videos' ratings (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT distinct rating FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY rating desc " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<MPAARating> ratings = new ArrayList<MPAARating>();
            while (rs.next()) {
                ratings.add(MPAARating.valueOf(rs.getString("rating")));
            }
            arrayList = ratings;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of videos' ratings", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveMovieRatingsCount(AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of video ratings [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT(rating)) as c from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of video ratings", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Video> retrieveMoviesForRating(MPAARating rating, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Video> list;
        log.debug(String.format("Retrieving list of videos with rating %s (from=%s, count=%s) [%s]", new Object[]{rating, startingIndex, requestedCount, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, genre_id, duration, file_size, file_name, folder_id, container, creation_date, cover_image_id, bitrate, description, width, height, rating, order_number, season_number, series_id, last_viewed_date, number_viewed, dirty, acodec, vcodec, channels, fps, sample_frequency, content_type, timestamp_type, audio_bitrate, audio_stream_index, video_stream_index,h264_profile, h264_level, bookmark, ftyp, file_path, media_item.repository_id as repository_id, online_identifiers, sar, vfourcc, embedded_subtitles, release_year FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and rating = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title), lower(file_name) " + VideoDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, rating.name());
            ps.setString(3, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of videos with rating %s", new Object[]{rating}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMoviesForRatingCount(MPAARating rating, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of videos with rating %s [%s]", new Object[]{rating, accessGroup}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and rating = ? and content_type = ? " + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.VIDEO.toString());
            ps.setString(2, rating.name());
            ps.setString(3, ContentType.MOVIE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of videos with rating %s", new Object[]{rating}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected Video mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initVideo(rs);
        }
        return null;
    }

    protected List<Video> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Video> result = new ArrayList<Video>();
        while (rs.next()) {
            result.add(this.initVideo(rs));
        }
        return result;
    }

    private Video initVideo(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        Long genreId = rs.getLong("genre_id");
        Integer duration = JdbcUtils.getIntFromResultSet(rs, "duration");
        Long fileSize = JdbcUtils.getLongFromResultSet(rs, "file_size");
        String fileName = rs.getString("file_name");
        String filePath = rs.getString("file_path");
        Long folderId = rs.getLong("folder_id");
        Long repositoryId = rs.getLong("repository_id");
        VideoContainer container = rs.getString("container") != null ? VideoContainer.valueOf(rs.getString("container")) : null;
        VideoCodec vCodec = rs.getString("vcodec") != null ? VideoCodec.valueOf(rs.getString("vcodec")) : null;
        AudioCodec aCodec = rs.getString("acodec") != null ? AudioCodec.valueOf(rs.getString("acodec")) : null;
        Timestamp date = rs.getTimestamp("creation_date");
        Long thumbnailId = JdbcUtils.getLongFromResultSet(rs, "cover_image_id");
        String description = rs.getString("description");
        Integer bitrate = JdbcUtils.getIntFromResultSet(rs, "bitrate");
        Integer width = JdbcUtils.getIntFromResultSet(rs, "width");
        Integer height = JdbcUtils.getIntFromResultSet(rs, "height");
        Integer channels = JdbcUtils.getIntFromResultSet(rs, "channels");
        Integer frequency = JdbcUtils.getIntFromResultSet(rs, "sample_frequency");
        String fps = rs.getString("fps");
        String rating = rs.getString("rating");
        ContentType contentType = rs.getString("content_type") != null ? ContentType.valueOf(rs.getString("content_type")) : null;
        Integer episodeNumber = JdbcUtils.getIntFromResultSet(rs, "order_number");
        Integer seasonNumber = JdbcUtils.getIntFromResultSet(rs, "season_number");
        Long seriesId = JdbcUtils.getLongFromResultSet(rs, "series_id");
        Timestamp lastViewed = rs.getTimestamp("last_viewed_date");
        Integer numberViewed = rs.getInt("number_viewed");
        TransportStreamTimestamp timestampType = rs.getString("timestamp_type") != null ? TransportStreamTimestamp.valueOf(rs.getString("timestamp_type")) : null;
        Integer audioBitrate = JdbcUtils.getIntFromResultSet(rs, "audio_bitrate");
        Integer audioStreamIndex = JdbcUtils.getIntFromResultSet(rs, "audio_stream_index");
        Integer videoStreamIndex = JdbcUtils.getIntFromResultSet(rs, "video_stream_index");
        H264Profile h264Profile = rs.getString("h264_profile") != null ? H264Profile.valueOf(rs.getString("h264_profile")) : null;
        String h264LevelsSCV = rs.getString("h264_level");
        String ftyp = rs.getString("ftyp");
        Integer bookmark = JdbcUtils.getIntFromResultSet(rs, "bookmark");
        String onlineIdentifiersCSV = rs.getString("online_identifiers");
        String sar = rs.getString("sar");
        String videoFourCC = rs.getString("vfourcc");
        String embeddedSubtitles = rs.getString("embedded_subtitles");
        Integer releaseYear = JdbcUtils.getIntFromResultSet(rs, "release_year");
        boolean dirty = rs.getBoolean("dirty");
        Video video = new Video(title, container, fileName, filePath, fileSize, folderId, repositoryId, date);
        video.setId(id);
        video.setSortTitle(sortTitle);
        video.setDuration(duration);
        video.setGenreId(genreId);
        video.setThumbnailId(thumbnailId);
        video.setDescription(description);
        video.setBitrate(bitrate);
        video.setWidth(width);
        video.setHeight(height);
        video.setChannels(channels);
        video.setFps(fps);
        video.setFrequency(frequency);
        video.setRating(rating != null ? MPAARating.valueOf(rating) : MPAARating.UNKNOWN);
        video.setEpisodeNumber(episodeNumber);
        video.setSeasonNumber(seasonNumber);
        video.setSeriesId(seriesId);
        video.setLastViewedDate(lastViewed);
        video.setNumberViewed(numberViewed);
        video.setAudioCodec(aCodec);
        video.setVideoCodec(vCodec);
        video.setContentType(contentType);
        video.setTimestampType(timestampType);
        video.setAudioBitrate(audioBitrate);
        video.setAudioStreamIndex(audioStreamIndex);
        video.setVideoStreamIndex(videoStreamIndex);
        video.setH264Profile(h264Profile);
        video.setH264Levels(H264LevelType.parseFromString(h264LevelsSCV));
        video.setBookmark(bookmark);
        video.setFtyp(ftyp);
        video.setSar(new SourceAspectRatio(sar));
        video.setOnlineIdentifiers(OnlineDBIdentifier.parseFromString(onlineIdentifiersCSV));
        video.setVideoFourCC(videoFourCC);
        video.getEmbeddedSubtitles().addAll(EmbeddedSubtitles.fromString(embeddedSubtitles));
        video.setReleaseYear(releaseYear);
        video.setDirty(dirty);
        return video;
    }

    private String movieTypeCondition(int type) {
        String seriesSegment = "";
        if (type == 2) {
            seriesSegment = "AND content_type = '" + (Object)((Object)ContentType.MOVIE) + "' ";
        } else if (type == 1) {
            seriesSegment = "AND content_type = '" + (Object)((Object)ContentType.EPISODE) + "' ";
        }
        return seriesSegment;
    }
}

