/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.JdbcExecutor;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.SeriesDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Series;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesDAOImpl
extends AbstractSortableItemDao
implements SeriesDAO {
    private static final Logger log = LoggerFactory.getLogger(SeriesDAOImpl.class);

    @Override
    public long create(Series newInstance) throws InvalidArgumentException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getTitle())) {
            throw new InvalidArgumentException("Cannot create Series. Required data is missing.");
        }
        log.debug(String.format("Creating a new Series (title = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO series (title,sort_title,cover_image_id) VALUES (?,?,?)", 1);
            ps.setString(1, newInstance.getTitle());
            ps.setString(2, this.createSortName(newInstance.getTitle()));
            JdbcUtils.setLongValueOnStatement(ps, 3, newInstance.getThumbnailId());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Series with title %s", newInstance.getTitle()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(final Long id) {
        log.debug(String.format("Deleting a Series (id = %s)", id));
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM series WHERE id = ?");
                    ps.setLong(1, id);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete Series with id = %s", id), e);
        }
    }

    @Override
    public Series read(Long id) {
        Series series;
        log.debug(String.format("Reading a Series (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, cover_image_id FROM series WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            series = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Series with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return series;
    }

    @Override
    public void update(Series transientObject) throws InvalidArgumentException {
        if (transientObject == null || transientObject.getId() == null || transientObject.getTitle() == null) {
            throw new InvalidArgumentException("Cannot update Series. Required data is missing.");
        }
        log.debug(String.format("Updating Setries (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE series SET title = ?, sort_title = ?, cover_image_id = ? WHERE id = ?");
            ps.setString(1, transientObject.getTitle());
            ps.setString(2, this.createSortName(transientObject.getTitle()));
            JdbcUtils.setLongValueOnStatement(ps, 3, transientObject.getThumbnailId());
            ps.setLong(4, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Series with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Series findSeriesByName(String name) {
        Series series;
        log.debug(String.format("Reading a Series (name = %s)", name));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, cover_image_id FROM series where lower(title) = ?");
            ps.setString(1, StringUtils.localeSafeToLowercase(name));
            ResultSet rs = ps.executeQuery();
            series = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Series with name = %s", name), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return series;
    }

    @Override
    public int getNumberOfEpisodes(Long seriesId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of episodes for series %s", seriesId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as episodes from media_item WHERE media_item.series_id = ?");
            ps.setLong(1, seriesId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("episodes");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of episodes for series: %s ", seriesId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Series> retrieveSeries(int startingIndex, int requestedCount) {
        List<Series> list;
        log.debug(String.format("Retrieving list of series (from=%s, count=%s)", startingIndex, requestedCount));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, cover_image_id FROM series ORDER BY lower(series.sort_title) " + SeriesDAOImpl.paginationQuery(startingIndex, requestedCount));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of series", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getSeriesCount() {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug("Retrieving number of series");
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(id) as c FROM series");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of series", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Integer> retrieveSeasonsForSeries(Long seriesId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        ArrayList<Integer> arrayList;
        log.debug(String.format("Retrieving list of seasons for series %s (from=%s, count=%s) [%s]", seriesId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(season_number) FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE series_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY season_number " + SeriesDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setLong(1, seriesId);
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> result = new ArrayList<Integer>();
            while (rs.next()) {
                result.add(rs.getInt("season_number"));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of seasons for series %s", seriesId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int getSeasonsForSeriesCount(Long seriesId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of seasons for series %s [%s]", seriesId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT(season_number)) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE series_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setLong(1, seriesId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of seasons for series %s", seriesId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected Series mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initSeries(rs);
        }
        return null;
    }

    protected List<Series> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Series> result = new ArrayList<Series>();
        while (rs.next()) {
            result.add(this.initSeries(rs));
        }
        return result;
    }

    private Series initSeries(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        Long thumbnailId = JdbcUtils.getLongFromResultSet(rs, "cover_image_id");
        Series series = new Series(title, sortTitle, thumbnailId);
        series.setId(id);
        return series;
    }
}

