/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractAccessibleDao;
import org.serviio.library.dao.RepositoryDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Repository;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryDAOImpl
extends AbstractAccessibleDao
implements RepositoryDAO {
    private static final Logger log = LoggerFactory.getLogger(RepositoryDAOImpl.class);

    @Override
    public long create(Repository newInstance) throws InvalidArgumentException {
        long l;
        if (newInstance == null || newInstance.getFolder() == null || newInstance.getAccessGroupIds() == null || newInstance.getAccessGroupIds().size() == 0) {
            throw new InvalidArgumentException("Cannot create Repository. Required data is missing.");
        }
        log.debug(String.format("Creating a new Repository (folder = %s)", newInstance.getFolder()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO repository (folder,file_types,online_metadata_supported,scan_for_updates) VALUES (?,?,?,?)", 1);
            ps.setString(1, newInstance.getFolder().getAbsolutePath());
            ps.setString(2, MediaFileType.parseMediaFileTypesToString(newInstance.getSupportedFileTypes()));
            ps.setBoolean(3, newInstance.isSupportsDescriptiveMetadata());
            ps.setBoolean(4, newInstance.isKeepScanningForUpdates());
            ps.executeUpdate();
            Long repoId = JdbcUtils.retrieveGeneratedID(ps);
            log.debug("Adding Access Groups to the new Repository");
            for (Long accessGroupId : newInstance.getAccessGroupIds()) {
                this.addAccessGroup(con, repoId, accessGroupId);
            }
            l = repoId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Repository for folder %s", newInstance.getFolder()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) {
        log.debug(String.format("Deleting a Repository (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            this.removeAllAccessGroupsFromRepository(con, id);
            ps = con.prepareStatement("DELETE FROM repository WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete Repository with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Repository read(Long id) {
        Repository repository;
        log.debug(String.format("Reading a Repository (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, folder, file_types, online_metadata_supported, scan_for_updates, last_scanned FROM repository WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            repository = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Repository with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return repository;
    }

    @Override
    public void update(Repository transientObject) throws InvalidArgumentException {
        if (transientObject == null || transientObject.getId() == null || transientObject.getFolder() == null || transientObject.getAccessGroupIds() == null || transientObject.getAccessGroupIds().size() == 0) {
            throw new InvalidArgumentException("Cannot update Repository. Required data is missing.");
        }
        log.debug(String.format("Updating Repository (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE repository SET folder = ?, file_types = ?, online_metadata_supported = ?, scan_for_updates = ? WHERE id = ?");
            ps.setString(1, transientObject.getFolder().getAbsolutePath());
            ps.setString(2, MediaFileType.parseMediaFileTypesToString(transientObject.getSupportedFileTypes()));
            ps.setBoolean(3, transientObject.isSupportsDescriptiveMetadata());
            ps.setBoolean(4, transientObject.isKeepScanningForUpdates());
            ps.setLong(5, transientObject.getId());
            ps.executeUpdate();
            this.removeAllAccessGroupsFromRepository(con, transientObject.getId());
            for (Long accessGroupId : transientObject.getAccessGroupIds()) {
                this.addAccessGroup(con, transientObject.getId(), accessGroupId);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Repository with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public void markRepositoryAsScanned(Long repoId) throws InvalidArgumentException, PersistenceException {
        if (repoId == null) {
            throw new InvalidArgumentException("Cannot mark Repository as scanned. Required id is missing.");
        }
        log.debug(String.format("Marking Repository %s as scanned with current timestamp", repoId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE repository SET last_scanned = ? WHERE id = ?");
            JdbcUtils.setTimestampValueOnStatement(ps, 1, new Date());
            ps.setLong(2, repoId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot mark Repository with id %s as scanned", repoId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<Repository> findAll() {
        List<Repository> list;
        log.debug("Reading all Repositories");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, folder, file_types, online_metadata_supported, scan_for_updates, last_scanned FROM repository ORDER BY id");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot retrieve list of Repositories", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Repository> getRepositories(MediaFileType fileType, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Repository> list;
        log.debug(String.format("Retrieving list of Repositories for %s (from=%s, count=%s) [%s]", new Object[]{fileType, startingIndex, requestedCount, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT repository.id as id, folder, file_types, online_metadata_supported, scan_for_updates, last_scanned FROM repository " + this.accessGroupTable(accessGroup) + "WHERE LOCATE(?,file_types) > 0 " + this.accessGroupConditionForRepository(accessGroup) + "ORDER BY id " + RepositoryDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of Repositories for %s", new Object[]{fileType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getRepositoriesCount(MediaFileType fileType, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of repositories for %s [%s]", new Object[]{fileType, accessGroup}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(repository.id) as c FROM repository " + this.accessGroupTable(accessGroup) + "WHERE LOCATE(?,file_types) > 0" + this.accessGroupConditionForRepository(accessGroup));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of repositories for %s", new Object[]{fileType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    private void addAccessGroup(Connection con, Long repositoryId, Long accessGroupId) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO repository_access_group (repository_id, access_group_id) VALUES (?,?)", 1);
            ps.setLong(1, repositoryId);
            ps.setLong(2, accessGroupId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot add AccessGroup", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
    }

    private void removeAllAccessGroupsFromRepository(Connection con, Long repositoryId) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("DELETE FROM repository_access_group WHERE repository_id = ?");
            ps.setLong(1, repositoryId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot add AccessGroup", e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
        }
    }

    protected Repository mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initRepository(rs);
        }
        return null;
    }

    protected List<Repository> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Repository> result = new ArrayList<Repository>();
        while (rs.next()) {
            result.add(this.initRepository(rs));
        }
        return result;
    }

    private Repository initRepository(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String folder = rs.getString("folder");
        String fileTypesCSV = rs.getString("file_types");
        boolean onlineMetadataSupported = rs.getBoolean("online_metadata_supported");
        boolean scanForUpdates = rs.getBoolean("scan_for_updates");
        Timestamp lastScanned = rs.getTimestamp("last_scanned");
        Repository repository = new Repository(new File(folder), MediaFileType.parseMediaFileTypesFromString(fileTypesCSV), onlineMetadataSupported, scanForUpdates);
        repository.setId(id);
        repository.setLastScanned(lastScanned);
        return repository;
    }
}

