/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.JdbcExecutor;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractAccessibleDao;
import org.serviio.library.dao.PlaylistDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Playlist;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistDAOImpl
extends AbstractAccessibleDao
implements PlaylistDAO {
    private static final Logger log = LoggerFactory.getLogger(PlaylistDAOImpl.class);

    @Override
    public long create(Playlist newInstance) throws InvalidArgumentException, PersistenceException {
        if (newInstance == null || newInstance.getTitle() == null) {
            throw new InvalidArgumentException("Cannot create Playlist. Required data is missing.");
        }
        log.debug(String.format("Creating a new Playlist (title = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO playlist (file_types, title, file_path, date_updated, repository_id,all_items_found) VALUES (?,?,?,?,?,?)", 1);
            ps.setString(1, MediaFileType.parseMediaFileTypesToString(newInstance.getFileTypes()));
            ps.setString(2, JdbcUtils.trimToMaxLength(newInstance.getTitle(), 128));
            ps.setString(3, newInstance.getFilePath());
            JdbcUtils.setTimestampValueOnStatement(ps, 4, newInstance.getDateUpdated());
            ps.setLong(5, newInstance.getRepositoryId());
            ps.setBoolean(6, newInstance.isAllItemsFound());
            ps.executeUpdate();
            long l = JdbcUtils.retrieveGeneratedID(ps);
            return l;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot create Playlist with name %s", newInstance.getTitle()), e);
        }
        finally {
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a Playlist (id = %s) and all related items", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM playlist_item WHERE playlist_id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
            this.deletePlaylist(con, id);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot remove Playlist %s or its items", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Playlist read(Long id) throws PersistenceException {
        Playlist playlist;
        log.debug(String.format("Reading a Playlist (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, file_types, title, file_path, date_updated, repository_id,all_items_found FROM playlist where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            playlist = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Playlist with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return playlist;
    }

    @Override
    public void update(Playlist transientObject) throws InvalidArgumentException, PersistenceException {
        if (transientObject == null || transientObject.getId() == null || ObjectValidator.isEmpty(transientObject.getTitle()) || ObjectValidator.isEmpty(transientObject.getFilePath()) || transientObject.getDateUpdated() == null || transientObject.getRepositoryId() == null) {
            throw new InvalidArgumentException("Cannot update Playlist. Required data is missing.");
        }
        log.debug(String.format("Updating Playlist (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE playlist SET file_types = ?, title = ?, file_path = ?, date_updated = ?, repository_id = ?,all_items_found = ? WHERE id = ?");
            ps.setString(1, MediaFileType.parseMediaFileTypesToString(transientObject.getFileTypes()));
            ps.setString(2, JdbcUtils.trimToMaxLength(transientObject.getTitle(), 128));
            ps.setString(3, transientObject.getFilePath());
            JdbcUtils.setTimestampValueOnStatement(ps, 4, transientObject.getDateUpdated());
            ps.setLong(5, transientObject.getRepositoryId());
            ps.setBoolean(6, transientObject.isAllItemsFound());
            ps.setLong(7, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Playlist with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public boolean isPlaylistPresent(String playlistFilePath) {
        boolean bl;
        PreparedStatement ps;
        Connection con;
        block6: {
            if (playlistFilePath == null) {
                throw new InvalidArgumentException("Cannot check playlist presence. Required data is missing.");
            }
            log.debug(String.format("Checking if DB already contains playlist %s", playlistFilePath));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT file_path FROM playlist WHERE file_path = ?");
            ps.setString(1, playlistFilePath);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block6;
            log.debug(String.format("Playlist %s already exists in DB", playlistFilePath));
            boolean bl2 = true;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return bl2;
        }
        try {
            log.debug(String.format("Playlist %s doesn't exist in DB yet", playlistFilePath));
            bl = false;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot check if playlist exists: %s ", playlistFilePath), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return bl;
    }

    @Override
    public List<Playlist> getPlaylistsInRepository(Long repositoryId) {
        List<Playlist> list;
        log.debug(String.format("Reading Playlists for Repository (id = %s)", repositoryId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, file_types, title, file_path, date_updated, repository_id,all_items_found FROM playlist where repository_id = ?");
            ps.setLong(1, repositoryId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Playlists for Repository with id = %s", repositoryId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public void removeMediaItemFromPlaylists(final Long mediaItemId) {
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM playlist_item WHERE media_item_id = ?");
                    ps.setLong(1, mediaItemId);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete MediaItem with id = %s from playlists", mediaItemId), e);
        }
    }

    @Override
    public List<Playlist> findAll() {
        List<Playlist> list;
        log.debug("Reading all Playlists");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, file_types, title, file_path, date_updated, repository_id,all_items_found FROM playlist ORDER BY id");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot retrieve list of Playlists", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public void removePlaylistItems(final Long playlistId) {
        log.debug(String.format("Removing all items from playlist %s", playlistId));
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM playlist_item WHERE playlist_id = ?");
                    ps.setLong(1, playlistId);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete PlaylistItems from playlist with id = %s", playlistId), e);
        }
    }

    @Override
    public void addPlaylistItem(Integer order, Long mediaItemId, Long playlistId) {
        if (order == null || mediaItemId == null || playlistId == null) {
            throw new InvalidArgumentException("Cannot create Playlist Item. Required data is missing.");
        }
        log.debug(String.format("Adding a new Item to playlist (media item = %s, playlist = %s)", mediaItemId, playlistId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO playlist_item (item_order, playlist_id, media_item_id) VALUES (?,?,?)", 1);
            ps.setInt(1, order);
            ps.setLong(2, playlistId);
            ps.setLong(3, mediaItemId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot create Playlist Item", e);
        }
        finally {
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public List<Integer> getPlaylistItemIndices(Long playlistId) {
        ArrayList<Integer> arrayList;
        log.debug(String.format("Reading items for playlist %s", playlistId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT item_order FROM playlist_item WHERE playlist_id = ? ORDER BY item_order");
            ps.setLong(1, playlistId);
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            while (rs.next()) {
                numbers.add(rs.getInt("item_order"));
            }
            arrayList = numbers;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot retrieve list of playlist items", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public List<Playlist> retrievePlaylistsWithMedia(MediaFileType mediaType, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Playlist> list;
        log.debug(String.format("Retrieving list of Playlists for %s (from=%s, count=%s) [%s]", new Object[]{mediaType, startingIndex, requestedCount, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT playlist.id as id, file_types, title, file_path, date_updated, playlist.repository_id as repository_id,all_items_found FROM playlist " + this.accessGroupTable(accessGroup) + "WHERE LOCATE(?,file_types) > 0 " + this.accessGroupConditionForPlaylist(accessGroup) + "ORDER BY title " + PlaylistDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, mediaType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of Playlists for %s", new Object[]{mediaType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getPlaylistsWithMediaCount(MediaFileType mediaType, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of playlists for %s [%s]", new Object[]{mediaType, accessGroup}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(playlist.id) as c FROM playlist " + this.accessGroupTable(accessGroup) + "WHERE LOCATE(?,file_types) > 0" + this.accessGroupConditionForPlaylist(accessGroup));
            ps.setString(1, mediaType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of playlists", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    private void deletePlaylist(Connection con, final Long playlistId) {
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM playlist WHERE id = ?");
                    ps.setLong(1, playlistId);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete Playlist with id = %s", playlistId), e);
        }
    }

    protected Playlist mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initPlaylist(rs);
        }
        return null;
    }

    protected List<Playlist> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Playlist> result = new ArrayList<Playlist>();
        while (rs.next()) {
            result.add(this.initPlaylist(rs));
        }
        return result;
    }

    private Playlist initPlaylist(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String filePath = rs.getString("file_path");
        String fileTypesCSV = rs.getString("file_types");
        boolean allItemsFound = rs.getBoolean("all_items_found");
        Long repositoryId = JdbcUtils.getLongFromResultSet(rs, "repository_id");
        Timestamp dateUpdated = rs.getTimestamp("date_updated");
        Playlist playlist = new Playlist(title, MediaFileType.parseMediaFileTypesFromString(fileTypesCSV), filePath, dateUpdated, repositoryId);
        playlist.setId(id);
        playlist.setAllItemsFound(allItemsFound);
        return playlist;
    }
}

