/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.PersonDAO;
import org.serviio.library.entities.Person;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDAOImpl
extends AbstractSortableItemDao
implements PersonDAO {
    private static final Logger log = LoggerFactory.getLogger(PersonDAOImpl.class);

    @Override
    public Person findPersonByName(String name) {
        Person person;
        log.debug(String.format("Reading a Person (name = %s)", name));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, sort_name, initial FROM person where name = ?");
            ps.setString(1, JdbcUtils.trimToMaxLength(name, 128));
            ResultSet rs = ps.executeQuery();
            person = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Person with name = %s", name), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return person;
    }

    @Override
    public Person findPersonById(Long id) {
        Person person;
        log.debug(String.format("Reading a Person (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, sort_name, initial FROM person where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            person = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Person with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return person;
    }

    @Override
    public Long addPersonToMedia(String personName, Person.RoleType role, Long mediaItemId) {
        Long l;
        Long roleId;
        PreparedStatement ps;
        Connection con;
        block6: {
            if (ObjectValidator.isEmpty(personName) || mediaItemId == null) {
                log.debug("Cannot add person to media item. Required data is missing.");
                return null;
            }
            log.debug(String.format("Adding a Person %s to media item %s as %s", personName, mediaItemId, role.toString()));
            Person person = this.findPersonByName(personName);
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            Long personId = null;
            personId = person == null ? Long.valueOf(this.createPerson(con, new Person(personName, this.createSortName(personName), this.createInitial(personName)))) : person.getId();
            roleId = this.getPersonRoleForMediaItem(role, personId, mediaItemId);
            if (roleId != null) break block6;
            ps = con.prepareStatement("INSERT INTO person_role (ROLE_TYPE, PERSON_ID, MEDIA_ITEM_ID) VALUES (?,?,?)", 1);
            ps.setString(1, role.toString());
            ps.setLong(2, personId);
            ps.setLong(3, mediaItemId);
            ps.executeUpdate();
            Long l2 = JdbcUtils.retrieveGeneratedID(ps);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = roleId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot add Person with name %s to media item %s", personName, mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public Long addPersonToMusicAlbum(String personName, Person.RoleType role, Long albumId) {
        Long l;
        Long roleId;
        PreparedStatement ps;
        Connection con;
        block6: {
            if (ObjectValidator.isEmpty(personName) || albumId == null) {
                log.debug("Cannot add person to media item. Required data is missing.");
                return null;
            }
            log.debug(String.format("Adding a Person %s to album %s as %s", personName, albumId, role.toString()));
            Person person = this.findPersonByName(personName);
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            Long personId = null;
            personId = person == null ? Long.valueOf(this.createPerson(con, new Person(personName, this.createSortName(personName), this.createInitial(personName)))) : person.getId();
            roleId = this.getPersonRoleForMusicAlbum(role, personId, albumId);
            if (roleId != null) break block6;
            ps = con.prepareStatement("INSERT INTO person_role (ROLE_TYPE, PERSON_ID, MUSIC_ALBUM_ID) VALUES (?,?,?)", 1);
            ps.setString(1, role.toString());
            ps.setLong(2, personId);
            ps.setLong(3, albumId);
            ps.executeUpdate();
            Long l2 = JdbcUtils.retrieveGeneratedID(ps);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = roleId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot add Person with name %s to music album %s", personName, albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void removeAllPersonsFromMedia(Long mediaItemId) {
        if (mediaItemId == null) {
            throw new InvalidArgumentException("Cannot remove person from media item. Required data is missing.");
        }
        log.debug(String.format("Removing all Persons from media item %s", mediaItemId));
        List<Person> persons = this.retrievePersonsForMediaItem(mediaItemId);
        log.debug(String.format("Found all Persons (%s) for media item %s", persons.size(), mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM person_role WHERE media_item_id = ?");
            ps.setLong(1, mediaItemId);
            ps.executeUpdate();
            for (Person person : persons) {
                int rolesCount = this.getRoleForPersonCount(person.getId());
                if (rolesCount != 0) continue;
                this.deletePerson(con, person.getId());
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot remove all Persons from media item %s", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<Long> removeAllPersonsFromMusicAlbum(Long albumId) {
        ArrayList<Long> i$;
        if (albumId == null) {
            throw new InvalidArgumentException("Cannot remove person from music album. Required data is missing.");
        }
        log.debug(String.format("Removing all Persons from album %s", albumId));
        List<Person> persons = this.retrievePersonsForMusicAlbum(albumId);
        Connection con = null;
        PreparedStatement ps = null;
        ArrayList<Long> removedPersonIds = new ArrayList<Long>();
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM person_role WHERE music_album_id = ?");
            ps.setLong(1, albumId);
            ps.executeUpdate();
            for (Person person : persons) {
                int rolesCount = this.getRoleForPersonCount(person.getId());
                if (rolesCount != 0) continue;
                this.deletePerson(con, person.getId());
                removedPersonIds.add(person.getId());
            }
            i$ = removedPersonIds;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot remove all Persons from musicalbum %s", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return i$;
    }

    @Override
    public void removePersonsAndRoles(List<Long> personRoleIds) {
        if (personRoleIds != null && personRoleIds.size() > 0) {
            log.debug("Removing person relationships");
            Connection con = null;
            PreparedStatement ps = null;
            try {
                con = DatabaseManager.getConnection();
                List<Person> referencedPersons = this.findPersonForPersonRole(con, personRoleIds);
                ps = con.prepareStatement("DELETE FROM person_role WHERE id IN (" + JdbcUtils.createInClause(personRoleIds.size()) + ")");
                for (int i = 1; i <= personRoleIds.size(); ++i) {
                    ps.setLong(i, personRoleIds.get(i - 1));
                }
                ps.executeUpdate();
                for (Person person : referencedPersons) {
                    int rolesCount = this.getRoleForPersonCount(person.getId());
                    if (rolesCount != 0) continue;
                    this.deletePerson(con, person.getId());
                }
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException("Cannot remove Person relationships", e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(ps);
                    DatabaseManager.releaseConnection(con);
                    throw throwable;
                }
            }
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public List<Person> retrievePersonsWithRole(Person.RoleType roleType, int startingIndex, int requestedCount) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons with role %s (from=%s, count=%s)", new Object[]{roleType, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ? ORDER BY lower(p.sort_name) " + PersonDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, roleType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of  persons with role %s", new Object[]{roleType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getPersonsWithRoleCount(Person.RoleType roleType) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of persons with role %s", new Object[]{roleType}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT p.id) as c FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ?");
            ps.setString(1, roleType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of  persons with role %s", new Object[]{roleType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public int getRoleForPersonCount(Long personId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of roles for person %s", personId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(r.id) as count FROM person_role r WHERE r.person_id = ?");
            ps.setLong(1, personId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("count");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of roles for person %s", personId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Person> retrievePersonsWithRoleForMediaItem(Person.RoleType roleType, Long mediaItemId) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons with role %s for MediaItem %s", new Object[]{roleType, mediaItemId}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ? AND r.media_item_id = ?");
            ps.setString(1, roleType.toString());
            ps.setLong(2, mediaItemId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of persons with role %s for media item %s", new Object[]{roleType, mediaItemId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Person> retrievePersonsWithRoleForMusicAlbum(Person.RoleType roleType, Long albumId) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons with role %s for MusicAlbum %s", new Object[]{roleType, albumId}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ? AND r.music_album_id = ?");
            ps.setString(1, roleType.toString());
            ps.setLong(2, albumId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of persons with role %s for music album %s", new Object[]{roleType, albumId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Person> retrievePersonsForMediaItem(Long mediaItemId) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons for MediaItem %s", mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.media_item_id = ?");
            ps.setLong(1, mediaItemId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of persons for media item %s", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Person> retrievePersonsForMusicAlbum(Long albumId) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons for MusicAlbum %s", albumId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.music_album_id = ?");
            ps.setLong(1, albumId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of persons for music album %s", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public Long getPersonRoleForMediaItem(Person.RoleType role, Long personId, Long mediaItemId) {
        Long l;
        if (personId == null || mediaItemId == null || role == null) {
            throw new InvalidArgumentException("Cannot check for person role. Required data is missing.");
        }
        log.debug(String.format("Checking if person %s has a role %s for media item %s", personId, role.toString(), mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT person_role.id as id FROM person_role WHERE person_role.person_id = ? AND person_role.media_item_id = ? AND person_role.role_type = ?");
            ps.setLong(1, personId);
            ps.setLong(2, mediaItemId);
            ps.setString(3, role.toString());
            ResultSet rs = ps.executeQuery();
            Long roleId = null;
            if (rs.next()) {
                roleId = rs.getLong("id");
            }
            l = roleId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot check if person %s has a role %s for media item %s", personId, role.toString(), mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public Long getPersonRoleForMusicAlbum(Person.RoleType role, Long personId, Long albumId) {
        Long l;
        if (personId == null || albumId == null || role == null) {
            throw new InvalidArgumentException("Cannot check for person role. Required data is missing.");
        }
        log.debug(String.format("Checking if person %s has a role %s for album %s", personId, role.toString(), albumId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT person_role.id as id FROM person_role WHERE person_role.person_id = ? AND person_role.music_album_id = ? AND person_role.role_type = ?");
            ps.setLong(1, personId);
            ps.setLong(2, albumId);
            ps.setString(3, role.toString());
            ResultSet rs = ps.executeQuery();
            Long roleId = null;
            if (rs.next()) {
                roleId = rs.getLong("id");
            }
            l = roleId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot check if person %s has a role %s for music album %s", personId, role.toString(), albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public List<Long> getRoleIDsForMediaItem(Person.RoleType role, Long mediaItemId) {
        ArrayList<Long> arrayList;
        if (mediaItemId == null || role == null) {
            throw new InvalidArgumentException("Cannot get list of roles. Required data is missing.");
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT person_role.id as id FROM person_role WHERE person_role.media_item_id = ? AND person_role.role_type = ?");
            ps.setLong(1, mediaItemId);
            ps.setString(2, role.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<Long> result = new ArrayList<Long>();
            while (rs.next()) {
                result.add(rs.getLong("id"));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot retrieve list or role IDs for role %s for media item %s", role.toString(), mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public List<String> retrievePersonInitials(Person.RoleType role, int startingIndex, int requestedCount) {
        ArrayList<String> arrayList;
        log.debug(String.format("Retrieving list of person initials (role = %s, from=%s, count=%s)", new Object[]{role, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT initial as letter from person, person_role WHERE person_role.role_type = ?  and person_role.person_id = person.id ORDER BY letter " + PersonDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, role.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("letter"));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of person initials for role %s", new Object[]{role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrievePersonInitialsCount(Person.RoleType role) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of person initials for role %s", new Object[]{role}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT initial) as c from person, person_role WHERE person_role.role_type = ?  and person_role.person_id = person.id");
            ps.setString(1, role.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of person initials for role %s", new Object[]{role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Person> retrievePersonsForInitial(String initial, Person.RoleType role, int startingIndex, int requestedCount) {
        List<Person> list;
        log.debug(String.format("Retrieving list of persons with initial %s and role %s (from=%s, count=%s)", new Object[]{initial, role, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(p.id) as id, p.name as name, p.sort_name as sort_name, p.initial as initial FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ? and p.initial = ? ORDER BY lower(p.sort_name) " + PersonDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, role.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of persons with initial %s and role %s", new Object[]{initial, role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrievePersonsForInitialCount(String initial, Person.RoleType role) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of persons with initial %s and role %s", new Object[]{initial, role}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(DISTINCT(p.id)) as c FROM person p, person_role r WHERE r.person_id = p.id AND r.ROLE_TYPE = ? and p.initial = ?");
            ps.setString(1, role.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of persons with initial %s and role %s", new Object[]{initial, role}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    private String createInitial(String name) {
        if (name != null) {
            return StringUtils.localeSafeToUppercase(this.createSortName(name).substring(0, 1));
        }
        return null;
    }

    protected Person mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initPerson(rs);
        }
        return null;
    }

    protected List<Person> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Person> result = new ArrayList<Person>();
        while (rs.next()) {
            result.add(this.initPerson(rs));
        }
        return result;
    }

    private Person initPerson(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        String sortName = rs.getString("sort_name");
        String initial = rs.getString("initial");
        Person person = new Person(name, sortName, initial);
        person.setId(id);
        return person;
    }

    private long createPerson(Connection con, Person newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getName())) {
            throw new InvalidArgumentException("Cannot create Person. Required data is missing.");
        }
        log.debug(String.format("Creating a new Person (name = %s)", newInstance.getName()));
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO person (name,sort_name, initial) VALUES (?,?,?)", 1);
            ps.setString(1, JdbcUtils.trimToMaxLength(newInstance.getName(), 128));
            ps.setString(2, JdbcUtils.trimToMaxLength(newInstance.getSortName(), 128));
            ps.setString(3, newInstance.getInitial());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Person with name %s", newInstance.getName()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        return l;
    }

    private void deletePerson(Connection con, Long personId) {
        log.debug(String.format("Deleting a Person (id = %s)", personId));
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("DELETE FROM person WHERE id = ?");
            ps.setLong(1, personId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete Person with id = %s", personId), e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
        }
    }

    private List<Person> findPersonForPersonRole(Connection con, List<Long> personRoleIds) {
        List<Person> list;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT DISTINCT(person.id) as id, name, sort_name, initial FROM person, person_role WHERE person_role.person_id = person.id AND person_role.id IN (" + JdbcUtils.createInClause(personRoleIds.size()) + ")");
            for (int i = 1; i <= personRoleIds.size(); ++i) {
                ps.setLong(i, personRoleIds.get(i - 1));
            }
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read Person for Role relationship", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        return list;
    }
}

