/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractAccessibleDao;
import org.serviio.library.dao.OnlineRepositoryDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineRepositoryDAOImpl
extends AbstractAccessibleDao
implements OnlineRepositoryDAO {
    private static final Logger log = LoggerFactory.getLogger(OnlineRepositoryDAOImpl.class);

    @Override
    public long create(OnlineRepository newInstance) throws InvalidArgumentException {
        long l;
        if (newInstance == null || newInstance.getRepositoryUrl() == null || newInstance.getFileType() == null || newInstance.getRepoType() == null) {
            throw new InvalidArgumentException("Cannot create OnlineRepository. Required data is missing.");
        }
        log.debug(String.format("Creating a new Repository (url = %s)", newInstance.getRepositoryUrl().toString()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO online_repository (repo_type, file_type, url, thumbnail_url, name, enabled, order_number) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setString(1, newInstance.getRepoType().toString());
            ps.setString(2, newInstance.getFileType().toString());
            ps.setString(3, newInstance.getRepositoryUrl());
            JdbcUtils.setURLValueOnStatement(ps, 4, newInstance.getThumbnailUrl());
            ps.setString(5, newInstance.getRepositoryName());
            ps.setBoolean(6, newInstance.isEnabled());
            ps.setInt(7, newInstance.getOrder());
            ps.executeUpdate();
            Long repoId = JdbcUtils.retrieveGeneratedID(ps);
            log.debug("Adding Access Groups to the new OnlineRepository");
            for (Long accessGroupId : newInstance.getAccessGroupIds()) {
                this.addAccessGroup(con, repoId, accessGroupId);
            }
            l = repoId;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create OnlineRepository for url %s", newInstance.getRepositoryUrl().toString()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) {
        log.debug(String.format("Deleting an OnlineRepository (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            this.removeAllAccessGroupsFromRepository(con, id);
            ps = con.prepareStatement("DELETE FROM online_repository WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete OnlineRepository with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OnlineRepository read(Long id) {
        OnlineRepository onlineRepository;
        log.debug(String.format("Reading an OnlineRepository (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, repo_type, file_type, url, thumbnail_url, name, enabled, order_number FROM online_repository WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            onlineRepository = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read OnlineRepository with id = %s", id), e);
                catch (MalformedURLException e2) {
                    throw new PersistenceException(String.format("Cannot read OnlineRepository with id = %s", id), e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return onlineRepository;
    }

    @Override
    public void update(OnlineRepository transientObject) throws InvalidArgumentException {
        if (transientObject == null || transientObject.getId() == null || transientObject.getRepositoryUrl() == null || transientObject.getFileType() == null || transientObject.getRepoType() == null) {
            throw new InvalidArgumentException("Cannot update OnlineRepository. Required data is missing.");
        }
        log.debug(String.format("Updating OnlineRepository (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE online_repository SET repo_type = ?, file_type = ?, url = ?, thumbnail_url = ?, name = ?, enabled = ?, order_number = ? WHERE id = ?");
            ps.setString(1, transientObject.getRepoType().toString());
            ps.setString(2, transientObject.getFileType().toString());
            ps.setString(3, transientObject.getRepositoryUrl());
            JdbcUtils.setURLValueOnStatement(ps, 4, transientObject.getThumbnailUrl());
            ps.setString(5, transientObject.getRepositoryName());
            ps.setBoolean(6, transientObject.isEnabled());
            ps.setInt(7, transientObject.getOrder());
            ps.setLong(8, transientObject.getId());
            ps.executeUpdate();
            if (transientObject.getAccessGroupIds() != null) {
                this.removeAllAccessGroupsFromRepository(con, transientObject.getId());
                for (Long accessGroupId : transientObject.getAccessGroupIds()) {
                    this.addAccessGroup(con, transientObject.getId(), accessGroupId);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update OnlineRepository with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OnlineRepository> findAll() {
        List<OnlineRepository> list;
        log.debug("Reading all OnlineRepositories");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, repo_type, file_type, url, thumbnail_url, name, enabled, order_number FROM online_repository ORDER BY order_number");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot retrieve list of OnlineRepositories", e);
                catch (MalformedURLException e2) {
                    throw new PersistenceException("Cannot retrieve list of OnlineRepositories", e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OnlineRepository> getRepositories(List<OnlineRepository.OnlineRepositoryType> repoTypes, MediaFileType fileType, AccessGroup accessGroup, boolean onlyEnabled) {
        List<OnlineRepository> list;
        log.debug(String.format("Retrieving list of %s OnlineRepositories for %s [%s]", new Object[]{repoTypes, fileType, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            String query = "SELECT online_repository.id as id, repo_type, file_type, url, thumbnail_url, name, enabled, order_number FROM online_repository " + this.onlineAccessGroupTable(accessGroup) + "WHERE file_type = ? and repo_type in (" + JdbcUtils.createInClause(repoTypes.size()) + ") " + this.accessGroupConditionForOnlineRepository(accessGroup);
            if (onlyEnabled) {
                query = query + "and enabled = 1 ";
            }
            query = query + "ORDER BY order_number ";
            ps = con.prepareStatement(query);
            ps.setString(1, fileType.toString());
            for (int i = 0; i < repoTypes.size(); ++i) {
                ps.setString(i + 2, repoTypes.get(i).toString());
            }
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of OnlineRepositories for %s", new Object[]{fileType}), e);
                catch (MalformedURLException e2) {
                    throw new PersistenceException(String.format("Cannot read list of OnlineRepositories for %s", new Object[]{fileType}), e2);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    private void addAccessGroup(Connection con, Long repositoryId, Long accessGroupId) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO online_repository_access_group (online_repository_id, access_group_id) VALUES (?,?)", 1);
            ps.setLong(1, repositoryId);
            ps.setLong(2, accessGroupId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot add AccessGroup", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
    }

    private void removeAllAccessGroupsFromRepository(Connection con, Long repositoryId) {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("DELETE FROM online_repository_access_group WHERE online_repository_id = ?");
            ps.setLong(1, repositoryId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot add AccessGroup", e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
        }
    }

    protected OnlineRepository mapSingleResult(ResultSet rs) throws SQLException, MalformedURLException {
        if (rs.next()) {
            return this.initRepository(rs);
        }
        return null;
    }

    protected List<OnlineRepository> mapResultSet(ResultSet rs) throws SQLException, MalformedURLException {
        ArrayList<OnlineRepository> result = new ArrayList<OnlineRepository>();
        while (rs.next()) {
            result.add(this.initRepository(rs));
        }
        return result;
    }

    private OnlineRepository initRepository(ResultSet rs) throws SQLException, MalformedURLException {
        Long id = rs.getLong("id");
        String contentUrl = rs.getString("url");
        MediaFileType fileType = MediaFileType.valueOf(rs.getString("file_type"));
        OnlineRepository.OnlineRepositoryType repoType = OnlineRepository.OnlineRepositoryType.valueOf(rs.getString("repo_type"));
        URL thumbnailUrl = JdbcUtils.getURLFromResultSet(rs, "thumbnail_url");
        String name = rs.getString("name");
        boolean enabled = rs.getBoolean("enabled");
        Integer order = rs.getInt("order_number");
        OnlineRepository repository = new OnlineRepository(repoType, contentUrl, fileType, name, order);
        repository.setId(id);
        repository.setThumbnailUrl(thumbnailUrl);
        repository.setEnabled(enabled);
        return repository;
    }
}

