/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.dlna.AudioContainer;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.MusicTrackDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Person;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicTrackDAOImpl
extends AbstractSortableItemDao
implements MusicTrackDAO {
    private static final Logger log = LoggerFactory.getLogger(MusicTrackDAOImpl.class);

    @Override
    public long create(MusicTrack newInstance) throws InvalidArgumentException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getTitle()) || ObjectValidator.isEmpty(newInstance.getFileName()) || newInstance.getFileSize() == null || newInstance.getFolderId() == null) {
            throw new InvalidArgumentException("Cannot create MusicTrack. Required data is missing.");
        }
        log.debug(String.format("Creating a new MusicTrack (title = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO media_item (file_type, title, order_number, genre_id, duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date,cover_image_id, audio_bitrate, description, channels, sample_frequency, sort_title, file_path, repository_id,season_number, dirty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setString(2, JdbcUtils.trimToMaxLength(newInstance.getTitle(), 128));
            JdbcUtils.setIntValueOnStatement(ps, 3, newInstance.getTrackNumber());
            JdbcUtils.setLongValueOnStatement(ps, 4, newInstance.getGenreId());
            JdbcUtils.setIntValueOnStatement(ps, 5, newInstance.getDuration());
            JdbcUtils.setIntValueOnStatement(ps, 6, newInstance.getReleaseYear());
            ps.setLong(7, newInstance.getFileSize());
            ps.setString(8, newInstance.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 9, newInstance.getFolderId());
            JdbcUtils.setLongValueOnStatement(ps, 10, newInstance.getAlbumId());
            ps.setString(11, newInstance.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 12, newInstance.getDate());
            JdbcUtils.setLongValueOnStatement(ps, 13, newInstance.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 14, newInstance.getBitrate());
            JdbcUtils.setStringValueOnStatement(ps, 15, newInstance.getDescription());
            JdbcUtils.setIntValueOnStatement(ps, 16, newInstance.getChannels());
            JdbcUtils.setIntValueOnStatement(ps, 17, newInstance.getSampleFrequency());
            ps.setString(18, JdbcUtils.trimToMaxLength(this.createSortName(newInstance.getTitle()), 128));
            ps.setString(19, newInstance.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 20, newInstance.getRepositoryId());
            JdbcUtils.setIntValueOnStatement(ps, 21, newInstance.getDiscNumber());
            ps.setInt(22, newInstance.isDirty() ? 1 : 0);
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create MusicTrack with title %s", newInstance.getTitle()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) {
        log.debug(String.format("Deleting a MusicTrack (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete MusicTrack with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public MusicTrack read(Long id) {
        MusicTrack musicTrack;
        log.debug(String.format("Reading a MusicTrack (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, order_number, genre_id, duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty,bookmark, repository_id, season_number FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            musicTrack = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MusicTrack with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return musicTrack;
    }

    @Override
    public void update(MusicTrack transientObject) throws InvalidArgumentException {
        if (transientObject == null || transientObject.getId() == null || ObjectValidator.isEmpty(transientObject.getTitle()) || ObjectValidator.isEmpty(transientObject.getFileName()) || transientObject.getFileSize() == null || transientObject.getFolderId() == null) {
            throw new InvalidArgumentException("Cannot update MusicTrack. Required data is missing.");
        }
        log.debug(String.format("Updating MusicTrack (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET title = ?, order_number = ?, genre_id = ?, duration = ?, release_year =?, file_size = ?, file_name = ?, folder_id = ?, album_id =?, container =?, creation_date = ?, cover_image_id = ?, audio_bitrate = ?, description = ?, channels = ?, sample_frequency = ?, sort_title = ?, file_path = ?, repository_id = ?, season_number = ?, dirty = ? WHERE id = ?");
            ps.setString(1, JdbcUtils.trimToMaxLength(transientObject.getTitle(), 128));
            JdbcUtils.setIntValueOnStatement(ps, 2, transientObject.getTrackNumber());
            JdbcUtils.setLongValueOnStatement(ps, 3, transientObject.getGenreId());
            JdbcUtils.setIntValueOnStatement(ps, 4, transientObject.getDuration());
            JdbcUtils.setIntValueOnStatement(ps, 5, transientObject.getReleaseYear());
            ps.setLong(6, transientObject.getFileSize());
            ps.setString(7, transientObject.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 8, transientObject.getFolderId());
            JdbcUtils.setLongValueOnStatement(ps, 9, transientObject.getAlbumId());
            ps.setString(10, transientObject.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 11, transientObject.getDate());
            JdbcUtils.setLongValueOnStatement(ps, 12, transientObject.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 13, transientObject.getBitrate());
            JdbcUtils.setStringValueOnStatement(ps, 14, transientObject.getDescription());
            JdbcUtils.setIntValueOnStatement(ps, 15, transientObject.getChannels());
            JdbcUtils.setIntValueOnStatement(ps, 16, transientObject.getSampleFrequency());
            ps.setString(17, JdbcUtils.trimToMaxLength(this.createSortName(transientObject.getTitle()), 128));
            ps.setString(18, transientObject.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 19, transientObject.getRepositoryId());
            JdbcUtils.setIntValueOnStatement(ps, 20, transientObject.getDiscNumber());
            ps.setInt(21, transientObject.isDirty() ? 1 : 0);
            ps.setLong(22, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update MusicTrack with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForArtist(Long artistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for artist %s (from=%s, count=%s) [%s]", artistId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, media_item.title as title, media_item.sort_title as sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, season_number, bookmark, media_item.repository_id as repository_id FROM media_item LEFT OUTER JOIN music_album a ON media_item.album_id = a.id, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? AND r.role_type=? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(a.title), media_item.season_number, media_item.order_number, lower(media_item.sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, artistId);
            ps.setString(3, Person.RoleType.ARTIST.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for artist %s", artistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForArtistCount(Long artistId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for artist %s [%s]", artistId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? and r.role_type=?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, artistId);
            ps.setString(3, Person.RoleType.ARTIST.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for artist %s", artistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForGenre(Long genreId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for genre %s (from=%s, count=%s) [%s]", genreId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and genre_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, genreId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for genre %s", genreId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForGenreCount(Long genreId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for genre %s [%s]", genreId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and genre_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, genreId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for genre %s", genreId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForFolder(Long folderId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for folder %s (from=%s, count=%s) [%s]", folderId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item" + this.accessGroupTable(accessGroup) + " WHERE file_type = ? and folder_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(file_name) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForFolderCount(Long folderId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for folder %s [%s]", folderId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? AND folder_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<String> retrieveMusicTracksInitials(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        ArrayList<String> arrayList;
        log.debug(String.format("Retrieving list of music track initials (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT upper(substr(sort_title,1,1)) as letter from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY letter " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<String> result = new ArrayList<String>();
            while (rs.next()) {
                result.add(rs.getString("letter"));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of music track initials", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveMusicTracksInitialsCount(AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music track initials [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT upper(substr(sort_title,1,1))) as c from media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of music track initials", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForInitial(String initial, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks with initial %s (from=%s, count=%s) [%s]", initial, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and substr(upper(sort_title),1,1) = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks with initial %s", initial), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForInitialCount(String initial, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks with initial %s [%s]", initial, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and substr(upper(sort_title),1,1) = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setString(2, StringUtils.localeSafeToUppercase(initial));
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks with initial %s", initial), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForAlbum(Long albumId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for album %s (from=%s, count=%s) [%s]", albumId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE media_item.album_id=? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY media_item.season_number, media_item.order_number, lower(media_item.sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setLong(1, albumId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for album %s", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForAlbumCount(Long albumId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for album %s [%s]", albumId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE media_item.album_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setLong(1, albumId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for an album %s", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveAllMusicTracks(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of all music tracks (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list  all music tracks for artist", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveAllMusicTracksCount(AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of all music tracks [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of all music tracks", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveRandomMusicTracks(int max, int startingIndex, int requestedCount, AccessGroup accessGroup) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of random music tracks (start = %s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            if (requestedCount + startingIndex > max) {
                requestedCount = max - startingIndex;
            }
            ps = con.prepareStatement("SELECT " + MusicTrackDAOImpl.randomFunction() + " as r, media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, " + "container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, " + "dirty, bookmark, season_number, media_item.repository_id as repository_id " + "FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY r " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list random music tracks", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveRandomMusicTracksCount(int max, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of random music tracks [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = Math.min(count, max);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of random music tracks", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForTrackRoleAndAlbum(Long artistId, Person.RoleType role, Long albumId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for person %s with role %s on album %s (from=%s, count=%s) [%s]", new Object[]{artistId, role, albumId, startingIndex, requestedCount, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, media_item.title, media_item.sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? and r.role_type=? and media_item.album_id=? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY media_item.season_number, media_item.order_number, lower(media_item.sort_title) " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, artistId);
            ps.setString(3, role.toString());
            ps.setLong(4, albumId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for person %s with role %s on album %s", new Object[]{artistId, role, albumId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForTrackRoleAndAlbumCount(Long artistId, Person.RoleType role, Long albumId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for person %s with role %s on album %s [%s]", new Object[]{artistId, role, albumId, accessGroup}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item, person_role r, person p " + this.accessGroupTable(accessGroup) + "WHERE media_item.file_type = ? and p.id = r.person_id and r.media_item_id = media_item.id and p.id=? and r.role_type=? and media_item.album_id=?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, artistId);
            ps.setString(3, role.toString());
            ps.setLong(4, albumId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for person %s with role %s on album %s", new Object[]{artistId, role, albumId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicTrack> retrieveMusicTracksForPlaylist(Long playlistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<MusicTrack> list;
        log.debug(String.format("Retrieving list of music tracks for playlist %s (from=%s, count=%s) [%s]", playlistId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, order_number, genre_id,duration, release_year, file_size, file_name, folder_id, album_id, container, creation_date, cover_image_id, audio_bitrate, description, channels, sample_frequency, last_viewed_date, number_viewed, file_path, dirty, bookmark, season_number, media_item.repository_id as repository_id FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND media_item.file_type = ? and p.playlist_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY p.item_order " + MusicTrackDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.AUDIO.toString());
            ps.setLong(2, playlistId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music tracks for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicTracksForPlaylistCount(Long playlistId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of music tracks for playlist %s [%s]", playlistId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND p.playlist_id = ? AND media_item.file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setLong(1, playlistId);
            ps.setString(2, MediaFileType.AUDIO.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of music tracks for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected MusicTrack mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initMusicTrack(rs);
        }
        return null;
    }

    protected List<MusicTrack> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<MusicTrack> result = new ArrayList<MusicTrack>();
        while (rs.next()) {
            result.add(this.initMusicTrack(rs));
        }
        return result;
    }

    private MusicTrack initMusicTrack(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        Long genreId = rs.getLong("genre_id");
        Integer trackNumber = JdbcUtils.getIntFromResultSet(rs, "order_number");
        Integer duration = JdbcUtils.getIntFromResultSet(rs, "duration");
        Integer year = JdbcUtils.getIntFromResultSet(rs, "release_year");
        Long fileSize = JdbcUtils.getLongFromResultSet(rs, "file_size");
        String fileName = rs.getString("file_name");
        String filePath = rs.getString("file_path");
        Long folderId = rs.getLong("folder_id");
        Long repositoryId = rs.getLong("repository_id");
        AudioContainer container = rs.getString("container") != null ? AudioContainer.valueOf(rs.getString("container")) : null;
        Long albumId = JdbcUtils.getLongFromResultSet(rs, "album_id");
        Timestamp date = rs.getTimestamp("creation_date");
        Long albumArtId = JdbcUtils.getLongFromResultSet(rs, "cover_image_id");
        String description = rs.getString("description");
        Integer bitrate = JdbcUtils.getIntFromResultSet(rs, "audio_bitrate");
        Integer channels = JdbcUtils.getIntFromResultSet(rs, "channels");
        Integer sampleFrequency = JdbcUtils.getIntFromResultSet(rs, "sample_frequency");
        Timestamp lastViewed = rs.getTimestamp("last_viewed_date");
        Integer numberViewed = rs.getInt("number_viewed");
        Integer bookmark = JdbcUtils.getIntFromResultSet(rs, "bookmark");
        Integer discNumber = JdbcUtils.getIntFromResultSet(rs, "season_number");
        boolean dirty = rs.getBoolean("dirty");
        MusicTrack track = new MusicTrack(title, container, fileName, filePath, fileSize, folderId, repositoryId, date);
        track.setId(id);
        track.setSortTitle(sortTitle);
        track.setAlbumId(albumId);
        track.setDuration(duration);
        track.setGenreId(genreId);
        track.setTrackNumber(trackNumber);
        track.setReleaseYear(year);
        track.setThumbnailId(albumArtId);
        track.setDescription(description);
        track.setBitrate(bitrate);
        track.setChannels(channels);
        track.setSampleFrequency(sampleFrequency);
        track.setDirty(dirty);
        track.setLastViewedDate(lastViewed);
        track.setNumberViewed(numberViewed);
        track.setBookmark(bookmark);
        track.setDiscNumber(discNumber);
        return track;
    }
}

