/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.JdbcExecutor;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.MusicAlbumDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MusicAlbum;
import org.serviio.library.entities.Person;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicAlbumDAOImpl
extends AbstractSortableItemDao
implements MusicAlbumDAO {
    private static final Logger log = LoggerFactory.getLogger(MusicAlbumDAOImpl.class);

    @Override
    public long create(MusicAlbum newInstance) throws InvalidArgumentException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getTitle())) {
            throw new InvalidArgumentException("Cannot create MusicAlbum. Required data is missing.");
        }
        log.debug(String.format("Creating a new MusicAlbum (title = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO music_album (title,sort_title) VALUES (?,?)", 1);
            ps.setString(1, JdbcUtils.trimToMaxLength(newInstance.getTitle(), 256));
            ps.setString(2, JdbcUtils.trimToMaxLength(this.createSortName(newInstance.getTitle()), 256));
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create MusicAlbum with title %s", newInstance.getTitle()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public MusicAlbum findAlbum(String title, String artist) throws InvalidArgumentException {
        MusicAlbum musicAlbum;
        if (ObjectValidator.isEmpty(title)) {
            throw new InvalidArgumentException("Cannot find MusicAlbum. Required data (title) is missing.");
        }
        if (ObjectValidator.isEmpty(artist)) {
            throw new InvalidArgumentException("Cannot find MusicAlbum. Required data (artist) is missing.");
        }
        log.debug(String.format("Finding a MusicAlbum (title = %s, artist=%s)", title, artist));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(a.id), a.title, a.sort_title FROM music_album a, person_role pr, person p WHERE pr.music_album_id = a.id AND p.id = pr.person_id AND pr.role_type = ? AND LCASE(p.name) = LCASE(?) AND LCASE(a.title) = LCASE(?)");
            ps.setString(1, Person.RoleType.ALBUM_ARTIST.toString());
            ps.setString(2, JdbcUtils.trimToMaxLength(artist, 128));
            ps.setString(3, JdbcUtils.trimToMaxLength(title, 256));
            ResultSet rs = ps.executeQuery();
            musicAlbum = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot find MusicAlbum (title = %s, artist=%s)", title, artist), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return musicAlbum;
    }

    @Override
    public void delete(final Long id) {
        log.debug(String.format("Deleting a MusicAlbum (id = %s)", id));
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM music_album WHERE id = ?");
                    ps.setLong(1, id);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete MusicAlbum with id = %s", id), e);
        }
    }

    @Override
    public MusicAlbum read(Long id) {
        MusicAlbum musicAlbum;
        log.debug(String.format("Reading a MusicAlbum (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title FROM music_album WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            musicAlbum = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MusicAlbum with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return musicAlbum;
    }

    @Override
    public void update(MusicAlbum transientObject) throws InvalidArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfTracks(Long albumId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of tracks for album %s", albumId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as tracks from media_item WHERE media_item.album_id = ?");
            ps.setLong(1, albumId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("tracks");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of tracks for album: %s ", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicAlbum> retrieveMusicAlbumsForTrackRole(Long personId, Person.RoleType personRole, int startingIndex, int requestedCount) {
        List<MusicAlbum> list;
        log.debug(String.format("Retrieving list of music albums for person %s and role %s (from=%s, count=%s)", new Object[]{personId, personRole, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(a.id), a.title, a.sort_title FROM music_album a, person_role pr, media_item m  WHERE m.album_id = a.id AND pr.media_item_id = m.id AND pr.person_id = ? AND pr.role_type = ? ORDER BY lower(a.sort_title) " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setLong(1, personId);
            ps.setString(2, personRole.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music albums for person %s and role %s", new Object[]{personId, personRole}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicAlbumsForTrackRoleCount(Long artistId, Person.RoleType personRole) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of albums for person %s and role %s", new Object[]{artistId, personRole}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct(a.id)) as c from music_album a, person_role pr, media_item m WHERE m.album_id = a.id AND pr.media_item_id = m.id AND pr.person_id = ? AND pr.role_type = ?");
            ps.setLong(1, artistId);
            ps.setString(2, personRole.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of albums for person %s and role %s ", new Object[]{artistId, personRole}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicAlbum> retrieveMusicAlbumsForTrackRole(String personName, Person.RoleType personRole, int startingIndex, int requestedCount) {
        List<MusicAlbum> list;
        log.debug(String.format("Retrieving list of music albums for person '%s' and role %s (from=%s, count=%s)", new Object[]{personName, personRole, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(a.id), a.title, a.sort_title FROM music_album a, person_role pr, media_item m, person p WHERE m.album_id = a.id AND pr.media_item_id = m.id AND pr.person_id = p.id AND p.name = ? AND pr.role_type = ? ORDER BY lower(a.sort_title) " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, personName);
            ps.setString(2, personRole.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music albums for person '%s' and role %s", new Object[]{personName, personRole}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicAlbumsForTrackRoleCount(String personName, Person.RoleType personRole) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of albums for person '%s' and role %s", new Object[]{personName, personRole}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct(a.id)) as c from music_album a, person_role pr, media_item m, person p WHERE m.album_id = a.id AND pr.media_item_id = m.id AND pr.person_id = p.id AND p.name = ? AND pr.role_type = ?");
            ps.setString(1, JdbcUtils.trimToMaxLength(personName, 128));
            ps.setString(2, personRole.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of albums for person '%s' and role %s ", new Object[]{personName, personRole}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicAlbum> retrieveMusicAlbumsForAlbumArtist(Long artistId, int startingIndex, int requestedCount) {
        List<MusicAlbum> list;
        log.debug(String.format("Retrieving list of music albums for album artist %s (from=%s, count=%s)", artistId, startingIndex, requestedCount));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(a.id), a.title, a.sort_title FROM music_album a, person_role pr WHERE pr.music_album_id = a.id AND pr.person_id = ? AND pr.role_type = ? ORDER BY lower(a.sort_title) " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setLong(1, artistId);
            ps.setString(2, Person.RoleType.ALBUM_ARTIST.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of music albums for album artist %s", artistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveMusicAlbumsForAlbumArtistCount(Long artistId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of albums for album artist %s", artistId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct(a.id)) as c from music_album a, person_role pr WHERE pr.music_album_id = a.id AND pr.person_id = ? AND pr.role_type = ?");
            ps.setLong(1, artistId);
            ps.setString(2, Person.RoleType.ALBUM_ARTIST.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of albums for album artist: %s ", artistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicAlbum> retrieveAllMusicAlbums(int startingIndex, int requestedCount) {
        List<MusicAlbum> list;
        log.debug(String.format("Retrieving list of all music albums (from=%s, count=%s)", startingIndex, requestedCount));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT a.id, a.title, a.sort_title FROM music_album a ORDER BY lower(a.sort_title) " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of all music albums", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveAllMusicAlbumsCount() {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug("Getting number of all albums");
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(a.id) as c from music_album a");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot get number of all albums", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<MusicAlbum> retrieveRandomAlbums(int max, int startingIndex, int requestedCount) {
        List<MusicAlbum> list;
        log.debug(String.format("Retrieving list of random music albums (start = %s, count=%s)", startingIndex, requestedCount));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            if (requestedCount + startingIndex > max) {
                requestedCount = max - startingIndex;
            }
            if (requestedCount <= 0) {
                List<MusicAlbum> rs = Collections.emptyList();
                return rs;
            }
            ps = con.prepareStatement("SELECT " + MusicAlbumDAOImpl.randomFunction() + " as r, a.id, a.title, a.sort_title FROM music_album a ORDER BY r " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
            JdbcUtils.closeStatement(ps);
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot read list random music albums", e);
        }
        DatabaseManager.releaseConnection(con);
        return list;
        finally {
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public int retrieveRandomAlbumsCount(int max) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug("Retrieving number of random music albums");
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct(a.id)) as c FROM music_album a");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = Math.min(count, max);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of random music albums", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<MusicAlbum> retrieveLastViewedMusicAlbums(int max, int startingIndex, int requestedCount, AccessGroup accessGroup) {
        List<MusicAlbum> rs2;
        PreparedStatement ps;
        Connection con;
        block6: {
            log.debug(String.format("Retrieving list of last viewed music albums (start = %s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
            con = null;
            ps = null;
            if (requestedCount + startingIndex > max) {
                requestedCount = max - startingIndex;
            }
            if (requestedCount <= 0) break block6;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT a.id, a.title, a.sort_title, MAX(last_viewed_date) as viewed_date FROM music_album a, media_item " + this.accessGroupTable(accessGroup) + "WHERE media_item.album_id = a.id AND media_item.last_viewed_date IS NOT NULL " + this.accessGroupConditionForMediaItem(accessGroup) + "GROUP BY a.id, a.title, a.sort_title " + "ORDER BY viewed_date DESC " + MusicAlbumDAOImpl.paginationQuery(startingIndex, requestedCount));
            ResultSet rs2 = ps.executeQuery();
            List<MusicAlbum> list = this.mapResultSet(rs2);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return list;
        }
        try {
            rs2 = Collections.emptyList();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of last viewed music albums", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return rs2;
    }

    @Override
    public int retrieveLastViewedMusicAlbumsCount(int max, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of last viewed music albums [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct(a.id)) as c FROM music_album a, media_item " + this.accessGroupTable(accessGroup) + "WHERE media_item.album_id = a.id AND media_item.last_viewed_date IS NOT NULL " + this.accessGroupConditionForMediaItem(accessGroup));
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = Math.min(count, max);
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of last viewed music albums", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected MusicAlbum mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initMusicAlbum(rs);
        }
        return null;
    }

    protected List<MusicAlbum> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<MusicAlbum> result = new ArrayList<MusicAlbum>();
        while (rs.next()) {
            result.add(this.initMusicAlbum(rs));
        }
        return result;
    }

    private MusicAlbum initMusicAlbum(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        MusicAlbum album = new MusicAlbum(title);
        album.setId(id);
        album.setSortTitle(sortTitle);
        return album;
    }
}

