/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.MetadataExtractorConfigDAO;
import org.serviio.library.entities.MetadataExtractorConfig;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractorConfigDAOImpl
implements MetadataExtractorConfigDAO {
    private static final Logger log = LoggerFactory.getLogger(MetadataExtractorConfigDAOImpl.class);

    @Override
    public long create(MetadataExtractorConfig newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || newInstance.getExtractorType() == null || newInstance.getOrderNumber() == 0 || newInstance.getFileType() == null) {
            throw new InvalidArgumentException("Cannot create MetadataExtractorConfig. Required data is missing.");
        }
        log.debug(String.format("Creating a new MetadataExtractorConfig (extractor = %s, file type = %s)", new Object[]{newInstance.getExtractorType(), newInstance.getFileType()}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO metadata_extractor_config (media_file_type, extractor_type, order_number) VALUES (?,?,?)", 1);
            ps.setString(1, newInstance.getFileType().toString());
            ps.setString(2, newInstance.getExtractorType().toString());
            ps.setInt(3, newInstance.getOrderNumber());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create MetadataExtractorConfig %s for file type %s", new Object[]{newInstance.getExtractorType(), newInstance.getFileType()}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a MetadataExtractorConfig (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM metadata_extractor_config WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete MetadataExtractorConfig with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<MetadataExtractorConfig> retrieveByMediaFileType(MediaFileType type) throws PersistenceException {
        List<MetadataExtractorConfig> list;
        log.debug(String.format("Reading a list of Extractor configuration for type %s", type.toString()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, media_file_type, extractor_type, order_number FROM metadata_extractor_config where media_file_type = ? order by order_number");
            ps.setString(1, type.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read a list of Extractor configuration for type %s", type.toString()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    protected MetadataExtractorConfig mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initConfig(rs);
        }
        return null;
    }

    protected List<MetadataExtractorConfig> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<MetadataExtractorConfig> result = new ArrayList<MetadataExtractorConfig>();
        while (rs.next()) {
            result.add(this.initConfig(rs));
        }
        return result;
    }

    private MetadataExtractorConfig initConfig(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        MediaFileType mediaType = MediaFileType.valueOf(rs.getString("media_file_type"));
        ExtractorType extractorType = ExtractorType.valueOf(rs.getString("extractor_type"));
        Integer orderNumber = JdbcUtils.getIntFromResultSet(rs, "order_number");
        MetadataExtractorConfig config = new MetadataExtractorConfig(mediaType, extractorType, orderNumber);
        config.setId(id);
        return config;
    }
}

