/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.MetadataDescriptorDAO;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDescriptorDAOImpl
implements MetadataDescriptorDAO {
    private static final Logger log = LoggerFactory.getLogger(MetadataDescriptorDAOImpl.class);

    @Override
    public long create(MetadataDescriptor newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || newInstance.getExtractorType() == null || newInstance.getMediaItemId() == null || newInstance.getDateUpdated() == null) {
            throw new InvalidArgumentException("Cannot create MetadataDescriptor. Required data is missing.");
        }
        log.debug(String.format("Creating a new MetadataDescriptor (type = %s, mediaItemId = %s)", new Object[]{newInstance.getExtractorType(), newInstance.getMediaItemId()}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO metadata_descriptor (extractor_type, date_updated, media_item_id, identifier) VALUES (?,?,?,?)", 1);
            ps.setString(1, newInstance.getExtractorType().toString());
            ps.setTimestamp(2, new Timestamp(newInstance.getDateUpdated().getTime()));
            ps.setLong(3, newInstance.getMediaItemId());
            JdbcUtils.setStringValueOnStatement(ps, 4, newInstance.getIdentifier());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create MetadataDescriptor with type %s for mediaItem %s", new Object[]{newInstance.getExtractorType(), newInstance.getMediaItemId()}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a MetadataDescriptor (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM metadata_descriptor WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete MetadataDescriptor with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public MetadataDescriptor read(Long id) throws PersistenceException {
        MetadataDescriptor metadataDescriptor;
        log.debug(String.format("Reading a MetadataDescriptor (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, extractor_type, date_updated, media_item_id, identifier FROM metadata_descriptor where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            metadataDescriptor = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MetadataDescriptor with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return metadataDescriptor;
    }

    @Override
    public void update(MetadataDescriptor transientObject) throws InvalidArgumentException, PersistenceException {
        throw new UnsupportedOperationException("MetadataDescriptor update is not supported");
    }

    @Override
    public void removeMetadataDescriptorsForMedia(Long mediaItemId) {
        log.debug(String.format("Deleting all MetadataDescriptors for MediaItem (id = %s)", mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM metadata_descriptor WHERE media_item_id = ?");
            ps.setLong(1, mediaItemId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete all MetadataDescriptors for MediaItem id = %s", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public MetadataDescriptor retrieveMetadataDescriptorForMedia(Long mediaItemId, ExtractorType extractorType) {
        MetadataDescriptor metadataDescriptor;
        log.debug(String.format("Reading MetadataDescriptor for MediaItem (id = %s) and extractor %s", mediaItemId, extractorType.toString()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, extractor_type, date_updated, media_item_id, identifier FROM metadata_descriptor where media_item_id = ? and extractor_type = ?");
            ps.setLong(1, mediaItemId);
            ps.setString(2, extractorType.toString());
            ResultSet rs = ps.executeQuery();
            metadataDescriptor = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MetadataDescriptor for MediaItem id = %s and extractor %s", mediaItemId, extractorType.toString()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return metadataDescriptor;
    }

    protected MetadataDescriptor mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initDescriptor(rs);
        }
        return null;
    }

    protected List<MetadataDescriptor> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<MetadataDescriptor> result = new ArrayList<MetadataDescriptor>();
        while (rs.next()) {
            result.add(this.initDescriptor(rs));
        }
        return result;
    }

    private MetadataDescriptor initDescriptor(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        ExtractorType extractorType = ExtractorType.valueOf(rs.getString("extractor_type"));
        Timestamp dateUpdated = rs.getTimestamp("date_updated");
        Long mediaItemId = rs.getLong("media_item_id");
        String identifier = rs.getString("identifier");
        MetadataDescriptor descriptor = new MetadataDescriptor(extractorType, mediaItemId, dateUpdated, identifier);
        descriptor.setId(id);
        return descriptor;
    }
}

