/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractDao;
import org.serviio.library.dao.MediaItemDAO;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaItemDAOImpl
extends AbstractDao
implements MediaItemDAO {
    private static final Logger log = LoggerFactory.getLogger(MediaItemDAOImpl.class);

    @Override
    public boolean isMediaItemPresent(String mediaFilePath) {
        if (mediaFilePath == null) {
            throw new InvalidArgumentException("Cannot check item presence. Required data is missing.");
        }
        log.debug(String.format("Checking if DB already contains media item %s", mediaFilePath));
        MediaItem mi = this.getMediaItem(mediaFilePath, Platform.isWindows());
        if (mi != null) {
            log.debug(String.format("Media item %s already exists in DB", mediaFilePath));
            return true;
        }
        log.debug(String.format("Media item %s doesn't exist in DB yet", mediaFilePath));
        return false;
    }

    @Override
    public MediaItem getMediaItem(String filePath, boolean ignoreCase) {
        MediaItem mediaItem;
        log.debug(String.format("Looking up a media item for file path: %s, ignore case: %s", filePath, ignoreCase));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, file_size, file_name, file_path, folder_id, creation_date, description, file_type, last_viewed_date, number_viewed, dirty, bookmark, cover_image_id, repository_id FROM media_item WHERE " + (ignoreCase ? "lc_file_path = ?" : "file_path = ?"));
            ps.setString(1, ignoreCase ? filePath.toLowerCase() : filePath);
            ResultSet rs = ps.executeQuery();
            mediaItem = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot find media item by file path: %s ", filePath), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return mediaItem;
    }

    @Override
    public MediaItem read(Long id) {
        MediaItem mediaItem;
        log.debug(String.format("Reading a MediaItem (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, file_size, file_name, file_path, folder_id, creation_date, description, file_type, last_viewed_date, number_viewed, dirty, bookmark, cover_image_id, repository_id FROM media_item where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            mediaItem = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MediaItem with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return mediaItem;
    }

    @Override
    public File getFile(Long mediaItemId) {
        File file;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting file of media item %s", mediaItemId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.file_path as file_path FROM media_item WHERE  media_item.id = ?");
            ps.setLong(1, mediaItemId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            File file2 = new File(rs.getString("file_path"));
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return file2;
        }
        try {
            file = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get file of media item: %s ", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return file;
    }

    @Override
    public List<MediaItem> getMediaItemsInRepository(Long repositoryId) {
        List<MediaItem> list;
        log.debug(String.format("Reading MediaItems for Repository (id = %s)", repositoryId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, file_path, folder_id, creation_date, description, file_type, last_viewed_date, number_viewed, dirty, bookmark, cover_image_id, repository_id FROM media_item where repository_id = ?");
            ps.setLong(1, repositoryId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MediaItems for Repository with id = %s", repositoryId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<MediaItem> getMediaItemsInRepository(Long repositoryId, MediaFileType fileType) {
        List<MediaItem> list;
        log.debug(String.format("Reading MediaItems (%s) for Repository (id = %s)", new Object[]{fileType, repositoryId}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, file_path, folder_id, creation_date, description, file_type, last_viewed_date, number_viewed, dirty, bookmark, cover_image_id, repository_id FROM media_item where repository_id = ? and file_type = ?");
            ps.setLong(1, repositoryId);
            ps.setString(2, fileType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read MediaItems (%s) for Repository with id = %s", new Object[]{fileType, repositoryId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public void markMediaItemAsDirty(Long mediaItemId) {
        if (mediaItemId == null) {
            throw new InvalidArgumentException("Cannot mark MediaItem as dirty. Required data is missing.");
        }
        log.debug(String.format("Marking MediaItem (id = %s) as dirty", mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET dirty = 1 WHERE id = ?");
            ps.setLong(1, mediaItemId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot mark MediaItem %s as dirty", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public void markMediaItemsAsDirty(MediaFileType fileType) {
        if (fileType == null) {
            throw new InvalidArgumentException("Cannot mark MediaItems as dirty. Required data is missing.");
        }
        log.debug(String.format("Marking MediaItems (type = %s) as dirty", new Object[]{fileType}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET dirty = 1 WHERE file_type = ?");
            ps.setString(1, fileType.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot mark MediaItems of type %s as dirty", new Object[]{fileType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public void setMediaItemBookmark(Long mediaItemId, Integer seconds) {
        if (mediaItemId == null || seconds == null) {
            throw new InvalidArgumentException("Cannot set MediaItem bookmark. Required data is missing.");
        }
        log.debug(String.format("Bookmarking MediaItem (id = %s) at %s seconds", mediaItemId, seconds));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET bookmark = ? WHERE id = ?");
            ps.setInt(1, seconds);
            ps.setLong(2, mediaItemId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot set bookmark for MediaItem %s", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<MediaItem> getDirtyMediaItemsInRepository(Long repositoryId) {
        List<MediaItem> list;
        log.debug(String.format("Reading dirty MediaItems for Repository (id = %s)", repositoryId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, file_path, folder_id, creation_date, description, file_type, last_viewed_date, number_viewed, dirty, bookmark, cover_image_id, repository_id FROM media_item where media_item.repository_id = ? and media_item.dirty = 1");
            ps.setLong(1, repositoryId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read dirty MediaItems for Repository with id = %s", repositoryId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public void markMediaItemAsRead(Long mediaItemId) {
        if (mediaItemId == null) {
            throw new InvalidArgumentException("Cannot mark MediaItem as read. Required data is missing.");
        }
        log.debug(String.format("Marking MediaItem (id = %s) as read", mediaItemId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET last_viewed_date = " + MediaItemDAOImpl.currentTimestamp() + ", number_viewed = (number_viewed + 1) WHERE id = ?");
            ps.setLong(1, mediaItemId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot mark MediaItem %s as read", mediaItemId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    protected MediaItem mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initMediaItem(rs);
        }
        return null;
    }

    protected List<MediaItem> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<MediaItem> result = new ArrayList<MediaItem>();
        while (rs.next()) {
            result.add(this.initMediaItem(rs));
        }
        return result;
    }

    private MediaItem initMediaItem(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        Long fileSize = JdbcUtils.getLongFromResultSet(rs, "file_size");
        String fileName = rs.getString("file_name");
        String filePath = rs.getString("file_path");
        Long folderId = rs.getLong("folder_id");
        Long repositoryId = rs.getLong("repository_id");
        Timestamp date = rs.getTimestamp("creation_date");
        String description = rs.getString("description");
        Timestamp lastViewed = rs.getTimestamp("last_viewed_date");
        Integer numberViewed = rs.getInt("number_viewed");
        Integer bookmark = rs.getInt("bookmark");
        Long coverImageId = rs.getLong("cover_image_id");
        boolean dirty = rs.getBoolean("dirty");
        MediaFileType fileType = MediaFileType.valueOf(rs.getString("file_type"));
        MediaItem item = new MediaItem(title, fileName, filePath, fileSize, folderId, repositoryId, date, fileType);
        item.setId(id);
        item.setDescription(description);
        item.setSortTitle(sortTitle);
        item.setDirty(dirty);
        item.setLastViewedDate(lastViewed);
        item.setNumberViewed(numberViewed);
        item.setBookmark(bookmark);
        item.setThumbnailId(coverImageId);
        return item;
    }
}

