/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.SamplingMode;
import org.serviio.library.dao.AbstractSortableItemDao;
import org.serviio.library.dao.ImageDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Image;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDAOImpl
extends AbstractSortableItemDao
implements ImageDAO {
    private static final Logger log = LoggerFactory.getLogger(ImageDAOImpl.class);

    @Override
    public long create(Image newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null) {
            throw new InvalidArgumentException("Cannot create Image. Required data is missing.");
        }
        log.debug(String.format("Creating a new Image (name = %s)", newInstance.getTitle()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO media_item (file_type, title, file_size, file_name, folder_id,container, creation_date, description, sort_title, width, height, color_depth, cover_image_id, rotation, file_path, repository_id, subsampling, dirty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setString(2, JdbcUtils.trimToMaxLength(newInstance.getTitle(), 128));
            ps.setLong(3, newInstance.getFileSize());
            ps.setString(4, newInstance.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 5, newInstance.getFolderId());
            ps.setString(6, newInstance.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 7, newInstance.getDate());
            JdbcUtils.setStringValueOnStatement(ps, 8, newInstance.getDescription());
            ps.setString(9, JdbcUtils.trimToMaxLength(this.createSortName(newInstance.getTitle()), 128));
            JdbcUtils.setIntValueOnStatement(ps, 10, newInstance.getWidth());
            JdbcUtils.setIntValueOnStatement(ps, 11, newInstance.getHeight());
            JdbcUtils.setIntValueOnStatement(ps, 12, newInstance.getColorDepth());
            JdbcUtils.setLongValueOnStatement(ps, 13, newInstance.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 14, newInstance.getRotation());
            ps.setString(15, newInstance.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 16, newInstance.getRepositoryId());
            JdbcUtils.setStringValueOnStatement(ps, 17, newInstance.getChromaSubsampling() != null ? newInstance.getChromaSubsampling().toString() : null);
            ps.setInt(18, newInstance.isDirty() ? 1 : 0);
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Image with name %s", newInstance.getTitle()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting an Image (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete Image with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public Image read(Long id) throws PersistenceException {
        Image image;
        log.debug(String.format("Reading an Image (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, dirty, file_path, repository_id, subsampling FROM media_item WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            image = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Image with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return image;
    }

    @Override
    public void update(Image transientObject) throws InvalidArgumentException, PersistenceException {
        if (transientObject == null || transientObject.getId() == null || ObjectValidator.isEmpty(transientObject.getTitle()) || ObjectValidator.isEmpty(transientObject.getFileName()) || transientObject.getFileSize() == null || transientObject.getFolderId() == null) {
            throw new InvalidArgumentException("Cannot update Image. Required data is missing.");
        }
        log.debug(String.format("Updating Image (id = %s)", transientObject.getId()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("UPDATE media_item SET title = ?, file_size = ?, file_name = ?, folder_id = ?, container =?, creation_date = ?, description = ?, width = ?, height = ?, color_depth = ?, sort_title = ?, cover_image_id = ?, rotation = ?, file_path = ?, repository_id = ?, subsampling = ?, dirty = ? WHERE id = ?");
            ps.setString(1, JdbcUtils.trimToMaxLength(transientObject.getTitle(), 128));
            ps.setLong(2, transientObject.getFileSize());
            ps.setString(3, transientObject.getFileName());
            JdbcUtils.setLongValueOnStatement(ps, 4, transientObject.getFolderId());
            ps.setString(5, transientObject.getContainer().toString());
            JdbcUtils.setTimestampValueOnStatement(ps, 6, transientObject.getDate());
            JdbcUtils.setStringValueOnStatement(ps, 7, transientObject.getDescription());
            JdbcUtils.setIntValueOnStatement(ps, 8, transientObject.getWidth());
            JdbcUtils.setIntValueOnStatement(ps, 9, transientObject.getHeight());
            JdbcUtils.setIntValueOnStatement(ps, 10, transientObject.getColorDepth());
            ps.setString(11, JdbcUtils.trimToMaxLength(this.createSortName(transientObject.getTitle()), 128));
            JdbcUtils.setLongValueOnStatement(ps, 12, transientObject.getThumbnailId());
            JdbcUtils.setIntValueOnStatement(ps, 13, transientObject.getRotation());
            ps.setString(14, transientObject.getFilePath());
            JdbcUtils.setLongValueOnStatement(ps, 15, transientObject.getRepositoryId());
            JdbcUtils.setStringValueOnStatement(ps, 16, transientObject.getChromaSubsampling() != null ? transientObject.getChromaSubsampling().toString() : null);
            ps.setInt(17, transientObject.isDirty() ? 1 : 0);
            ps.setLong(18, transientObject.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot update Image with id %s", transientObject.getId()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public List<Image> retrieveImagesForFolder(Long folderId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Image> list;
        log.debug(String.format("Retrieving list of images for folder %s (from=%s, count=%s) [%s]", folderId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, file_path, media_item.repository_id as repository_id, subsampling, dirty FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? AND folder_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY lower(file_name) " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of images for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveImagesForFolderCount(Long folderId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of images for folder %s [%s]", folderId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? AND folder_id = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setLong(2, folderId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of images for folder %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Image> retrieveImagesForPlaylist(Long playlistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Image> list;
        log.debug(String.format("Retrieving list of images for Playlist %s (from=%s, count=%s) [%s]", playlistId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, file_path, media_item.repository_id as repository_id, subsampling, dirty FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND file_type = ? and p.playlist_id = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY p.item_order " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setLong(2, playlistId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of images for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveImagesForPlaylistCount(Long playlistId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of images for playlist %s [%s]", playlistId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item, playlist_item p " + this.accessGroupTable(accessGroup) + "WHERE p.media_item_id = media_item.id AND p.playlist_id = ? AND media_item.file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setLong(1, playlistId);
            ps.setString(2, MediaFileType.IMAGE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of images for playlist %s", playlistId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Integer> retrieveImagesCreationYears(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        ArrayList<Integer> arrayList;
        log.debug(String.format("Retrieving list of images' years (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT distinct YEAR(creation_date) as creation_year FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY creation_year desc " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> years = new ArrayList<Integer>();
            while (rs.next()) {
                years.add(rs.getInt("creation_year"));
            }
            arrayList = years;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of images' years", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveImagesCreationYearsCount(AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of images' years [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct YEAR(creation_date)) as c FROM media_item" + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of images' years", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Image> retrieveImagesForYear(Integer year, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Image> list;
        log.debug(String.format("Retrieving list of images for year %s (from=%s, count=%s) [%s]", year, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, file_path, media_item.repository_id as repository_id, subsampling, dirty FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and YEAR(creation_date) = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY creation_date, lower(sort_title) " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of images for year %s", year), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveImagesForYearCount(Integer year, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of images for year %s [%s]", year, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and year(creation_date) = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of images for year %s", year), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Integer> retrieveImagesCreationMonths(Integer year, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        ArrayList<Integer> arrayList;
        log.debug(String.format("Retrieving list of creation date months for year %s (from=%s, count=%s) [%s]", year, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT distinct MONTH(creation_date) as creation_month FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and YEAR(creation_date) = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY creation_month " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> months = new ArrayList<Integer>();
            while (rs.next()) {
                months.add(rs.getInt("creation_month"));
            }
            arrayList = months;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of creation date months for year %s", year), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return arrayList;
    }

    @Override
    public int retrieveImagesCreationMonthsCount(Integer year, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of  creation date months for year %s [%s]", year, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(distinct MONTH(creation_date)) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and year(creation_date) = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of creation date months for year %s", year), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Image> retrieveImagesForMonthOfYear(Integer month, Integer year, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Image> list;
        log.debug(String.format("Retrieving list of images for year %s and month %s (from=%s, count=%s) [%s]", year, month, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, file_path, media_item.repository_id as repository_id, subsampling, dirty FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and YEAR(creation_date) = ? and MONTH(creation_date) = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY creation_date, lower(sort_title) " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ps.setInt(3, month);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of images for year %s and month %s", year, month), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveImagesForMonthOfYearCount(Integer month, Integer year, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of images for year %s and month %s [%s]", year, month, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? and year(creation_date) = ? and month(creation_date) = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ps.setInt(2, year);
            ps.setInt(3, month);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of images for year %s and month %s", year, month), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Image> retrieveAllImages(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Image> list;
        log.debug(String.format("Retrieving list of all images (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT media_item.id as id, title, sort_title, file_size, file_name, folder_id, container, creation_date, description, width, height, color_depth, cover_image_id, last_viewed_date, number_viewed, rotation, file_path, media_item.repository_id as repository_id, subsampling, dirty FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ? " + this.accessGroupConditionForMediaItem(accessGroup) + "ORDER BY creation_date, lower(file_name) " + ImageDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of all images", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int retrieveAllImagesCount(AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of all images [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as c FROM media_item " + this.accessGroupTable(accessGroup) + "WHERE file_type = ?" + this.accessGroupConditionForMediaItem(accessGroup));
            ps.setString(1, MediaFileType.IMAGE.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of all images", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected Image mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initImage(rs);
        }
        return null;
    }

    protected List<Image> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Image> result = new ArrayList<Image>();
        while (rs.next()) {
            result.add(this.initImage(rs));
        }
        return result;
    }

    private Image initImage(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String title = rs.getString("title");
        String sortTitle = rs.getString("sort_title");
        Long fileSize = JdbcUtils.getLongFromResultSet(rs, "file_size");
        String fileName = rs.getString("file_name");
        String filePath = rs.getString("file_path");
        Long folderId = rs.getLong("folder_id");
        Long repositoryId = rs.getLong("repository_id");
        ImageContainer container = rs.getString("container") != null ? ImageContainer.valueOf(rs.getString("container")) : null;
        Timestamp date = rs.getTimestamp("creation_date");
        String description = rs.getString("description");
        Integer width = JdbcUtils.getIntFromResultSet(rs, "width");
        Integer height = JdbcUtils.getIntFromResultSet(rs, "height");
        Integer colorDepth = JdbcUtils.getIntFromResultSet(rs, "color_depth");
        Long thumbnailId = JdbcUtils.getLongFromResultSet(rs, "cover_image_id");
        Timestamp lastViewed = rs.getTimestamp("last_viewed_date");
        Integer numberViewed = rs.getInt("number_viewed");
        Integer rotation = rs.getInt("rotation");
        SamplingMode chromaSubsampling = rs.getString("subsampling") != null ? SamplingMode.valueOf(rs.getString("subsampling")) : null;
        boolean dirty = rs.getBoolean("dirty");
        Image image = new Image(title, container, fileName, filePath, fileSize, folderId, repositoryId, date);
        image.setId(id);
        image.setSortTitle(sortTitle);
        image.setDescription(description);
        image.setWidth(width);
        image.setHeight(height);
        image.setColorDepth(colorDepth);
        image.setThumbnailId(thumbnailId);
        image.setLastViewedDate(lastViewed);
        image.setNumberViewed(numberViewed);
        image.setRotation(rotation);
        image.setChromaSubsampling(chromaSubsampling);
        image.setDirty(dirty);
        return image;
    }
}

