/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.JdbcExecutor;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractDao;
import org.serviio.library.dao.GenreDAO;
import org.serviio.library.entities.Genre;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenreDAOImpl
extends AbstractDao
implements GenreDAO {
    private static final Logger log = LoggerFactory.getLogger(GenreDAOImpl.class);

    @Override
    public long create(Genre newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || ObjectValidator.isEmpty(newInstance.getName())) {
            throw new InvalidArgumentException("Cannot create Genre. Required data is missing.");
        }
        log.debug(String.format("Creating a new Genre (name = %s)", newInstance.getName()));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO genre (name) VALUES (?)", 1);
            ps.setString(1, JdbcUtils.trimToMaxLength(newInstance.getName(), 128));
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Genre with name %s", newInstance.getName()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(final Long id) throws PersistenceException {
        log.debug(String.format("Deleting a Genre (id = %s)", id));
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM genre WHERE id = ?");
                    ps.setLong(1, id);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete Genre with id = %s", id), e);
        }
    }

    @Override
    public Genre read(Long id) throws PersistenceException {
        Genre genre;
        log.debug(String.format("Reading a Genre (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name FROM genre where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            genre = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Genre with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return genre;
    }

    @Override
    public void update(Genre transientObject) throws InvalidArgumentException, PersistenceException {
        throw new UnsupportedOperationException("Genre update is not supported");
    }

    @Override
    public Genre findGenreByName(String name) {
        Genre genre;
        log.debug(String.format("Reading a Genre (name = %s)", name));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name FROM genre where lower(name) = ?");
            ps.setString(1, StringUtils.localeSafeToLowercase(name));
            ResultSet rs = ps.executeQuery();
            genre = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Genre with name = %s", name), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return genre;
    }

    @Override
    public int getNumberOfMediaItems(Long genreId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of media items for genre %s", genreId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as items from media_item, genre WHERE media_item.genre_id = genre.id AND genre.id = ?");
            ps.setLong(1, genreId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("items");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of media items for genre: %s ", genreId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Genre> retrieveGenres(MediaFileType fileType, int startingIndex, int requestedCount, boolean filterOutSeries) {
        List<Genre> list;
        log.debug(String.format("Retrieving list of genres for %s (from=%s, count=%s)", new Object[]{fileType, startingIndex, requestedCount}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(genre.id) as id, genre.name as name FROM genre, media_item WHERE media_item.genre_id = genre.id AND media_item.file_type = ? " + this.seriesContentTypeCondition(filterOutSeries) + "ORDER BY lower(genre.name) " + GenreDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read list of genres for %s", new Object[]{fileType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getGenreCount(MediaFileType fileType, boolean filterOutSeries) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of genres for %s", new Object[]{fileType}));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT(genre.id)) as c FROM genre, media_item WHERE media_item.genre_id = genre.id AND media_item.file_type = ?" + this.seriesContentTypeCondition(filterOutSeries));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read number of genres for %s", new Object[]{fileType}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    protected Genre mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initGenre(rs);
        }
        return null;
    }

    protected List<Genre> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Genre> result = new ArrayList<Genre>();
        while (rs.next()) {
            result.add(this.initGenre(rs));
        }
        return result;
    }

    private Genre initGenre(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        Genre genre = new Genre(name);
        genre.setId(id);
        return genre;
    }
}

