/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.serviio.db.DatabaseManager;
import org.serviio.db.JdbcExecutor;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractAccessibleDao;
import org.serviio.library.dao.FolderDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Folder;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.util.JdbcUtils;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderDAOImpl
extends AbstractAccessibleDao
implements FolderDAO {
    private static final Logger log = LoggerFactory.getLogger(FolderDAOImpl.class);

    @Override
    public long create(Folder newInstance) throws InvalidArgumentException, PersistenceException {
        if (newInstance == null || newInstance.getRepositoryId() == null) {
            throw new InvalidArgumentException("Cannot create Folder. Required data is missing.");
        }
        log.debug(String.format("Creating a new Folder (name = %s)", newInstance.getName()));
        Connection con = null;
        try {
            con = DatabaseManager.getConnection();
            long l = this.create(con, newInstance);
            return l;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot create Folder with name %s", newInstance.getName()), e);
        }
        finally {
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public void delete(final Long id) throws PersistenceException {
        log.debug(String.format("Deleting a Folder (id = %s)", id));
        try {
            new JdbcExecutor<Integer>(){

                @Override
                protected PreparedStatement processStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("DELETE FROM folder WHERE id = ?");
                    ps.setLong(1, id);
                    ps.executeUpdate();
                    return ps;
                }
            }.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot delete Folder with id = %s", id), e);
        }
    }

    @Override
    public Folder read(Long id) throws PersistenceException {
        log.debug(String.format("Reading a Folder (id = %s)", id));
        Connection con = null;
        try {
            con = DatabaseManager.getConnection();
            Folder folder = this.readFolder(id, con);
            return folder;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot read Folder with id = %s", id), e);
        }
        finally {
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public void update(Folder transientObject) throws InvalidArgumentException, PersistenceException {
        throw new UnsupportedOperationException("Folder update is not supported");
    }

    @Override
    public Tupple<Long, List<Tupple<Long, String>>> getFolderHierarchy(Long folderId) {
        log.debug(String.format("Reading a Folder hierarchy (id = %s)", folderId));
        Connection con = null;
        Statement ps = null;
        ArrayList<Tupple<Long, String>> pathHierarchy = new ArrayList<Tupple<Long, String>>();
        try {
            Folder folder;
            con = DatabaseManager.getConnection();
            Long fId = folderId;
            do {
                if ((folder = this.readFolder(fId, con)).getName().equals("<virtual>")) continue;
                pathHierarchy.add(new Tupple<Long, String>(folder.getId(), folder.getName()));
            } while ((fId = folder.getParentFolderId()) != null);
            Collections.reverse(pathHierarchy);
            Tupple<Long, List<Tupple<Long, String>>> tupple = new Tupple<Long, List<Tupple<Long, String>>>(folderId, pathHierarchy);
            return tupple;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot create file path hierarchy for Folder %s", folderId), e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public Tupple<Long, List<Tupple<Long, String>>> getOrCreateFolder(File folderPath, Long repositoryId) {
        String[] filePathElements = null;
        boolean onlyVirtual = false;
        if (folderPath == null) {
            filePathElements = new String[]{"<virtual>"};
            onlyVirtual = true;
        } else {
            log.debug(String.format("Looking for folder hierarchy %s", folderPath.getPath()));
            filePathElements = folderPath.getPath().endsWith(":" + File.separator) ? new String[]{folderPath.getPath()} : folderPath.getPath().split(Pattern.quote(File.separator));
        }
        Connection con = null;
        Statement ps = null;
        ArrayList<Tupple<Long, String>> pathHierarchy = new ArrayList<Tupple<Long, String>>();
        try {
            con = DatabaseManager.getConnection();
            boolean createNecessary = false;
            Long parentFolderId = null;
            Long lastFolderId = null;
            for (int i = 0; i < filePathElements.length; ++i) {
                if (createNecessary) {
                    lastFolderId = this.create(con, new Folder(filePathElements[i], repositoryId, parentFolderId));
                    if (!onlyVirtual) {
                        pathHierarchy.add(new Tupple<Long, String>(lastFolderId, filePathElements[i]));
                    }
                } else {
                    lastFolderId = this.findFolderById(con, filePathElements[i], repositoryId, parentFolderId);
                    if (lastFolderId == null) {
                        lastFolderId = this.create(con, new Folder(filePathElements[i], repositoryId, parentFolderId));
                        createNecessary = true;
                    }
                    if (!onlyVirtual) {
                        pathHierarchy.add(new Tupple<Long, String>(lastFolderId, filePathElements[i]));
                    }
                }
                parentFolderId = new Long(lastFolderId);
            }
            Tupple tupple = new Tupple(lastFolderId, pathHierarchy);
            return tupple;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot create file path for Folder %s", folderPath.getPath()), e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public int getNumberOfMediaItems(Long folderId) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of media items in folder %s", folderId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT count(media_item.id) as items from media_item WHERE media_item.folder_id = ?");
            ps.setLong(1, folderId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("items");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of media items in folder: %s ", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public int getNumberOfSubFolders(Long folderId, Long repositoryId, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Getting number of sub-Folders in folder %s [%s]", folderId, accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            String sql = "SELECT count(folder.id) as subfolders from folder " + this.accessGroupTable(accessGroup) + "WHERE folder.name <> ?";
            sql = folderId == null ? sql + " and folder.parent_folder_id is null and folder.repository_id = " + repositoryId.toString() : sql + " and folder.parent_folder_id = " + folderId.toString();
            sql = sql + this.accessGroupConditionForFolder(accessGroup);
            ps = con.prepareStatement(sql);
            ps.setString(1, "<virtual>");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("subfolders");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of sub-Folders in folder: %s ", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public int getNumberOfFoldersAndMediaItems(MediaFileType fileType, ObjectType objectType, AccessGroup accessGroup, Long folderId, Long repositoryId) {
        int n;
        log.debug(String.format("Getting number of %s sub-folders and media items in folder %s (filter: %s) [%s]", new Object[]{fileType, folderId == null ? "'root'" : folderId, objectType, accessGroup}));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            String sql = "SELECT count(folder.id) FROM folder" + this.accessGroupTable(accessGroup) + "WHERE folder.name <> ?";
            sql = folderId == null ? sql + " and folder.parent_folder_id is null and folder.repository_id = " + repositoryId.toString() : sql + " and folder.parent_folder_id = " + folderId.toString();
            sql = sql + this.accessGroupConditionForFolder(accessGroup);
            sql = sql + " UNION ALL ";
            sql = sql + "SELECT count(media_item.id) FROM media_item" + this.accessGroupTable(accessGroup) + " WHERE media_item.file_type = ? ";
            sql = folderId == null ? sql + "AND media_item.folder_id = (SELECT id FROM folder where name = '" + "<virtual>" + "' " + "AND repository_id = " + repositoryId.toString() + " AND parent_folder_id IS NULL)" : sql + "AND media_item.folder_id = " + folderId.toString();
            sql = sql + this.accessGroupConditionForMediaItem(accessGroup);
            ps = con.prepareStatement(sql);
            ps.setString(1, "<virtual>");
            ps.setString(2, fileType.toString());
            ResultSet rs = ps.executeQuery();
            int count = 0;
            if (rs.next() && objectType.supportsContainers()) {
                count += rs.getInt(1);
            }
            if (rs.next() && objectType.supportsItems()) {
                count += rs.getInt(1);
            }
            n = count;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get number of %s media items in folder: %s ", new Object[]{fileType, folderId}), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public Long retrieveVirtualFolderId(Long repositoryId) {
        Connection con = null;
        try {
            con = DatabaseManager.getConnection();
            Long l = this.findFolderById(con, "<virtual>", repositoryId, null);
            return l;
        }
        catch (SQLException e) {
            throw new PersistenceException("Cannot read virtual folder id", e);
        }
        finally {
            DatabaseManager.releaseConnection(con);
        }
    }

    @Override
    public List<Folder> retrieveFoldersWithMedia(MediaFileType fileType, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Folder> list;
        log.debug(String.format("Retrieving list of leaf folders (from=%s, count=%s) [%s]", startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT DISTINCT(folder.id) as id, folder.name as name, parent_folder_id, folder.repository_id as repository_id FROM folder, media_item m" + this.accessGroupTable(accessGroup) + "WHERE folder.id = m.folder_id AND m.file_type = ?" + this.accessGroupConditionForFolder(accessGroup) + "ORDER BY lower(folder.name), id " + FolderDAOImpl.paginationQuery(startingIndex, requestedCount));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of leaf folders", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public int getFoldersWithMediaCount(MediaFileType fileType, AccessGroup accessGroup) {
        int n;
        PreparedStatement ps;
        Connection con;
        block5: {
            log.debug(String.format("Retrieving number of leaf folders [%s]", accessGroup));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT COUNT(DISTINCT(folder.id)) as c FROM folder, media_item m" + this.accessGroupTable(accessGroup) + "WHERE folder.id = m.folder_id AND m.file_type = ?" + this.accessGroupConditionForFolder(accessGroup));
            ps.setString(1, fileType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Integer count = rs.getInt("c");
            int n2 = count;
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read number of leaf folders", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return n;
    }

    @Override
    public List<Folder> retrieveSubFolders(Long folderId, Long repositoryId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        List<Folder> list;
        log.debug(String.format("Getting list of sub-Folders in folder %s (from=%s, count=%s) [%s]", folderId, startingIndex, requestedCount, accessGroup));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            String sql = "SELECT folder.id as id, name, parent_folder_id, folder.repository_id as repository_id FROM folder " + this.accessGroupTable(accessGroup) + "WHERE folder.repository_id = ? AND folder.name <> ?";
            sql = folderId == null ? sql + " and folder.parent_folder_id is null" : sql + " and folder.parent_folder_id = " + folderId.toString();
            sql = sql + this.accessGroupConditionForFolder(accessGroup);
            sql = sql + " ORDER BY name " + FolderDAOImpl.paginationQuery(startingIndex, requestedCount);
            ps = con.prepareStatement(sql);
            ps.setLong(1, repositoryId);
            ps.setString(2, "<virtual>");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot get list of sub-Folders in folder: %s ", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<Folder> getFoldersInRepository(Long repositoryId) {
        List<Folder> list;
        log.debug(String.format("Retrieving list of folders for repository %s", repositoryId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name, parent_folder_id, repository_id FROM folder WHERE repository_id = ?");
            ps.setLong(1, repositoryId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read list of repository folders", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    protected Folder mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initFolder(rs);
        }
        return null;
    }

    protected List<Folder> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<Folder> result = new ArrayList<Folder>();
        while (rs.next()) {
            result.add(this.initFolder(rs));
        }
        return result;
    }

    private Folder initFolder(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        Long parentId = JdbcUtils.getLongFromResultSet(rs, "parent_folder_id");
        Long repositoryId = JdbcUtils.getLongFromResultSet(rs, "repository_id");
        Folder folder = new Folder(name, repositoryId, parentId);
        folder.setId(id);
        return folder;
    }

    protected Long findFolderById(Connection con, String name, Long repositoryId, Long parentFolderId) {
        Long l;
        PreparedStatement ps;
        block7: {
            ps = null;
            if (parentFolderId == null) {
                ps = con.prepareStatement("SELECT id FROM folder where name = ? AND repository_id = ? AND parent_folder_id IS NULL");
                ps.setString(1, name);
                ps.setLong(2, repositoryId);
            } else {
                ps = con.prepareStatement("SELECT id FROM folder where name = ? AND repository_id = ? AND parent_folder_id = ?");
                ps.setString(1, name);
                ps.setLong(2, repositoryId);
                ps.setLong(3, parentFolderId);
            }
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block7;
            Long l2 = JdbcUtils.getLongFromResultSet(rs, "id");
            JdbcUtils.closeStatement(ps);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read Folder with name = %s", name), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        return l;
    }

    private long create(Connection con, Folder newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO folder (name, repository_id, parent_folder_id) VALUES (?,?,?)", 1);
            ps.setString(1, JdbcUtils.trimToMaxLength(newInstance.getName(), 128));
            ps.setLong(2, newInstance.getRepositoryId());
            JdbcUtils.setLongValueOnStatement(ps, 3, newInstance.getParentFolderId());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot create Folder with name %s", newInstance.getName()), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        return l;
    }

    private Folder readFolder(Long id, Connection con) throws PersistenceException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("SELECT id, name, parent_folder_id, repository_id FROM folder where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            Folder folder = this.mapSingleResult(rs);
            return folder;
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Cannot read Folder with id = %s", id), e);
        }
        finally {
            JdbcUtils.closeStatement(ps);
        }
    }
}

