/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AbstractDao;
import org.serviio.library.dao.CoverImageDAO;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverImageDAOImpl
extends AbstractDao
implements CoverImageDAO {
    private static final Logger log = LoggerFactory.getLogger(CoverImageDAOImpl.class);

    @Override
    public long create(CoverImage newInstance) throws InvalidArgumentException, PersistenceException {
        long l;
        if (newInstance == null || newInstance.getImageBytes() == null) {
            throw new InvalidArgumentException("Cannot create CoverImage. Required data is missing.");
        }
        log.debug(String.format("Creating a new ImageCover (length = %s)", newInstance.getImageBytes().length));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("INSERT INTO cover_image (image_data, mime_type, width, height, image_data_hd, width_hd, height_hd) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setBinaryStream(1, new ByteArrayInputStream(newInstance.getImageBytes()));
            ps.setString(2, newInstance.getMimeType());
            JdbcUtils.setIntValueOnStatement(ps, 3, newInstance.getWidth());
            JdbcUtils.setIntValueOnStatement(ps, 4, newInstance.getHeight());
            ps.setBinaryStream(5, new ByteArrayInputStream(newInstance.getImageBytesHD()));
            JdbcUtils.setIntValueOnStatement(ps, 6, newInstance.getWidthHD());
            JdbcUtils.setIntValueOnStatement(ps, 7, newInstance.getHeightHD());
            ps.executeUpdate();
            l = JdbcUtils.retrieveGeneratedID(ps);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot create CoverImage", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public void delete(Long id) throws PersistenceException {
        log.debug(String.format("Deleting a CoverImage (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("DELETE FROM cover_image WHERE id = ?");
            ps.setLong(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot delete CoverImage with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
    }

    @Override
    public CoverImage read(Long id) throws PersistenceException {
        CoverImage coverImage;
        log.debug(String.format("Reading a CoverImage (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, image_data, mime_type, width, height, image_data_hd, width_hd, height_hd FROM cover_image where id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            coverImage = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read CoverImage with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return coverImage;
    }

    @Override
    public void update(CoverImage transientObject) throws InvalidArgumentException, PersistenceException {
        throw new UnsupportedOperationException("CoverImage update is not supported");
    }

    @Override
    public Long getCoverImageForMusicAlbum(Long albumId) {
        Long l;
        PreparedStatement ps;
        Connection con;
        block5: {
            Long id;
            log.debug(String.format("Reading a CoverImage for music album (id = %s)", albumId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT cover_image_id from media_item WHERE album_id = ? and cover_image_id is not null " + CoverImageDAOImpl.limitQuery(1));
            ps.setLong(1, albumId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Long l2 = id = Long.valueOf(rs.getLong("cover_image_id"));
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read CoverImage for album id = %s", albumId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public Long getCoverImageForFolder(Long folderId, MediaFileType fileType) {
        Long l;
        PreparedStatement ps;
        Connection con;
        block5: {
            Long id;
            log.debug(String.format("Reading a CoverImage for folder (id = %s)", folderId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT cover_image_id from media_item WHERE folder_id = ? and file_type = ? and cover_image_id is not null ORDER BY id " + CoverImageDAOImpl.limitQuery(1));
            ps.setLong(1, folderId);
            ps.setString(2, fileType.toString());
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Long l2 = id = Long.valueOf(rs.getLong("cover_image_id"));
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read CoverImage for folder id = %s", folderId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public Long getCoverImageForPerson(Long personId) {
        Long l;
        PreparedStatement ps2;
        PreparedStatement ps1;
        Connection con;
        block5: {
            Long id;
            log.debug(String.format("Reading a CoverImage for person (id = %s)", personId));
            con = null;
            ps1 = null;
            ps2 = null;
            con = DatabaseManager.getConnection();
            ps1 = con.prepareStatement("SELECT media_item_id, music_album_id FROM person_role AS pr WHERE pr.person_id = ? " + CoverImageDAOImpl.limitQuery(1));
            ps1.setLong(1, personId);
            ResultSet rs1 = ps1.executeQuery();
            if (!rs1.next()) break block5;
            Long miId = JdbcUtils.getLongFromResultSet(rs1, "media_item_id");
            Long albId = JdbcUtils.getLongFromResultSet(rs1, "music_album_id");
            String whereClause = miId != null ? " id = ?" : "album_id = ?";
            ps2 = con.prepareStatement("SELECT cover_image_id as ciid from media_item WHERE " + whereClause + " AND cover_image_id is not null");
            ps2.setLong(1, miId != null ? miId : albId);
            ResultSet rs2 = ps2.executeQuery();
            if (!rs2.next()) break block5;
            Long l2 = id = Long.valueOf(rs2.getLong("ciid"));
            JdbcUtils.closeStatement(ps1);
            JdbcUtils.closeStatement(ps2);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read CoverImage for person id = %s", personId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps1);
                JdbcUtils.closeStatement(ps2);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps1);
        JdbcUtils.closeStatement(ps2);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    @Override
    public Long getCoverImageForRepository(Long repositoryId, MediaFileType fileType) {
        Long l;
        PreparedStatement ps;
        Connection con;
        block5: {
            Long id;
            log.debug(String.format("Reading a CoverImage for repository (id = %s)", repositoryId));
            con = null;
            ps = null;
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT mi.cover_image_id AS ciid from media_item as mi, folder as f WHERE mi.folder_id = f.id AND mi.file_type = ? AND f.name = ? AND mi.repository_id = ? and mi.cover_image_id IS NOT NULL ORDER BY mi.cover_image_id " + CoverImageDAOImpl.limitQuery(1));
            ps.setString(1, fileType.toString());
            ps.setString(2, "<virtual>");
            ps.setLong(3, repositoryId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) break block5;
            Long l2 = id = Long.valueOf(rs.getLong("ciid"));
            JdbcUtils.closeStatement(ps);
            DatabaseManager.releaseConnection(con);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read CoverImage for repository id = %s", repositoryId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return l;
    }

    protected CoverImage mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            Long id = rs.getLong("id");
            byte[] allBytesInBlob = JdbcUtils.convertBlob(rs.getBlob("image_data"));
            String mimeType = rs.getString("mime_type");
            Integer width = rs.getInt("width");
            Integer height = rs.getInt("height");
            byte[] allBytesInBlobHD = JdbcUtils.convertBlob(rs.getBlob("image_data_hd"));
            Integer widthHD = rs.getInt("width_hd");
            Integer heightHD = rs.getInt("height_hd");
            CoverImage coverImage = new CoverImage(allBytesInBlob, mimeType, width, height, allBytesInBlobHD, widthHD, heightHD);
            coverImage.setId(id);
            return coverImage;
        }
        return null;
    }
}

