/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.DatabaseManager;
import org.serviio.db.dao.InvalidArgumentException;
import org.serviio.db.dao.PersistenceException;
import org.serviio.library.dao.AccessGroupDAO;
import org.serviio.library.entities.AccessGroup;
import org.serviio.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessGroupDAOImpl
implements AccessGroupDAO {
    private static final Logger log = LoggerFactory.getLogger(AccessGroupDAOImpl.class);

    @Override
    public long create(AccessGroup newInstance) throws InvalidArgumentException {
        throw new RuntimeException("Operation not implemented");
    }

    @Override
    public void delete(Long id) {
        throw new RuntimeException("Operation not implemented");
    }

    @Override
    public AccessGroup read(Long id) {
        AccessGroup accessGroup;
        log.debug(String.format("Reading a AccessGroup (id = %s)", id));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT id, name FROM access_group WHERE id = ?");
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            accessGroup = this.mapSingleResult(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read AccessGroup with id = %s", id), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return accessGroup;
    }

    @Override
    public void update(AccessGroup transientObject) throws InvalidArgumentException {
        throw new RuntimeException("Operation not implemented");
    }

    @Override
    public List<AccessGroup> getAccessGroupsForRepository(Long repoId) {
        List<AccessGroup> list;
        log.debug(String.format("Reading all AccessGroups for Repository (id = %s)", repoId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT up.id, up.name FROM access_group up, repository_access_group ap WHERE ap.access_group_id = up.id AND ap.repository_id = ?");
            ps.setLong(1, repoId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read AccessGroups for repository id = %s", repoId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<AccessGroup> getAccessGroupsForOnlineRepository(Long repoId) {
        List<AccessGroup> list;
        log.debug(String.format("Reading all AccessGroups for OnlineRepository (id = %s)", repoId));
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT up.id, up.name FROM access_group up, online_repository_access_group ap WHERE ap.access_group_id = up.id AND ap.online_repository_id = ?");
            ps.setLong(1, repoId);
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(String.format("Cannot read AccessGroups for online repository id = %s", repoId), e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    @Override
    public List<AccessGroup> findAll() {
        List<AccessGroup> list;
        log.debug("Reading all AccessGroups");
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DatabaseManager.getConnection();
            ps = con.prepareStatement("SELECT up.id, up.name FROM access_group up ORDER BY up.id");
            ResultSet rs = ps.executeQuery();
            list = this.mapResultSet(rs);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Cannot read all AccessGroups", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                DatabaseManager.releaseConnection(con);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        DatabaseManager.releaseConnection(con);
        return list;
    }

    protected AccessGroup mapSingleResult(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.initUserProfile(rs);
        }
        return null;
    }

    protected List<AccessGroup> mapResultSet(ResultSet rs) throws SQLException {
        ArrayList<AccessGroup> result = new ArrayList<AccessGroup>();
        while (rs.next()) {
            result.add(this.initUserProfile(rs));
        }
        return result;
    }

    private AccessGroup initUserProfile(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        AccessGroup profile = new AccessGroup(name);
        profile.setId(id);
        return profile;
    }
}

