/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import org.serviio.db.DatabaseManager;

public abstract class AbstractDao {
    private static String currentTimestamp = null;
    private static String randomFunction = null;

    protected String seriesContentTypeCondition(boolean filterOutSeries) {
        if (!filterOutSeries) {
            return " ";
        }
        return " AND media_item.series_id IS NULL ";
    }

    protected static String paginationQuery(int offset, int size) {
        StringBuffer sb = new StringBuffer();
        if (DatabaseManager.getDBType() == DatabaseManager.DBType.DERBY) {
            sb.append("OFFSET ").append(offset).append(" ROWS FETCH FIRST ").append(size).append(" ROWS ONLY");
            return sb.toString();
        }
        if (DatabaseManager.getDBType() == DatabaseManager.DBType.MYSQL) {
            sb.append("LIMIT ").append(size).append(" OFFSET ").append(offset);
            return sb.toString();
        }
        throw new RuntimeException("Unsupported DB type: " + (Object)((Object)DatabaseManager.getDBType()));
    }

    protected static String limitQuery(int size) {
        StringBuffer sb = new StringBuffer();
        if (DatabaseManager.getDBType() == DatabaseManager.DBType.DERBY) {
            sb.append("FETCH FIRST ").append(size).append(" ROWS ONLY");
            return sb.toString();
        }
        if (DatabaseManager.getDBType() == DatabaseManager.DBType.MYSQL) {
            sb.append("LIMIT ").append(size);
            return sb.toString();
        }
        throw new RuntimeException("Unsupported DB type: " + (Object)((Object)DatabaseManager.getDBType()));
    }

    protected static String currentTimestamp() {
        if (currentTimestamp == null) {
            if (DatabaseManager.getDBType() == DatabaseManager.DBType.DERBY) {
                currentTimestamp = "CURRENT TIMESTAMP";
            } else if (DatabaseManager.getDBType() == DatabaseManager.DBType.MYSQL) {
                currentTimestamp = "CURRENT_TIMESTAMP";
            } else {
                throw new RuntimeException("Unsupported DB type: " + (Object)((Object)DatabaseManager.getDBType()));
            }
        }
        return currentTimestamp;
    }

    protected static String randomFunction() {
        if (randomFunction == null) {
            if (DatabaseManager.getDBType() == DatabaseManager.DBType.DERBY) {
                randomFunction = "random()";
            } else if (DatabaseManager.getDBType() == DatabaseManager.DBType.MYSQL) {
                randomFunction = "RAND()";
            } else {
                throw new RuntimeException("Unsupported DB type: " + (Object)((Object)DatabaseManager.getDBType()));
            }
        }
        return randomFunction;
    }
}

