/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.dao;

import org.serviio.library.dao.AbstractDao;
import org.serviio.library.entities.AccessGroup;

public abstract class AbstractAccessibleDao
extends AbstractDao {
    protected String accessGroupTable(AccessGroup accessGroup) {
        if (accessGroup == AccessGroup.ANY) {
            return " ";
        }
        return ", repository_access_group ";
    }

    protected String onlineAccessGroupTable(AccessGroup accessGroup) {
        if (accessGroup == AccessGroup.ANY) {
            return " ";
        }
        return ", online_repository_access_group ";
    }

    protected String accessGroupConditionForMediaItem(AccessGroup accessGroup) {
        return this.generateAccessGroupCondition(accessGroup, "media_item.repository_id");
    }

    protected String accessGroupConditionForOnlineRepository(AccessGroup accessGroup) {
        return this.generateOnlineAccessGroupCondition(accessGroup, "online_repository.id");
    }

    protected String accessGroupConditionForRepository(AccessGroup accessGroup) {
        return this.generateAccessGroupCondition(accessGroup, "repository.id");
    }

    protected String accessGroupConditionForFolder(AccessGroup accessGroup) {
        return this.generateAccessGroupCondition(accessGroup, "folder.repository_id");
    }

    protected String accessGroupConditionForPlaylist(AccessGroup accessGroup) {
        return this.generateAccessGroupCondition(accessGroup, "playlist.repository_id");
    }

    private String generateAccessGroupCondition(AccessGroup accessGroup, String tableAndRepoIdName) {
        if (accessGroup == AccessGroup.ANY) {
            return " ";
        }
        return " AND repository_access_group.repository_id = " + tableAndRepoIdName + " AND repository_access_group.access_group_id = " + accessGroup.getId() + " ";
    }

    private String generateOnlineAccessGroupCondition(AccessGroup accessGroup, String tableAndRepoIdName) {
        if (accessGroup == AccessGroup.ANY) {
            return " ";
        }
        return " AND online_repository_access_group.online_repository_id = " + tableAndRepoIdName + " AND online_repository_access_group.access_group_id = " + accessGroup.getId() + " ";
    }
}

