/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.util.List;
import org.serviio.external.io.OutputReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipedOutputBytesReader
extends OutputReader {
    private static final Logger log = LoggerFactory.getLogger(PipedOutputBytesReader.class);
    private PipedOutputStream outputStream = new PipedOutputStream();

    public PipedOutputBytesReader(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected void processOutput() {
        try {
            byte[] buf = new byte[500000];
            int n = 0;
            while ((n = this.inputStream.read(buf)) > 0) {
                try {
                    this.outputStream.write(buf, 0, n);
                }
                catch (IOException e) {
                    log.trace(String.format("Error writing bytes to piped output stream: %s", e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            log.warn(String.format("Error reading bytes stream from external process: %s", e.getMessage()));
        }
    }

    @Override
    public PipedOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

