/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.serviio.external.ProcessExecutor;
import org.serviio.external.io.OutputReader;
import org.serviio.util.CollectionUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTextReader
extends OutputReader {
    private static final Logger log = LoggerFactory.getLogger(OutputTextReader.class);
    private List<String> lines = new ArrayList<String>();
    private Object linesLock = new Object();
    private ProcessExecutor executor;

    public OutputTextReader(ProcessExecutor executor, InputStream inputStream) {
        super(inputStream);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processOutput() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.inputStream, Charset.defaultCharset()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() <= 0) continue;
                this.addLine(line);
                this.executor.notifyListenersOutputUpdated(line);
                log.trace(line);
            }
        }
        catch (IOException e) {
            log.warn(String.format("Error reading output of an external command:" + e.getMessage(), new Object[0]));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public ByteArrayOutputStream getOutputStream() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getResults() {
        ArrayList<String> clonedResults = new ArrayList<String>();
        Object object = this.linesLock;
        synchronized (object) {
            clonedResults.addAll(this.lines);
        }
        return clonedResults;
    }

    public String getLast5Lines() {
        List<String> all = this.getResults();
        if (all == null || all.size() == 0) {
            return null;
        }
        int start = Math.max(0, all.size() - 5);
        return CollectionUtils.listToCSV(all.subList(start, all.size()), StringUtils.LINE_SEPARATOR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLine(String line) {
        Object object = this.linesLock;
        synchronized (object) {
            this.lines.add(line);
        }
    }
}

