/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.serviio.external.io.OutputReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputBytesReader
extends OutputReader {
    private static final Logger log = LoggerFactory.getLogger(OutputBytesReader.class);
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public OutputBytesReader(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected void processOutput() {
        try {
            byte[] buf = new byte[500000];
            int n = 0;
            while ((n = this.inputStream.read(buf)) > 0) {
                this.outputStream.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            log.warn(String.format("Error reading bytes stream from external process: %s", e.getMessage()));
        }
    }

    @Override
    public ByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

