/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.delivery.subtitles.SubtitlesService;
import org.serviio.external.ProcessExecutorParameter;
import org.serviio.external.ProcessListener;
import org.serviio.external.io.OutputBytesReader;
import org.serviio.external.io.OutputReader;
import org.serviio.external.io.OutputTextReader;
import org.serviio.external.io.PipedOutputBytesReader;
import org.serviio.util.CollectionUtils;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.Platform;
import org.serviio.util.ProcessUtils;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecutor
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ProcessExecutor.class);
    private static final int OUTPUT_STREAM_TIMEOUT = 5000;
    private ProcessExecutorParameter[] commandArguments;
    private boolean destroyed = false;
    private boolean checkForExitValue = false;
    private Long failsafeTimeout;
    private Process process;
    private OutputReader stdoutReader;
    private OutputTextReader stderrReader;
    private boolean success = true;
    private boolean unlimitedPipe = false;
    private boolean useStdOutForTextOutput = false;
    private Set<ProcessListener> listeners = new HashSet<ProcessListener>();

    public ProcessExecutor(ProcessExecutorParameter[] commandArguments) {
        this(commandArguments, false);
    }

    public ProcessExecutor(ProcessExecutorParameter[] commandArguments, boolean checkForExitValue) {
        this(commandArguments, checkForExitValue, null);
    }

    public ProcessExecutor(ProcessExecutorParameter[] commandArguments, boolean checkForExitValue, Long failsafeTimeout) {
        this(commandArguments, checkForExitValue, failsafeTimeout, false);
    }

    public ProcessExecutor(ProcessExecutorParameter[] commandArguments, boolean checkForExitValue, Long failsafeTimeout, boolean unlimitedPipe) {
        this(commandArguments, checkForExitValue, failsafeTimeout, unlimitedPipe, false);
    }

    public ProcessExecutor(ProcessExecutorParameter[] commandArguments, boolean checkForExitValue, Long failsafeTimeout, boolean unlimitedPipe, boolean useStdOutForTextOutput) {
        this.commandArguments = commandArguments;
        this.checkForExitValue = checkForExitValue;
        this.failsafeTimeout = failsafeTimeout;
        this.unlimitedPipe = unlimitedPipe;
        this.useStdOutForTextOutput = useStdOutForTextOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block41: {
            Thread faisafeThread;
            block37: {
                block36: {
                    faisafeThread = null;
                    log.debug("Starting " + CollectionUtils.arrayToCSV(this.commandArguments, " "));
                    ProcessBuilder processBuilder = new ProcessBuilder(ProcessExecutorParameter.stringParameters(this.commandArguments));
                    Map<String, String> env = processBuilder.environment();
                    if (Platform.isMac()) {
                        env.putAll(this.createOSXRuntimeEnvironmentVariables());
                    } else if (Platform.isWindows()) {
                        env.putAll(this.createWindowsRuntimeEnvironmentVariables());
                        processBuilder.command(ProcessExecutorParameter.stringParameters(this.commandArguments));
                    }
                    this.process = processBuilder.start();
                    this.stderrReader = new OutputTextReader(this, this.process.getErrorStream());
                    this.stdoutReader = this.useStdOutForTextOutput ? new OutputTextReader(this, this.process.getInputStream()) : (this.unlimitedPipe ? new PipedOutputBytesReader(this.process.getInputStream()) : new OutputBytesReader(this.process.getInputStream()));
                    this.stderrReader.start();
                    this.stdoutReader.start();
                    if (this.failsafeTimeout != null) {
                        faisafeThread = this.makeFailSafe(this.failsafeTimeout);
                    }
                    try {
                        this.process.waitFor();
                        this.stdoutReader.join(5000L);
                        this.stderrReader.join(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.destroyed || !this.checkForExitValue) break block36;
                    try {
                        if (this.process != null && this.process.exitValue() != 0) {
                            StringBuffer errorMessage = new StringBuffer();
                            errorMessage.append(String.format("Process %s has a return code of %s! This is a possible error.", this.commandArguments[0], this.process.exitValue()));
                            String last5Lines = this.stderrReader.getLast5Lines();
                            if (ObjectValidator.isNotEmpty(last5Lines)) {
                                errorMessage.append(" Detailed output follows.").append(StringUtils.LINE_SEPARATOR).append(last5Lines);
                            }
                            log.warn(errorMessage.toString());
                            this.success = false;
                            this.notifyListenersEnd(false);
                        } else if (this.process != null && this.process.exitValue() == 0) {
                            this.notifyListenersEnd(true);
                        }
                        break block37;
                    }
                    catch (IllegalThreadStateException e) {
                        log.error(String.format("Error during finishing process execution: %s", e.getMessage()));
                    }
                    break block37;
                }
                if (!this.destroyed) {
                    this.notifyListenersEnd(true);
                }
            }
            this.destroyed = true;
            if (faisafeThread != null) {
                faisafeThread.interrupt();
            }
            this.closeStreams();
            break block41;
            catch (Exception e) {
                block39: {
                    block38: {
                        try {
                            log.error("Fatal error in process starting: " + e.getMessage(), (Throwable)e);
                            this.success = false;
                            this.stopProcess(false);
                            if (this.destroyed || !this.checkForExitValue) break block38;
                        }
                        catch (Throwable throwable) {
                            if (!this.destroyed && this.checkForExitValue) {
                                try {
                                    if (this.process != null && this.process.exitValue() != 0) {
                                        StringBuffer errorMessage = new StringBuffer();
                                        errorMessage.append(String.format("Process %s has a return code of %s! This is a possible error.", this.commandArguments[0], this.process.exitValue()));
                                        String last5Lines = this.stderrReader.getLast5Lines();
                                        if (ObjectValidator.isNotEmpty(last5Lines)) {
                                            errorMessage.append(" Detailed output follows.").append(StringUtils.LINE_SEPARATOR).append(last5Lines);
                                        }
                                        log.warn(errorMessage.toString());
                                        this.success = false;
                                        this.notifyListenersEnd(false);
                                    } else if (this.process != null && this.process.exitValue() == 0) {
                                        this.notifyListenersEnd(true);
                                    }
                                }
                                catch (IllegalThreadStateException e2) {
                                    log.error(String.format("Error during finishing process execution: %s", e2.getMessage()));
                                }
                            } else if (!this.destroyed) {
                                this.notifyListenersEnd(true);
                            }
                            this.destroyed = true;
                            if (faisafeThread != null) {
                                faisafeThread.interrupt();
                            }
                            this.closeStreams();
                            throw throwable;
                        }
                        try {
                            if (this.process != null && this.process.exitValue() != 0) {
                                StringBuffer errorMessage = new StringBuffer();
                                errorMessage.append(String.format("Process %s has a return code of %s! This is a possible error.", this.commandArguments[0], this.process.exitValue()));
                                String last5Lines = this.stderrReader.getLast5Lines();
                                if (ObjectValidator.isNotEmpty(last5Lines)) {
                                    errorMessage.append(" Detailed output follows.").append(StringUtils.LINE_SEPARATOR).append(last5Lines);
                                }
                                log.warn(errorMessage.toString());
                                this.success = false;
                                this.notifyListenersEnd(false);
                            } else if (this.process != null && this.process.exitValue() == 0) {
                                this.notifyListenersEnd(true);
                            }
                            break block39;
                        }
                        catch (IllegalThreadStateException e3) {
                            log.error(String.format("Error during finishing process execution: %s", e3.getMessage()));
                        }
                        break block39;
                    }
                    if (!this.destroyed) {
                        this.notifyListenersEnd(true);
                    }
                }
                this.destroyed = true;
                if (faisafeThread != null) {
                    faisafeThread.interrupt();
                }
                this.closeStreams();
            }
        }
    }

    public void addListener(ProcessListener listener) {
        this.listeners.add(listener);
        listener.setExecutor(this);
    }

    public void stopProcess(boolean success) {
        if (this.process != null && !this.destroyed) {
            log.debug(String.format("Stopping external process: %s", this));
            ProcessUtils.destroy(this.process);
            this.destroyed = true;
            this.closeStreams();
            this.notifyListenersEnd(success);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.stdoutReader != null) {
            return this.stdoutReader.getOutputStream();
        }
        return null;
    }

    public List<String> getResults() {
        if (this.useStdOutForTextOutput) {
            return this.getResultsFromStream(this.stdoutReader);
        }
        return this.getResultsFromStream(this.stderrReader);
    }

    private List<String> getResultsFromStream(OutputReader reader) {
        if (reader != null) {
            try {
                reader.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return reader.getResults();
        }
        log.warn("Cannot retrieve results, output reader is null");
        return Collections.emptyList();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void notifyListenersOutputUpdated(String updatedLine) {
        for (ProcessListener listener : this.listeners) {
            listener.outputUpdated(updatedLine);
        }
    }

    private Map<String, String> createOSXRuntimeEnvironmentVariables() {
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.putAll(System.getenv());
        newEnv.putAll(this.createFontConfigRuntimeEnvironmentVariables());
        if (log.isTraceEnabled()) {
            log.trace(String.format("Env variables: %s", ((Object)newEnv).toString()));
        }
        return newEnv;
    }

    private Map<String, String> createWindowsRuntimeEnvironmentVariables() {
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.putAll(System.getenv());
        ProcessExecutorParameter[] i18n = new ProcessExecutorParameter[this.commandArguments.length + 2];
        i18n[0] = new ProcessExecutorParameter("cmd");
        i18n[1] = new ProcessExecutorParameter("/C");
        for (int counter = 0; counter < this.commandArguments.length; ++counter) {
            ProcessExecutorParameter argument = this.commandArguments[counter];
            String envName = "JENV_" + counter;
            i18n[counter + 2] = new ProcessExecutorParameter("%" + envName + "%");
            boolean quotesNeeded = this.quotesNeededForWindows(argument);
            if (!quotesNeeded && !argument.isQuoted()) {
                argument = new ProcessExecutorParameter(this.escapeAmpersandForWindows(argument.getValue()));
            }
            newEnv.put(envName, this.wrapInQuotes(argument, quotesNeeded));
        }
        this.commandArguments = i18n;
        String[] tempPath = FileUtils.splitFilePathToDriveAndRest(System.getProperty("java.io.tmpdir"));
        newEnv.put("HOMEDRIVE", tempPath[0]);
        newEnv.put("HOMEPATH", tempPath[1]);
        newEnv.putAll(this.createFontConfigRuntimeEnvironmentVariables());
        if (log.isTraceEnabled()) {
            log.trace(String.format("Env variables: %s", ((Object)newEnv).toString()));
        }
        return newEnv;
    }

    private String wrapInQuotes(ProcessExecutorParameter argument, boolean quotesNeeded) {
        return (quotesNeeded ? "\"" : "") + argument + (quotesNeeded ? "\"" : "");
    }

    protected boolean quotesNeededForWindows(ProcessExecutorParameter argument) {
        boolean quotesNeeded = !argument.isQuoted() && argument.getValue().indexOf(" ") > -1;
        return quotesNeeded;
    }

    private String escapeAmpersandForWindows(String value) {
        return value.replaceAll("&", "^&");
    }

    private Map<String, String> createFontConfigRuntimeEnvironmentVariables() {
        HashMap<String, String> newEnv = new HashMap<String, String>();
        newEnv.put("FONTCONFIG_FILE", "fonts.conf");
        newEnv.put("FONTCONFIG_PATH", SubtitlesService.FONT_CONFIG_DIR);
        return newEnv;
    }

    private Thread makeFailSafe(final Long timeout) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ProcessExecutor.this.stopProcess(false);
            }
        };
        Thread failsafe = new Thread(r);
        failsafe.start();
        return failsafe;
    }

    private void notifyListenersEnd(Boolean success) {
        for (ProcessListener listener : this.listeners) {
            listener.processEnded(success);
        }
    }

    private void closeStreams() {
        if (this.stderrReader != null) {
            this.stderrReader.closeStream();
        }
        if (this.stdoutReader != null) {
            this.stdoutReader.closeStream();
        }
        if (this.process != null) {
            FileUtils.closeQuietly(this.process.getOutputStream());
        }
    }
}

