/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.serviio.external.AbstractCLBuilder;
import org.serviio.external.ProcessExecutorParameter;

public class FFmpegCLBuilder
extends AbstractCLBuilder {
    static String executablePath = FFmpegCLBuilder.setupExecutablePath("ffmpeg.location", "ffmpeg_executable");
    private final List<ProcessExecutorParameter> globalOptions = new ArrayList<ProcessExecutorParameter>();
    private final List<ProcessExecutorParameter> inFileOptions = new ArrayList<ProcessExecutorParameter>();
    private ProcessExecutorParameter inFile;
    private final List<ProcessExecutorParameter> outFileOptions = new ArrayList<ProcessExecutorParameter>();
    private ProcessExecutorParameter outFile;

    @Override
    public ProcessExecutorParameter[] build() {
        ArrayList<ProcessExecutorParameter> args = new ArrayList<ProcessExecutorParameter>();
        args.add(new ProcessExecutorParameter(executablePath));
        args.addAll(this.globalOptions);
        if (this.inFile != null) {
            args.addAll(this.inFileOptions);
            args.add(new ProcessExecutorParameter("-i"));
            args.add(this.inFile);
        }
        if (this.outFile != null) {
            args.addAll(this.outFileOptions);
            args.add(this.outFile);
        }
        ProcessExecutorParameter[] ffmpegArgs = new ProcessExecutorParameter[args.size()];
        return args.toArray(ffmpegArgs);
    }

    public FFmpegCLBuilder globalOptions(String ... options) {
        Collections.addAll(this.globalOptions, ProcessExecutorParameter.parameters(options));
        return this;
    }

    public FFmpegCLBuilder inFileOptions(String ... options) {
        Collections.addAll(this.inFileOptions, ProcessExecutorParameter.parameters(options));
        return this;
    }

    public FFmpegCLBuilder outFileOptions(String ... options) {
        Collections.addAll(this.outFileOptions, ProcessExecutorParameter.parameters(options));
        return this;
    }

    public FFmpegCLBuilder outFileOption(String option, boolean isQuoted) {
        Collections.addAll(this.outFileOptions, new ProcessExecutorParameter(option, isQuoted));
        return this;
    }

    public FFmpegCLBuilder inFile(String inFile) {
        this.inFile = new ProcessExecutorParameter(inFile);
        return this;
    }

    public FFmpegCLBuilder outFile(String outFile) {
        this.outFile = new ProcessExecutorParameter(outFile);
        return this;
    }

    List<String> getOutFileOptions() {
        return Collections.unmodifiableList(ProcessExecutorParameter.stringParameters(this.outFileOptions));
    }

    List<String> getInFileOptions() {
        return Collections.unmodifiableList(ProcessExecutorParameter.stringParameters(this.inFileOptions));
    }
}

