/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.ApplicationSettings;
import org.serviio.config.Configuration;
import org.serviio.delivery.DeliveryContext;
import org.serviio.delivery.resource.transcode.AudioTranscodingDefinition;
import org.serviio.delivery.resource.transcode.TranscodingDefinition;
import org.serviio.delivery.resource.transcode.TranscodingJobListener;
import org.serviio.delivery.resource.transcode.VideoTranscodingDefinition;
import org.serviio.delivery.subtitles.HardSubs;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.AudioContainer;
import org.serviio.dlna.DisplayAspectRatio;
import org.serviio.dlna.SourceAspectRatio;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.external.AbstractExecutableWrapper;
import org.serviio.external.FFmpegCLBuilder;
import org.serviio.external.ProcessExecutor;
import org.serviio.external.ProcessExecutorParameter;
import org.serviio.external.ResizeDefinition;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Video;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.library.local.service.MediaService;
import org.serviio.util.CollectionUtils;
import org.serviio.util.FileUtils;
import org.serviio.util.MediaUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.Platform;
import org.serviio.util.ThreadUtils;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMPEGWrapper
extends AbstractExecutableWrapper {
    public static final String THREADS_AUTO = "auto";
    public static final String SEGMENT_PLAYLIST_FILE_NAME = ApplicationSettings.getStringProperty("hls_playlist_file_name");
    private static final Integer thumbnailSeekPosition = ApplicationSettings.getIntegerProperty("video_thumbnail_seek_position");
    private static final Integer defaultAudioBitrate = ApplicationSettings.getIntegerProperty("transcoding_default_audio_bitrate");
    private static final String videoQualityFactor = ApplicationSettings.getStringProperty("transcoding_quality_factor");
    private static final String x264VideoQualityFactor = ApplicationSettings.getStringProperty("x264_transcoding_quality_factor");
    private static final String segmentSizeInSeconds = ApplicationSettings.getStringProperty("hls_segment_size");
    private static final String segmentNumberForLiveStreams = ApplicationSettings.getStringProperty("hls_live_segment_number");
    private static final Logger log = LoggerFactory.getLogger(FFMPEGWrapper.class);
    private static final int DEFAULT_AUDIO_FREQUENCY = 48000;
    private static final int MIN_AUDIO_FREQUENCY = 44100;
    private static final int RTMP_BUFFER_SIZE = 100000000;
    private static final long LOCAL_FILE_TIMEOUT = new Long(30000L);
    private static final long DEFAULT_ONLINE_FILE_TIMEOUT = new Long(60000L);
    private static final List<Integer> validAudioBitrates = Arrays.asList(32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 448, 512, 576, 640);
    private static String ffmpegUserAgent;
    private static Map<AudioCodec, Integer> maxChannelNumber;
    private static Map<String, String> stringEncoding;
    private static Map<String, String> windowsStringEncoding;

    public static boolean ffmpegPresent() {
        boolean success;
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        log.debug(String.format("Invoking FFMPEG to check if it exists of path %s", FFmpegCLBuilder.executablePath));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false);
        FFMPEGWrapper.executeSynchronously(executor);
        boolean bl = success = executor.isSuccess() && executor.getResults().size() > 5;
        if (success) {
            log.info(String.format("Found FFmpeg: %s", executor.getResults().get(0)));
            String ffmpegOutput = CollectionUtils.listToCSV(executor.getResults(), "", false);
            if (ffmpegOutput.indexOf("--enable-librtmp") == -1) {
                log.warn("FFmpeg is not compiled with librtmp support, RTMP streaming will not work.");
            }
            if (ffmpegOutput.indexOf("--enable-libass") == -1) {
                log.warn("FFmpeg is not compiled with libass support, rendering subtitles (hardsubs) will not work.");
                Configuration.setHardSubsEnabled(false);
            }
            ffmpegUserAgent = FFMPEGWrapper.getUserAgent(ffmpegOutput);
        }
        return success;
    }

    public static List<String> readMediaFileInformation(String filePath, DeliveryContext context) throws IOException {
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        FFMPEGWrapper.addInputFileOptions(filePath, context, builder);
        builder.inFile(FFMPEGWrapper.fixFilePath(filePath, context.isLocalContent()));
        log.debug(String.format("Invoking FFMPEG to retrieve media information for file: %s", filePath));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, context.isLocalContent() ? LOCAL_FILE_TIMEOUT : FFMPEGWrapper.onlineItemTimeout());
        FFMPEGWrapper.executeSynchronously(executor);
        return executor.getResults();
    }

    public static byte[] readVideoThumbnail(File f, Integer videoLength, VideoCodec vCodec, VideoContainer vContainer) throws IOException {
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        builder.inFile(String.format("%s", f.getAbsolutePath()));
        builder.inFileOptions("-threads", Configuration.getTranscodingThreads());
        FFMPEGWrapper.addTimePosition(videoLength, vCodec != VideoCodec.MPEG2 && vContainer != VideoContainer.MPEG2TS, builder);
        builder.outFileOptions("-an", "-frames:v", "1", "-f", "image2").outFile("pipe:");
        log.debug(String.format("Invoking FFMPEG to retrieve thumbnail for file: %s", f.getAbsolutePath()));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, new Long(160000L));
        FFMPEGWrapper.executeSynchronously(executor);
        ByteArrayOutputStream out = (ByteArrayOutputStream)executor.getOutputStream();
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    public static byte[] transcodeSubtitleFileToSRT(File f) throws IOException {
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        builder.inFileOptions("-sub_charenc", Configuration.getSubsCharacterEncoding());
        builder.inFile(String.format("%s", f.getAbsolutePath()));
        builder.outFileOptions("-an", "-vn", "-c:s", SubtitleCodec.SRT.getFFmpegEncoderName(), "-f", SubtitleCodec.SRT.getFFmpegEncoderName()).outFile("pipe:");
        log.debug(String.format("Invoking FFMPEG to convert subtitle file: %s", f.getAbsolutePath()));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, new Long(30000L));
        FFMPEGWrapper.executeSynchronously(executor);
        ByteArrayOutputStream out = (ByteArrayOutputStream)executor.getOutputStream();
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    public static File extractSubtitleFile(Video video, EmbeddedSubtitles subtitle, String targetFilePath) throws IOException {
        String subtitleFormat = subtitle.getCodec().getFFmpegEncoderName();
        String subtitleEncoder = "copy";
        String subtitleExtension = "";
        if (subtitleFormat == null) {
            subtitleEncoder = SubtitleCodec.ASS.getFFmpegEncoderName();
            subtitleFormat = SubtitleCodec.ASS.getFFmpegEncoderName();
            subtitleExtension = SubtitleCodec.ASS.getFileExtensions().get(0);
        } else {
            subtitleExtension = subtitle.getCodec().getFileExtensions().get(0);
        }
        FFmpegCLBuilder builder = FFMPEGWrapper.prepareCommandForSubtitleExtraction(video, subtitle, subtitleEncoder, subtitleFormat);
        File targetFile = new File(targetFilePath + "." + subtitleExtension);
        builder.outFile(FFMPEGWrapper.getOutputFile(targetFile));
        log.debug(String.format("Invoking FFMPEG to extract subtitle file from: %s", video.getFileName()));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, new Long(30000L));
        FFMPEGWrapper.executeSynchronously(executor);
        if (targetFile.exists() && targetFile.length() > 0L) {
            return targetFile;
        }
        throw new IOException(String.format("Could not extract subtitle from file %s", video.getFileName()));
    }

    public static byte[] extractSubtitleFileAsSRT(Video video, EmbeddedSubtitles subtitle) throws IOException {
        FFmpegCLBuilder builder = FFMPEGWrapper.prepareCommandForSubtitleExtraction(video, subtitle, SubtitleCodec.SRT.getFFmpegEncoderName(), SubtitleCodec.SRT.getFFmpegEncoderName());
        builder.outFile(FFMPEGWrapper.getOutputFile(null));
        log.debug(String.format("Invoking FFMPEG to extract SRT subtitle file from: %s", video.getFileName()));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, new Long(30000L));
        FFMPEGWrapper.executeSynchronously(executor);
        ByteArrayOutputStream out = (ByteArrayOutputStream)executor.getOutputStream();
        if (out != null) {
            return out.toByteArray();
        }
        throw new IOException(String.format("Could not extract SRT subtitle from file %s", video.getFileName()));
    }

    public static byte[] readH264AnnexBHeader(String filePath, VideoContainer container, DeliveryContext context) throws IOException {
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        FFMPEGWrapper.addInputFileOptions(filePath, context, builder);
        builder.inFile(String.format("%s", FFMPEGWrapper.fixFilePath(filePath, context.isLocalContent())));
        builder.outFileOptions("-frames:v", "1", "-c:v", "copy", "-f", "h264");
        if (!FFMPEGWrapper.isMpegTSbasedContainer(container)) {
            builder.outFileOptions("-bsf:v", "h264_mp4toannexb");
        }
        builder.outFileOptions("-an");
        builder.outFile("pipe:");
        log.debug(String.format("Invoking FFMPEG to retrieve H264 header for file: %s", filePath));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, context.isLocalContent() ? LOCAL_FILE_TIMEOUT : FFMPEGWrapper.onlineItemTimeout());
        FFMPEGWrapper.executeSynchronously(executor);
        ByteArrayOutputStream out = (ByteArrayOutputStream)executor.getOutputStream();
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    public static OutputStream transcodeFile(MediaItem mediaItem, File tmpFile, TranscodingDefinition tDef, TranscodingJobListener listener, Double timeOffset, Double timeDuration) throws IOException {
        if (mediaItem instanceof Video) {
            return FFMPEGWrapper.transcodeVideoFile((Video)mediaItem, tmpFile, (VideoTranscodingDefinition)tDef, listener, timeOffset, timeDuration);
        }
        if (mediaItem instanceof MusicTrack) {
            return FFMPEGWrapper.transcodeAudioFile((MusicTrack)mediaItem, tmpFile, (AudioTranscodingDefinition)tDef, listener, timeOffset, timeDuration);
        }
        return null;
    }

    public static String getFFmpegUserAgent() {
        return ffmpegUserAgent;
    }

    protected static String prepareOnlineContentUrl(String url) {
        if (url.startsWith("mms://")) {
            return url.replaceFirst("mms://", "mmsh://");
        }
        return url;
    }

    private static FFmpegCLBuilder prepareCommandForSubtitleExtraction(Video video, EmbeddedSubtitles subtitle, String subtitleEncoder, String subtitleFormat) {
        String sourceFileName = FFMPEGWrapper.getFilePathForTranscoding(video);
        FFmpegCLBuilder builder = FFMPEGWrapper.buildBasicTranscodingParameters(sourceFileName, video.getDeliveryContext());
        builder.outFileOptions("-an", "-vn", "-map", "0:" + subtitle.getStreamId(), "-c:s", subtitleEncoder, "-f", subtitleFormat);
        return builder;
    }

    private static void addTimePosition(Integer videoLength, boolean inputOption, FFmpegCLBuilder builder) {
        Integer thumbnailPosition = null;
        thumbnailPosition = videoLength != null && videoLength < thumbnailSeekPosition ? Integer.valueOf(videoLength / 2) : thumbnailSeekPosition;
        if (inputOption) {
            builder.inFileOptions("-ss", Integer.toString(thumbnailPosition));
        } else {
            builder.inFileOptions("-ss", Integer.toString(thumbnailPosition - 1));
            builder.outFileOptions("-ss", "1");
        }
    }

    private static OutputStream transcodeVideoFile(Video mediaItem, File tmpFile, VideoTranscodingDefinition tDef, TranscodingJobListener listener, Double timeOffset, Double timeDuration) throws IOException {
        String sourceFileName = FFMPEGWrapper.getFilePathForTranscoding(mediaItem);
        FFmpegCLBuilder builder = FFMPEGWrapper.buildBasicTranscodingParameters(sourceFileName, mediaItem.getDeliveryContext());
        FFMPEGWrapper.addTranscodingThreads(builder);
        FFMPEGWrapper.addTimeConstraintParameters(timeOffset, timeDuration, mediaItem.getDuration(), builder);
        FFMPEGWrapper.addVideoParameters(mediaItem, tDef, mediaItem.getDeliveryContext().getHardsubsSubtitlesFile(), builder);
        FFMPEGWrapper.addAudioParameters(mediaItem, tDef, builder);
        FFMPEGWrapper.mapStreams(mediaItem, builder);
        builder.outFileOptions("-sn");
        FFMPEGWrapper.addTargetVideoFormatAndOutputFile(builder, tDef, tmpFile, mediaItem.isLive());
        log.debug(String.format("Invoking FFmpeg to transcode video file: %s", sourceFileName));
        return FFMPEGWrapper.executeTranscodingProcess(tmpFile, listener, builder.build());
    }

    private static void addTranscodingThreads(FFmpegCLBuilder builder) {
        builder.inFileOptions("-threads", Configuration.getTranscodingThreads());
        builder.outFileOptions("-threads", Configuration.getTranscodingThreads());
    }

    private static File addTargetVideoFormatAndOutputFile(FFmpegCLBuilder builder, VideoTranscodingDefinition tDef, File tmpFile, boolean live) {
        builder.outFileOptions("-f", tDef.getTargetContainer().getFFmpegValue());
        if (tDef.getTargetContainer().isSegmentBased()) {
            String segmentsFileName = FileUtils.getProperFilePath(tmpFile);
            String segmentFileTemplate = FileUtils.getProperFilePath(new File(tmpFile.getParentFile(), "segment%05d.ts"));
            builder.outFileOptions("-segment_time", segmentSizeInSeconds, "-segment_format", VideoContainer.MPEG2TS.getFFmpegValue(), "-segment_list_flags", live ? "live" : "cache", "-segment_list", segmentsFileName);
            if (live) {
                builder.outFileOptions("-segment_list_size", segmentNumberForLiveStreams);
            }
            builder.outFile(segmentFileTemplate);
            return tmpFile;
        }
        builder.outFile(FFMPEGWrapper.getOutputFile(tmpFile));
        return tmpFile;
    }

    private static OutputStream transcodeAudioFile(MusicTrack mediaItem, File tmpFile, AudioTranscodingDefinition tDef, TranscodingJobListener listener, Double timeOffset, Double timeDuration) throws IOException {
        Integer frequency;
        String sourceFileName = FFMPEGWrapper.getFilePathForTranscoding(mediaItem);
        FFmpegCLBuilder builder = FFMPEGWrapper.buildBasicTranscodingParameters(sourceFileName, mediaItem.getDeliveryContext());
        FFMPEGWrapper.addTranscodingThreads(builder);
        FFMPEGWrapper.addTimeConstraintParameters(timeOffset, timeDuration, mediaItem.getDuration(), builder);
        if (tDef.getTargetContainer() != AudioContainer.LPCM) {
            Integer itemBitrate = mediaItem.getBitrate() != null ? mediaItem.getBitrate() : null;
            Integer audioBitrate = FFMPEGWrapper.getAudioBitrate(itemBitrate, tDef);
            builder.outFileOptions("-b:a", String.format("%sk", audioBitrate));
        }
        if (tDef.getTargetContainer() == AudioContainer.MP3) {
            builder.outFileOptions("-id3v2_version", "3");
        }
        if ((frequency = FFMPEGWrapper.getAudioFrequency(tDef, mediaItem)) != null) {
            builder.outFileOptions("-ar", frequency.toString());
        }
        FFMPEGWrapper.addAudioChannelsNumber(mediaItem.getChannels(), null, true, false, builder);
        builder.outFileOptions("-f", tDef.getTargetContainer().getFFmpegContainerEncoderName()).outFile(FFMPEGWrapper.getOutputFile(tmpFile));
        log.debug(String.format("Invoking FFmpeg to transcode audio file: %s", sourceFileName));
        return FFMPEGWrapper.executeTranscodingProcess(tmpFile, listener, builder.build());
    }

    private static OutputStream executeTranscodingProcess(File tmpFile, TranscodingJobListener listener, ProcessExecutorParameter[] ffmpegArgs) throws IOException {
        ProcessExecutor executor = new ProcessExecutor(ffmpegArgs, true, null, tmpFile == null);
        executor.addListener(listener);
        executor.start();
        if (tmpFile == null) {
            int retries = 0;
            while (executor.getOutputStream() == null && retries++ < 5) {
                ThreadUtils.currentThreadSleep(500L);
            }
        }
        return executor.getOutputStream();
    }

    private static String getOutputFile(File outputFile) {
        if (outputFile == null) {
            return "pipe:";
        }
        return FileUtils.getProperFilePath(outputFile);
    }

    private static FFmpegCLBuilder buildBasicTranscodingParameters(String sourceFilePath, DeliveryContext context) {
        FFmpegCLBuilder builder = new FFmpegCLBuilder();
        FFMPEGWrapper.addInputFileOptions(sourceFilePath, context, builder);
        builder.inFile(String.format("%s", sourceFilePath)).outFileOptions("-y");
        return builder;
    }

    private static void addInputFileOptions(String fileName, DeliveryContext context, FFmpegCLBuilder builder) {
        if (!context.isLocalContent() && ObjectValidator.isNotEmpty(context.getUserAgent()) && (fileName.startsWith("http://") || fileName.startsWith("https://"))) {
            builder.inFileOptions("-user-agent", context.getUserAgent());
        }
        if (!context.isLocalContent() && fileName.startsWith("rtsp://")) {
            builder.globalOptions("-rtsp_transport", "+tcp+udp");
        }
        if (!context.isLocalContent()) {
            builder.globalOptions("-analyzeduration", "10000000");
        }
    }

    private static void mapStreams(Video mediaItem, FFmpegCLBuilder builder) {
        if (mediaItem.getVideoStreamIndex() != null) {
            builder.outFileOptions("-map", String.format("0:%s", mediaItem.getVideoStreamIndex()));
        }
        if (mediaItem.getAudioCodec() != null && mediaItem.getAudioStreamIndex() != null) {
            builder.outFileOptions("-map", String.format("0:%s", mediaItem.getAudioStreamIndex()));
        }
    }

    protected static void addTimeConstraintParameters(Double timeOffset, Double timeDuration, Integer totalTime, FFmpegCLBuilder builder) {
        int seekSplitPosition = 10;
        double start = 0.0;
        if (timeOffset != null && timeOffset > 0.0 && (totalTime != null && timeOffset < (double)totalTime.intValue() || totalTime == null)) {
            if (timeOffset > (double)seekSplitPosition) {
                builder.inFileOptions("-ss", Double.toString(timeOffset - (double)seekSplitPosition));
                builder.outFileOptions("-ss", Double.toString(seekSplitPosition));
            } else {
                builder.outFileOptions("-ss", Double.toString(timeOffset));
            }
            start += timeOffset.doubleValue();
        }
        if (timeDuration != null) {
            builder.outFileOptions("-t", Double.toString(start + timeDuration));
        }
    }

    private static void addVideoParameters(Video mediaItem, VideoTranscodingDefinition tDef, HardSubs hardSubs, FFmpegCLBuilder builder) {
        boolean vCodecCopy = false;
        VideoCodec targetCodec = FFMPEGWrapper.getTargetVideoCodec(mediaItem, tDef);
        builder.outFileOptions("-c:v");
        if (!FFMPEGWrapper.isVideoStreamChanged(mediaItem, tDef, hardSubs)) {
            builder.outFileOptions("copy");
            vCodecCopy = true;
            builder.globalOptions("-fflags", "+genpts");
        } else {
            builder.outFileOptions(targetCodec.getFFmpegEncoderName());
            if (targetCodec == VideoCodec.H264) {
                builder.outFileOptions("-profile:v", "baseline", "-level", "3", "-preset", "veryfast");
                FFMPEGWrapper.addVideoBitrateConstraints(tDef, builder);
                if (Configuration.isTranscodingBestQuality()) {
                    builder.outFileOptions("-crf", "10");
                } else {
                    builder.outFileOptions("-crf", x264VideoQualityFactor);
                }
            } else {
                if (targetCodec == VideoCodec.MPEG2) {
                    builder.outFileOptions("-pix_fmt", "yuv420p");
                }
                if (!FFMPEGWrapper.addVideoBitrateConstraints(tDef, builder)) {
                    if (Configuration.isTranscodingBestQuality()) {
                        builder.outFileOptions("-qscale:v", "1");
                    } else {
                        builder.outFileOptions("-qscale:v", videoQualityFactor);
                    }
                }
            }
            FFMPEGWrapper.addVideoFilters(mediaItem, tDef.getMaxHeight(), tDef.getDar(), tDef.getTargetContainer(), hardSubs, builder);
            FFMPEGWrapper.addFrameRate(mediaItem, builder);
            builder.outFileOptions("-g", "15");
        }
        if (vCodecCopy && mediaItem.getVideoCodec() == VideoCodec.H264 && !FFMPEGWrapper.isMpegTSbasedContainer(mediaItem.getContainer()) && FFMPEGWrapper.isMpegTSbasedContainer(tDef.getTargetContainer())) {
            builder.outFileOptions("-bsf:v", "h264_mp4toannexb");
        } else if (!vCodecCopy && targetCodec == VideoCodec.H264 && FFMPEGWrapper.isMpegTSbasedContainer(tDef.getTargetContainer())) {
            builder.outFileOptions("-bsf:v", "h264_mp4toannexb", "-flags", "-global_header");
        }
        if (tDef.getTargetContainer() == VideoContainer.M2TS) {
            builder.outFileOptions("-mpegts_m2ts_mode", "1");
        }
    }

    public static VideoCodec getTargetVideoCodec(Video mediaItem, VideoTranscodingDefinition tDef) {
        return tDef.getTargetVideoCodec() != null ? tDef.getTargetVideoCodec() : mediaItem.getVideoCodec();
    }

    private static boolean isMpegTSbasedContainer(VideoContainer container) {
        return container == VideoContainer.MPEG2TS || container == VideoContainer.WTV || container == VideoContainer.APPLE_HTTP || container == VideoContainer.M2TS;
    }

    private static boolean addVideoBitrateConstraints(VideoTranscodingDefinition tDef, FFmpegCLBuilder builder) {
        if (tDef.getMaxVideoBitrate() != null) {
            builder.outFileOptions("-b:v", tDef.getMaxVideoBitrate().toString() + "k", "-maxrate:v", tDef.getMaxVideoBitrate().toString() + "k", "-bufsize:v", tDef.getMaxVideoBitrate().toString() + "k");
            return true;
        }
        return false;
    }

    private static boolean isVideoStreamChanged(Video mediaItem, VideoTranscodingDefinition tDef, HardSubs hardSubs) {
        boolean codecCopy = !tDef.isForceVTranscoding() && (tDef.getTargetVideoCodec() == null || tDef.getTargetVideoCodec().equals((Object)mediaItem.getVideoCodec()));
        return !codecCopy || hardSubs != null || tDef.getMaxVideoBitrate() != null || FFMPEGWrapper.isVideoResolutionChangeRequired(mediaItem.getWidth(), mediaItem.getHeight(), tDef.getMaxHeight(), tDef.getDar(), tDef.getTargetContainer(), mediaItem.getSar());
    }

    private static void addFrameRate(Video mediaItem, FFmpegCLBuilder builder) {
        String fr = mediaItem.getFps();
        if (fr != null) {
            fr = FFMPEGWrapper.findNearestValidFFmpegFrameRate(fr);
            builder.outFileOptions("-r", fr.toString());
        }
    }

    protected static void addVideoFilters(Video video, Integer maxHeight, DisplayAspectRatio targetDar, VideoContainer targetContainer, HardSubs hardSubs, FFmpegCLBuilder builder) {
        ArrayList<String> filters = new ArrayList<String>();
        boolean parameterQuoted = false;
        ResizeDefinition resizeDefinition = FFMPEGWrapper.getTargetVideoDimensions(video, maxHeight, targetDar, targetContainer);
        if (resizeDefinition.changed()) {
            if (resizeDefinition.physicalDimensionsChanged()) {
                filters.add(String.format("scale=%s:%s", resizeDefinition.contentWidth, resizeDefinition.contentHeight));
            }
            if (resizeDefinition.darChanged) {
                Integer posX = Math.abs(resizeDefinition.width - resizeDefinition.contentWidth) / 2;
                Integer posY = Math.abs(resizeDefinition.height - resizeDefinition.contentHeight) / 2;
                filters.add(String.format("pad=%s:%s:%s:%s:black", resizeDefinition.width, resizeDefinition.height, posX, posY));
                filters.add("setdar=4:3");
            }
            if (resizeDefinition.sarChangedToSquarePixels) {
                filters.add("setsar=1");
            } else if (!video.getSar().isSquarePixels()) {
                filters.add("setsar=" + video.getSar().toString());
            }
        }
        if (hardSubs != null) {
            filters.add(String.format("subtitles=filename=%s:original_size=%sx%s:charenc=%s", FFMPEGWrapper.encodeFilePathForFilter(hardSubs, Platform.isWindows()), video.getWidth(), video.getHeight(), Configuration.getSubsCharacterEncoding()));
            parameterQuoted = true;
        }
        if (filters.size() > 0) {
            builder.outFileOptions("-vf");
            builder.outFileOption(CollectionUtils.listToCSV(filters, ",", true), parameterQuoted);
        }
    }

    protected static String encodeFilePathForFilter(HardSubs hardSubs, boolean windows) {
        String template = windows ? "\"%s\"" : "'%s'";
        String fileName = hardSubs.getSubtitlesFile();
        for (Map.Entry<String, String> encodingRule : windows ? windowsStringEncoding.entrySet() : stringEncoding.entrySet()) {
            fileName = fileName.replaceAll(encodingRule.getKey(), encodingRule.getValue());
        }
        return String.format(template, fileName);
    }

    private static void addAudioParameters(Video mediaItem, VideoTranscodingDefinition tDef, FFmpegCLBuilder builder) {
        if (mediaItem.getAudioCodec() == null) {
            builder.outFileOptions("-an");
            return;
        }
        builder.outFileOptions("-c:a");
        if (tDef.getTargetAudioCodec() == null || tDef.getTargetAudioCodec().equals((Object)mediaItem.getAudioCodec()) && (tDef.getAudioSamplerate() == null || tDef.getAudioSamplerate().equals(mediaItem.getFrequency()))) {
            builder.outFileOptions("copy");
        } else {
            Integer frequency;
            builder.outFileOptions(tDef.getTargetAudioCodec().getFFmpegEncoderName());
            if (tDef.getTargetAudioCodec() == AudioCodec.AAC) {
                builder.outFileOptions("-strict", "experimental");
            }
            if (tDef.getTargetAudioCodec() != AudioCodec.LPCM) {
                Integer itemBitrate = mediaItem.getAudioBitrate() != null ? mediaItem.getAudioBitrate() : null;
                Integer audioBitrate = FFMPEGWrapper.getAudioBitrate(itemBitrate, tDef);
                builder.outFileOptions("-b:a", String.format("%sk", audioBitrate));
            }
            if ((frequency = FFMPEGWrapper.getAudioFrequency(tDef, mediaItem)) != null) {
                builder.outFileOptions("-ar", frequency.toString());
            }
            boolean downmixingSupported = mediaItem.getAudioCodec() != AudioCodec.FLAC;
            FFMPEGWrapper.addAudioChannelsNumber(mediaItem.getChannels(), tDef.getTargetAudioCodec(), downmixingSupported, tDef.isForceStereo(), builder);
        }
    }

    public static Integer getAudioBitrate(Integer itemBitrate, TranscodingDefinition tDef) {
        if (itemBitrate != null && !validAudioBitrates.contains(itemBitrate)) {
            itemBitrate = FFMPEGWrapper.findNearestValidBitrate(itemBitrate);
        }
        Integer minimalAudioBitrate = itemBitrate != null && itemBitrate < defaultAudioBitrate ? itemBitrate : defaultAudioBitrate;
        Integer audioBitrate = tDef.getAudioBitrate() != null ? tDef.getAudioBitrate() : minimalAudioBitrate;
        return audioBitrate;
    }

    private static Integer findNearestValidBitrate(Integer itemBitrate) {
        int nearest = -1;
        int bestDistanceFoundYet = Integer.MAX_VALUE;
        for (int validRate : validAudioBitrates) {
            int d = Math.abs(itemBitrate - validRate);
            if (d >= bestDistanceFoundYet) continue;
            nearest = validRate;
            bestDistanceFoundYet = d;
        }
        return nearest;
    }

    private static Integer getAudioFrequency(VideoTranscodingDefinition tDef, Video mediaItem) {
        return FFMPEGWrapper.getAudioFrequency(tDef, mediaItem.getFrequency(), tDef.getTargetAudioCodec() == AudioCodec.LPCM || mediaItem.getAudioCodec() == AudioCodec.LPCM);
    }

    private static Integer getAudioFrequency(AudioTranscodingDefinition tDef, MusicTrack mediaItem) {
        return FFMPEGWrapper.getAudioFrequency(tDef, mediaItem.getSampleFrequency(), tDef.getTargetContainer() == AudioContainer.LPCM || mediaItem.getContainer() == AudioContainer.LPCM);
    }

    public static Integer getAudioFrequency(TranscodingDefinition tDef, Integer itemFrequency, boolean isLPCM) {
        Integer frequency = 48000;
        boolean frequencyRequired = false;
        if (itemFrequency != null) {
            if (itemFrequency >= 44100) {
                frequency = itemFrequency;
            } else {
                frequencyRequired = true;
            }
        } else {
            frequencyRequired = true;
        }
        if (tDef.getAudioSamplerate() == null) {
            if (isLPCM || frequencyRequired) {
                return frequency;
            }
            return null;
        }
        return tDef.getAudioSamplerate();
    }

    private static void addAudioChannelsNumber(Integer channelNumber, AudioCodec targetCodec, boolean downmixingSupported, boolean alwaysForceStereo, FFmpegCLBuilder builder) {
        Integer channels = FFMPEGWrapper.getAudioChannelNumber(channelNumber, targetCodec, downmixingSupported, alwaysForceStereo);
        if (channels != null) {
            builder.outFileOptions("-ac", channels.toString());
        }
    }

    private static Integer getMaxNumberOfChannels(AudioCodec codec) {
        if (codec != null) {
            return maxChannelNumber.get((Object)codec);
        }
        return null;
    }

    public static Integer getAudioChannelNumber(Integer channelNumber, AudioCodec targetCodec, boolean downmixingSupported, boolean alwaysForceStereo) {
        if (channelNumber == null) {
            if (Configuration.isTranscodingDownmixToStereo() || alwaysForceStereo) {
                return 2;
            }
        } else {
            Integer maxChannels = FFMPEGWrapper.getMaxNumberOfChannels(targetCodec);
            if (channelNumber > 2 && (Configuration.isTranscodingDownmixToStereo() || alwaysForceStereo) && downmixingSupported) {
                return 2;
            }
            if (maxChannels != null && maxChannels < channelNumber) {
                return maxChannels;
            }
            return channelNumber;
        }
        return null;
    }

    public static ResizeDefinition getTargetVideoDimensions(Video video, Integer maxHeight, DisplayAspectRatio targetDar, VideoContainer targetContainer) {
        SourceAspectRatio sarMultiplier;
        if (!(FFMPEGWrapper.isVideoHeightChanged(video.getHeight(), maxHeight) || FFMPEGWrapper.isVideoDARChanged(video.getWidth(), video.getHeight(), targetDar, video.getSar()) || FFMPEGWrapper.isSARFixNeeded(targetContainer, video.getSar().isSquarePixels()))) {
            return new ResizeDefinition(video.getWidth(), video.getHeight());
        }
        Integer newWidth = video.getWidth();
        Integer newHeight = video.getHeight();
        Integer newContentWidth = video.getWidth();
        Integer newContentHeight = video.getHeight();
        boolean sarChanged = false;
        boolean darChanged = false;
        boolean heightChanged = false;
        if (FFMPEGWrapper.isSARFixNeeded(targetContainer, video.getSar().isSquarePixels())) {
            Tupple<Integer, Integer> dimensions = FFMPEGWrapper.getResolutionForSquarePixels(video.getWidth(), video.getHeight(), video.getSar());
            newWidth = dimensions.getValueA();
            newHeight = dimensions.getValueB();
            newContentWidth = newWidth;
            newContentHeight = newHeight;
            sarChanged = true;
        }
        SourceAspectRatio sourceAspectRatio = sarMultiplier = sarChanged ? SourceAspectRatio.square() : video.getSar();
        if (FFMPEGWrapper.isVideoDARChanged(newWidth, newHeight, targetDar, sarMultiplier)) {
            float originalDar = (float)newWidth.intValue() / (float)newHeight.intValue() * sarMultiplier.getSar().floatValue();
            if (originalDar >= targetDar.getRatio()) {
                newHeight = Math.round((float)newWidth.intValue() * sarMultiplier.getSar().floatValue() / targetDar.getRatio());
            } else {
                newWidth = Math.round((float)newHeight.intValue() * targetDar.getRatio() / sarMultiplier.getSar().floatValue());
            }
            darChanged = true;
        }
        if (FFMPEGWrapper.isVideoHeightChanged(newHeight, maxHeight)) {
            int origNewWidth = newWidth;
            int origNewHeight = newHeight;
            newWidth = Math.round((float)newWidth.intValue() * ((float)maxHeight.intValue() / (float)newHeight.intValue()));
            newHeight = maxHeight;
            newContentWidth = Math.round((float)newContentWidth.intValue() * ((float)newWidth.intValue() / (float)origNewWidth));
            newContentHeight = Math.round((float)newContentHeight.intValue() * ((float)newHeight.intValue() / (float)origNewHeight));
            heightChanged = true;
        }
        return new ResizeDefinition(newWidth, newHeight, newContentWidth, newContentHeight, darChanged, sarChanged, heightChanged);
    }

    private static Tupple<Integer, Integer> getResolutionForSquarePixels(Integer width, Integer height, SourceAspectRatio sar) {
        return new Tupple<Integer, Integer>(Math.round((float)width.intValue() * sar.getSar().floatValue()), height);
    }

    protected static boolean isVideoResolutionChangeRequired(Integer width, Integer height, Integer maxHeight, DisplayAspectRatio dar, VideoContainer targetContainer, SourceAspectRatio sar) {
        return FFMPEGWrapper.isVideoHeightChanged(height, maxHeight) || FFMPEGWrapper.isVideoDARChanged(width, height, dar, sar) || FFMPEGWrapper.isSARFixNeeded(targetContainer, sar.isSquarePixels());
    }

    private static boolean isVideoHeightChanged(Integer height, Integer maxHeight) {
        return maxHeight != null && height != null && height > maxHeight;
    }

    private static boolean isSARFixNeeded(VideoContainer targetContainer, boolean squarePixels) {
        return (targetContainer == VideoContainer.ASF || targetContainer == VideoContainer.FLV) && !squarePixels;
    }

    private static boolean isVideoDARChanged(Integer width, Integer height, DisplayAspectRatio dar, SourceAspectRatio sourceSar) {
        return dar != null && width != null && height != null && !dar.isEqualTo(width, height, sourceSar.getSar().floatValue());
    }

    protected static String findNearestValidFFmpegFrameRate(String frameRate) {
        float validFrameRate;
        float frFloat = Float.parseFloat(frameRate);
        for (validFrameRate = new Float(frFloat).floatValue(); validFrameRate < 23.0f; validFrameRate += frFloat) {
        }
        return MediaUtils.formatFpsForFFmpeg(Float.toString(validFrameRate));
    }

    private static String getFilePathForTranscoding(MediaItem mediaItem) {
        boolean isLocalMedia = mediaItem.isLocalMedia();
        String sourceFileName = null;
        sourceFileName = isLocalMedia ? MediaService.getFile(mediaItem.getId()).getPath() : mediaItem.getFileName();
        sourceFileName = FFMPEGWrapper.fixFilePath(sourceFileName, isLocalMedia);
        if (!isLocalMedia) {
            sourceFileName = FFMPEGWrapper.buildOnlineContentUrl(sourceFileName, mediaItem.isLive());
        }
        return sourceFileName;
    }

    private static String fixFilePath(String filePath, boolean isLocalContent) {
        if (!isLocalContent) {
            return FFMPEGWrapper.prepareOnlineContentUrl(filePath);
        }
        return filePath;
    }

    private static String buildOnlineContentUrl(String url, boolean live) {
        if (url.startsWith("rtmp") && !live) {
            url = String.format("%s buffer=%s", url, 100000000);
        }
        return url;
    }

    protected static String getUserAgent(String ffmpegOutput) {
        Pattern p = Pattern.compile("libavformat(.*?)/", 2);
        Matcher m = p.matcher(ffmpegOutput);
        if (m.find()) {
            String version = m.group(1);
            version = version.replaceAll(" ", "");
            return "Lavf" + version;
        }
        log.warn("Could not work out FFmpeg default User-Agent");
        return null;
    }

    private static void setupMaxChannelsMap() {
        maxChannelNumber = new HashMap<AudioCodec, Integer>();
        maxChannelNumber.put(AudioCodec.AC3, new Integer(6));
        maxChannelNumber.put(AudioCodec.MP2, new Integer(2));
        maxChannelNumber.put(AudioCodec.MP3, new Integer(2));
        maxChannelNumber.put(AudioCodec.WMA, new Integer(2));
        maxChannelNumber.put(AudioCodec.LPCM, new Integer(2));
    }

    private static void setupStringEncodingMap() {
        stringEncoding = new LinkedHashMap<String, String>();
        stringEncoding.put("\\\\", "/");
        stringEncoding.put("\\[", "\\\\[");
        stringEncoding.put("\\]", "\\\\]");
        stringEncoding.put("\"", "\\\\\"");
        stringEncoding.put(",", "\\\\,");
        stringEncoding.put("'", "\\\\\\\\\\\\\\\\\\\\\\\\\\\\'");
        windowsStringEncoding = new LinkedHashMap<String, String>();
        windowsStringEncoding.put("\\\\", "/");
        windowsStringEncoding.put("\\[", "\\\\[");
        windowsStringEncoding.put("\\]", "\\\\]");
        windowsStringEncoding.put(",", "\\\\,");
        windowsStringEncoding.put(":", "\\\\\\\\:");
        windowsStringEncoding.put("'", "\\\\\\\\\\\\'");
    }

    private static long onlineItemTimeout() {
        String systemPropertyValue = System.getProperty("serviio.onlineContentTimeout");
        if (ObjectValidator.isEmpty(systemPropertyValue)) {
            return DEFAULT_ONLINE_FILE_TIMEOUT;
        }
        return Long.parseLong(systemPropertyValue) * 1000L;
    }

    static {
        FFMPEGWrapper.setupMaxChannelsMap();
        FFMPEGWrapper.setupStringEncodingMap();
    }
}

