/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.external;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.serviio.external.AbstractExecutableWrapper;
import org.serviio.external.DCRawCLBuilder;
import org.serviio.external.ProcessExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCRawWrapper
extends AbstractExecutableWrapper {
    private static final Logger log = LoggerFactory.getLogger(DCRawWrapper.class);
    protected static AtomicReference<Boolean> present = new AtomicReference();

    public static boolean dcrawPresent() {
        if (present.get() == null) {
            DCRawCLBuilder builder = new DCRawCLBuilder();
            log.debug(String.format("Invoking DCRAW to check if it exists of path %s", DCRawCLBuilder.executablePath));
            ProcessExecutor executor = DCRawWrapper.processExecutorForTextOutput(builder);
            DCRawWrapper.executeSynchronously(executor);
            present.set(executor.isSuccess() && executor.getResults().size() > 5);
        }
        return present.get();
    }

    public static byte[] retrieveThumbnailFromRawFile(String filePath) throws IOException {
        DCRawCLBuilder builder = new DCRawCLBuilder();
        builder.inFile(filePath);
        builder.inFileOptions("-c");
        builder.inFileOptions("-e");
        log.debug(String.format("Invoking DCRAW to retrieve thumbnail from file: %s", filePath));
        ProcessExecutor executor = new ProcessExecutor(builder.build(), false, new Long(10000L));
        DCRawWrapper.executeSynchronously(executor);
        ByteArrayOutputStream out = (ByteArrayOutputStream)executor.getOutputStream();
        if (out != null) {
            return out.toByteArray();
        }
        return null;
    }

    private static ProcessExecutor processExecutorForTextOutput(DCRawCLBuilder builder) {
        return new ProcessExecutor(builder.build(), false, null, false, true);
    }
}

