/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.dlna;

import org.serviio.util.StringUtils;

public enum VideoContainer {
    ANY{

        @Override
        public String getFFmpegValue() {
            throw new RuntimeException("Cannot transcode audio into any");
        }
    }
    ,
    AVI{

        @Override
        public String getFFmpegValue() {
            return "avi";
        }
    }
    ,
    MATROSKA{

        @Override
        public String getFFmpegValue() {
            return "matroska";
        }
    }
    ,
    ASF{

        @Override
        public String getFFmpegValue() {
            return "asf";
        }
    }
    ,
    MP4{

        @Override
        public String getFFmpegValue() {
            return "mp4";
        }
    }
    ,
    MPEG2PS{

        @Override
        public String getFFmpegValue() {
            return "vob";
        }
    }
    ,
    MPEG2TS{

        @Override
        public String getFFmpegValue() {
            return "mpegts";
        }
    }
    ,
    M2TS{

        @Override
        public String getFFmpegValue() {
            return "mpegts";
        }
    }
    ,
    MPEG1{

        @Override
        public String getFFmpegValue() {
            return "mpegvideo";
        }
    }
    ,
    FLV{

        @Override
        public String getFFmpegValue() {
            return "flv";
        }
    }
    ,
    WTV{

        @Override
        public String getFFmpegValue() {
            return "wtv";
        }
    }
    ,
    OGG{

        @Override
        public String getFFmpegValue() {
            return "ogg";
        }
    }
    ,
    THREE_GP{

        @Override
        public String getFFmpegValue() {
            return "3gp";
        }
    }
    ,
    RTP{

        @Override
        public String getFFmpegValue() {
            return "rtp";
        }
    }
    ,
    RTSP{

        @Override
        public String getFFmpegValue() {
            return "rtsp";
        }
    }
    ,
    APPLE_HTTP{

        @Override
        public String getFFmpegValue() {
            return "segment";
        }

        @Override
        public boolean isSegmentBased() {
            return true;
        }
    }
    ,
    REAL_MEDIA{

        @Override
        public String getFFmpegValue() {
            return "rm";
        }
    };


    public abstract String getFFmpegValue();

    public boolean isSegmentBased() {
        return false;
    }

    public static VideoContainer getByFFmpegValue(String ffmpegName, String filePath) {
        if (ffmpegName != null) {
            if (ffmpegName.equals("*")) {
                return ANY;
            }
            if (ffmpegName.equals("asf")) {
                return ASF;
            }
            if (ffmpegName.equals("mpegvideo")) {
                return MPEG1;
            }
            if (ffmpegName.equals("mpeg") || ffmpegName.equals("vob")) {
                return MPEG2PS;
            }
            if (ffmpegName.equals("mpegts")) {
                return MPEG2TS;
            }
            if (ffmpegName.equals("m2ts")) {
                return M2TS;
            }
            if (ffmpegName.equals("matroska")) {
                return MATROSKA;
            }
            if (ffmpegName.equals("avi")) {
                return AVI;
            }
            if (ffmpegName.equals("mov") || ffmpegName.equals("mp4")) {
                if (filePath != null && StringUtils.localeSafeToLowercase(filePath).endsWith(".3gp")) {
                    return THREE_GP;
                }
                return MP4;
            }
            if (ffmpegName.equals("flv")) {
                return FLV;
            }
            if (ffmpegName.equals("wtv")) {
                return WTV;
            }
            if (ffmpegName.equals("ogg")) {
                return OGG;
            }
            if (ffmpegName.equals("3gp")) {
                return THREE_GP;
            }
            if (ffmpegName.equals("rtp")) {
                return RTP;
            }
            if (ffmpegName.equals("rtsp")) {
                return RTSP;
            }
            if (ffmpegName.equals("applehttp") || ffmpegName.equals("hls")) {
                return APPLE_HTTP;
            }
            if (ffmpegName.equals("rm")) {
                return REAL_MEDIA;
            }
        }
        return null;
    }
}

