/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.dlna;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public enum SubtitleCodec {
    SRT{

        @Override
        public List<String> getFileExtensions() {
            return Collections.singletonList("srt");
        }

        @Override
        public String getFFmpegEncoderName() {
            return "srt";
        }
    }
    ,
    ASS{

        @Override
        public List<String> getFileExtensions() {
            return Arrays.asList("ass", "ssa");
        }

        @Override
        public String getFFmpegEncoderName() {
            return "ass";
        }
    }
    ,
    SUB{

        @Override
        public List<String> getFileExtensions() {
            return Collections.singletonList("sub");
        }
    }
    ,
    SMI{

        @Override
        public List<String> getFileExtensions() {
            return Collections.singletonList("smi");
        }
    }
    ,
    VTT{

        @Override
        public List<String> getFileExtensions() {
            return Collections.singletonList("vtt");
        }
    }
    ,
    MOV_TEXT{

        @Override
        public List<String> getFileExtensions() {
            return Collections.emptyList();
        }
    }
    ,
    UNKNOWN{

        @Override
        public List<String> getFileExtensions() {
            return Collections.singletonList("txt");
        }
    };


    public abstract List<String> getFileExtensions();

    public String getFFmpegEncoderName() {
        return null;
    }

    public static List<String> getAllSupportedExtensions() {
        ArrayList<String> all = new ArrayList<String>();
        for (SubtitleCodec sc : SubtitleCodec.values()) {
            all.addAll(sc.getFileExtensions());
        }
        return all;
    }

    public static SubtitleCodec getByFileName(String subtitleFileName) {
        String extension;
        if (subtitleFileName != null && ObjectValidator.isNotEmpty(extension = FileUtils.getFileExtension(subtitleFileName))) {
            String normalizedExtension = StringUtils.localeSafeToLowercase(extension);
            for (SubtitleCodec sc : SubtitleCodec.values()) {
                if (!sc.getFileExtensions().contains(normalizedExtension)) continue;
                return sc;
            }
        }
        return null;
    }

    public static SubtitleCodec getByFFmpegValue(String ffmpegName) {
        if (ffmpegName != null) {
            if (ffmpegName.equals("srt") || ffmpegName.equals("subrip")) {
                return SRT;
            }
            if (ffmpegName.equals("microdvd")) {
                return SUB;
            }
            if (ffmpegName.equals("ass") || ffmpegName.equals("ssa")) {
                return ASS;
            }
            if (ffmpegName.equals("sami")) {
                return SMI;
            }
            if (ffmpegName.equals("webvtt")) {
                return VTT;
            }
            if (ffmpegName.equals("mov_text")) {
                return MOV_TEXT;
            }
        }
        return null;
    }
}

