/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.dlna;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.AudioContainer;
import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Video;
import org.serviio.library.local.metadata.TransportStreamTimestamp;

public class MediaFormatProfileResolver {
    public static List<MediaFormatProfile> resolve(MediaItem mediaItem) throws UnsupportedDLNAMediaFileFormatException {
        if (mediaItem instanceof Image) {
            Image image = (Image)mediaItem;
            return Collections.singletonList(MediaFormatProfileResolver.resolveImageFormat(mediaItem.getFileName(), image.getContainer(), image.getWidth(), image.getHeight()));
        }
        if (mediaItem instanceof MusicTrack) {
            MusicTrack track = (MusicTrack)mediaItem;
            return Collections.singletonList(MediaFormatProfileResolver.resolveAudioFormat(track.getFileName(), track.getContainer(), track.getBitrate(), track.getSampleFrequency(), track.getChannels()));
        }
        Video video = (Video)mediaItem;
        return MediaFormatProfileResolver.resolveVideoFormat(video.getFileName(), video.getContainer(), video.getVideoCodec(), video.getAudioCodec(), video.getWidth(), video.getHeight(), video.getBitrate(), video.getTimestampType());
    }

    public static MediaFormatProfile resolveImageFormat(String fileName, ImageContainer container, Integer width, Integer height) throws UnsupportedDLNAMediaFileFormatException {
        if (container == ImageContainer.JPEG) {
            return MediaFormatProfileResolver.resolveImageJPGFormat(fileName, width, height);
        }
        if (container == ImageContainer.PNG) {
            return MediaFormatProfileResolver.resolveImagePNGFormat(fileName, width, height);
        }
        if (container == ImageContainer.GIF) {
            return MediaFormatProfileResolver.resolveImageGIFFormat(fileName, width, height);
        }
        if (container == ImageContainer.RAW) {
            return MediaFormatProfileResolver.resolveImageRAWFormat(fileName, width, height);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("Image %s does not match any supported DLNA profile", fileName));
    }

    public static MediaFormatProfile resolveAudioFormat(String fileName, AudioContainer container, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        if (container == AudioContainer.ASF) {
            return MediaFormatProfileResolver.resolveAudioASFFormat(fileName, bitrate, frequency, channels);
        }
        if (container == AudioContainer.MP3) {
            return MediaFormatProfile.MP3;
        }
        if (container == AudioContainer.MP2) {
            return MediaFormatProfile.MP2_MPS;
        }
        if (container == AudioContainer.LPCM) {
            return MediaFormatProfileResolver.resolveAudioLPCMFormat(fileName, bitrate, frequency, channels);
        }
        if (container == AudioContainer.MP4) {
            return MediaFormatProfileResolver.resolveAudioMP4Format(fileName, bitrate, frequency, channels);
        }
        if (container == AudioContainer.ADTS) {
            return MediaFormatProfileResolver.resolveAudioADTSFormat(fileName, bitrate, frequency, channels);
        }
        if (container == AudioContainer.FLAC) {
            return MediaFormatProfileResolver.resolveAudioFLACFormat(fileName, bitrate, frequency, channels);
        }
        if (container == AudioContainer.OGG) {
            return MediaFormatProfileResolver.resolveAudioOGGFormat(fileName, bitrate, frequency, channels);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("Music track %s does not match any supported DLNA profile", fileName));
    }

    public static List<MediaFormatProfile> resolveVideoFormat(String fileName, VideoContainer container, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate, TransportStreamTimestamp timestampType) throws UnsupportedDLNAMediaFileFormatException {
        if (container == VideoContainer.ASF) {
            return MediaFormatProfileResolver.resolveVideoASFFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.MP4) {
            return MediaFormatProfileResolver.resolveVideoMP4Format(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.AVI) {
            return MediaFormatProfileResolver.resolveVideoAVIFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.MATROSKA) {
            return MediaFormatProfileResolver.resolveVideoMatroskaFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.MPEG2PS) {
            return MediaFormatProfileResolver.resolveVideoMPEG2PSFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.MPEG1) {
            return MediaFormatProfileResolver.resolveVideoMPEG1Format(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.MPEG2TS || container == VideoContainer.M2TS) {
            return MediaFormatProfileResolver.resolveVideoMPEG2TSFormat(fileName, videoCodec, audioCodec, width, height, bitrate, timestampType);
        }
        if (container == VideoContainer.FLV) {
            return MediaFormatProfileResolver.resolveVideoFLVFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.WTV) {
            return MediaFormatProfileResolver.resolveVideoWTVFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.THREE_GP) {
            return MediaFormatProfileResolver.resolveVideo3GPFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.REAL_MEDIA) {
            return MediaFormatProfileResolver.resolveVideoRealMediaFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        if (container == VideoContainer.APPLE_HTTP) {
            return MediaFormatProfileResolver.resolveVideoHLSFormat(fileName, videoCodec, audioCodec, width, height, bitrate);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("Video %s does not match any supported DLNA profile", fileName));
    }

    protected static MediaFormatProfile resolveAudioASFFormat(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        if (bitrate != null && bitrate < 193) {
            return MediaFormatProfile.WMA_BASE;
        }
        return MediaFormatProfile.WMA_FULL;
    }

    protected static MediaFormatProfile resolveAudioLPCMFormat(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        if (frequency != null && channels != null) {
            if (frequency == 44100 && channels == 1) {
                return MediaFormatProfile.LPCM16_44_MONO;
            }
            if (frequency == 44100 && channels == 2) {
                return MediaFormatProfile.LPCM16_44_STEREO;
            }
            if (frequency == 48000 && channels == 1) {
                return MediaFormatProfile.LPCM16_48_MONO;
            }
            if (frequency == 48000 && channels == 2) {
                return MediaFormatProfile.LPCM16_48_STEREO;
            }
            throw new UnsupportedDLNAMediaFileFormatException(String.format("Unsupported LPCM format of file %s. Only 44100 / 48000 Hz and Mono / Stereo files are allowed.", fileName));
        }
        return MediaFormatProfile.LPCM16_48_STEREO;
    }

    protected static MediaFormatProfile resolveAudioMP4Format(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        if (bitrate != null && bitrate <= 320) {
            return MediaFormatProfile.AAC_ISO_320;
        }
        return MediaFormatProfile.AAC_ISO;
    }

    protected static MediaFormatProfile resolveAudioADTSFormat(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        if (bitrate != null && bitrate <= 320) {
            return MediaFormatProfile.AAC_ADTS_320;
        }
        return MediaFormatProfile.AAC_ADTS;
    }

    protected static MediaFormatProfile resolveAudioFLACFormat(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        return MediaFormatProfile.FLAC;
    }

    protected static MediaFormatProfile resolveAudioOGGFormat(String fileName, Integer bitrate, Integer frequency, Integer channels) throws UnsupportedDLNAMediaFileFormatException {
        return MediaFormatProfile.OGG;
    }

    protected static MediaFormatProfile resolveImageJPGFormat(String fileName, Integer width, Integer height) throws UnsupportedDLNAMediaFileFormatException {
        if (width == null || height == null) {
            return MediaFormatProfile.JPEG_LRG;
        }
        if (width <= 640 && height <= 480) {
            return MediaFormatProfile.JPEG_SM;
        }
        if (width <= 1024 && height <= 768) {
            return MediaFormatProfile.JPEG_MED;
        }
        return MediaFormatProfile.JPEG_LRG;
    }

    protected static MediaFormatProfile resolveImagePNGFormat(String fileName, Integer width, Integer height) throws UnsupportedDLNAMediaFileFormatException {
        return MediaFormatProfile.PNG_LRG;
    }

    protected static MediaFormatProfile resolveImageGIFFormat(String fileName, Integer width, Integer height) throws UnsupportedDLNAMediaFileFormatException {
        return MediaFormatProfile.GIF_LRG;
    }

    protected static MediaFormatProfile resolveImageRAWFormat(String fileName, Integer width, Integer height) throws UnsupportedDLNAMediaFileFormatException {
        return MediaFormatProfile.RAW;
    }

    protected static List<MediaFormatProfile> resolveVideoMPEG1Format(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.MPEG1);
    }

    protected static List<MediaFormatProfile> resolveVideoMPEG2PSFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Arrays.asList(MediaFormatProfile.MPEG_PS_PAL, MediaFormatProfile.MPEG_PS_NTSC);
    }

    protected static List<MediaFormatProfile> resolveVideoMPEG2TSFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate, TransportStreamTimestamp timestampType) throws UnsupportedDLNAMediaFileFormatException {
        String suffix = "";
        if (MediaFormatProfileResolver.isNoTimestamp(timestampType)) {
            suffix = "_ISO";
        } else if (timestampType == TransportStreamTimestamp.VALID) {
            suffix = "_T";
        }
        String resolution = "S";
        if (width > 720 || height > 576) {
            resolution = "H";
        }
        if (videoCodec == VideoCodec.MPEG2) {
            List<MediaFormatProfile> profiles = Arrays.asList(MediaFormatProfile.valueOf("MPEG_TS_SD_EU" + suffix), MediaFormatProfile.valueOf("MPEG_TS_SD_NA" + suffix), MediaFormatProfile.valueOf("MPEG_TS_SD_KO" + suffix));
            if (timestampType == TransportStreamTimestamp.VALID && audioCodec == AudioCodec.AAC) {
                profiles.add(MediaFormatProfile.MPEG_TS_JP_T);
            }
            return profiles;
        }
        if (videoCodec == VideoCodec.H264) {
            if (audioCodec == AudioCodec.LPCM) {
                return Collections.singletonList(MediaFormatProfile.AVC_TS_HD_50_LPCM_T);
            }
            if (audioCodec == AudioCodec.DTS) {
                if (MediaFormatProfileResolver.isNoTimestamp(timestampType)) {
                    return Collections.singletonList(MediaFormatProfile.AVC_TS_HD_DTS_ISO);
                }
                return Collections.singletonList(MediaFormatProfile.AVC_TS_HD_DTS_T);
            }
            if (audioCodec == AudioCodec.DTSHD) {
                if (MediaFormatProfileResolver.isNoTimestamp(timestampType)) {
                    return Collections.singletonList(MediaFormatProfile.AVC_TS_DTSHD_MA_ISO);
                }
                return Collections.singletonList(MediaFormatProfile.AVC_TS_DTSHD_MA_T);
            }
            if (audioCodec == AudioCodec.MP2) {
                if (MediaFormatProfileResolver.isNoTimestamp(timestampType)) {
                    return Collections.singletonList(MediaFormatProfile.valueOf(String.format("AVC_TS_HP_%sD_MPEG1_L2_ISO", resolution)));
                }
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("AVC_TS_HP_%sD_MPEG1_L2_T", resolution)));
            }
            if (audioCodec == AudioCodec.AAC) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("AVC_TS_MP_%sD_AAC_MULT5%s", resolution, suffix)));
            }
            if (audioCodec == AudioCodec.MP3) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("AVC_TS_MP_%sD_MPEG1_L3%s", resolution, suffix)));
            }
            if (audioCodec == null || audioCodec == AudioCodec.AC3) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("AVC_TS_MP_%sD_AC3%s", resolution, suffix)));
            }
        } else if (videoCodec == VideoCodec.VC1) {
            if (audioCodec == null || audioCodec == AudioCodec.AC3) {
                if (width > 720 || height > 576) {
                    return Collections.singletonList(MediaFormatProfile.VC1_TS_AP_L2_AC3_ISO);
                }
                return Collections.singletonList(MediaFormatProfile.VC1_TS_AP_L1_AC3_ISO);
            }
            if (audioCodec == AudioCodec.DTS || audioCodec == AudioCodec.DTSHD) {
                String string = suffix = suffix.equals("_ISO") ? suffix : "_T";
                if (audioCodec == AudioCodec.DTS) {
                    return Collections.singletonList(MediaFormatProfile.valueOf(String.format("VC1_TS_HD_DTS%s", suffix)));
                }
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("VC1_TS_HD_DTSHD_MA%s", suffix)));
            }
        } else if (videoCodec == VideoCodec.MPEG4 || videoCodec == VideoCodec.MSMPEG4) {
            if (audioCodec == AudioCodec.AAC) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("MPEG4_P2_TS_ASP_AAC%s", suffix)));
            }
            if (audioCodec == AudioCodec.MP3) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("MPEG4_P2_TS_ASP_MPEG1_L3%s", suffix)));
            }
            if (audioCodec == AudioCodec.MP2) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("MPEG4_P2_TS_ASP_MPEG2_L2%s", suffix)));
            }
            if (audioCodec == null || audioCodec == AudioCodec.AC3) {
                return Collections.singletonList(MediaFormatProfile.valueOf(String.format("MPEG4_P2_TS_ASP_AC3%s", suffix)));
            }
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("MPEG2TS video file %s does not match any supported DLNA profile", fileName));
    }

    protected static List<MediaFormatProfile> resolveVideoMP4Format(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        if (videoCodec == VideoCodec.H264) {
            if (audioCodec == null || audioCodec == AudioCodec.AC3) {
                return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_SD_AC3);
            }
            if (audioCodec == AudioCodec.LPCM) {
                return Collections.singletonList(MediaFormatProfile.AVC_MP4_LPCM);
            }
            if (audioCodec == AudioCodec.MP3) {
                return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_SD_MPEG1_L3);
            }
            if (width <= 720 && height <= 576) {
                if (audioCodec == AudioCodec.AAC) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_SD_AAC_MULT5);
                }
                if (audioCodec == AudioCodec.DTS) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_SD_DTS);
                }
                if (audioCodec == AudioCodec.DTSHD) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_SD_DTSHD);
                }
            } else if (width <= 1280 && height <= 720) {
                if (audioCodec == AudioCodec.AAC) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_HD_720p_AAC);
                }
            } else if (width <= 1920 && height <= 1080) {
                if (audioCodec == AudioCodec.AAC) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_MP_HD_1080i_AAC);
                }
                if (audioCodec == AudioCodec.DTS) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_HP_HD_DTS);
                }
                if (audioCodec == AudioCodec.DTSHD) {
                    return Collections.singletonList(MediaFormatProfile.AVC_MP4_HP_HD_DTSHD);
                }
            }
        } else if (videoCodec == VideoCodec.MPEG4 || videoCodec == VideoCodec.MSMPEG4) {
            if (width <= 720 && height <= 576) {
                if (audioCodec == null || audioCodec == AudioCodec.AAC) {
                    return Collections.singletonList(MediaFormatProfile.MPEG4_P2_MP4_ASP_AAC);
                }
                if (audioCodec == AudioCodec.AC3 || audioCodec == AudioCodec.MP3) {
                    return Collections.singletonList(MediaFormatProfile.MPEG4_P2_MP4_NDSD);
                }
            } else if (audioCodec == null || audioCodec == AudioCodec.AAC) {
                return Collections.singletonList(MediaFormatProfile.MPEG4_P2_MP4_SP_L6_AAC);
            }
        } else if (videoCodec == VideoCodec.H263 && audioCodec == AudioCodec.AAC) {
            return Collections.singletonList(MediaFormatProfile.MPEG4_H263_MP4_P0_L10_AAC);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("MP4 video file %s does not match any supported DLNA profile", fileName));
    }

    protected static List<MediaFormatProfile> resolveVideoMatroskaFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.MATROSKA);
    }

    protected static List<MediaFormatProfile> resolveVideoFLVFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.FLV);
    }

    protected static List<MediaFormatProfile> resolveVideoWTVFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.WTV);
    }

    protected static List<MediaFormatProfile> resolveVideoRealMediaFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.REAL_VIDEO);
    }

    protected static List<MediaFormatProfile> resolveVideoHLSFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        if (videoCodec == VideoCodec.H264 && (audioCodec == null || audioCodec == AudioCodec.AAC)) {
            return Collections.singletonList(MediaFormatProfile.HLS);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("AppleHttp video file %s does not match any supported DLNA profile", fileName));
    }

    protected static List<MediaFormatProfile> resolveVideo3GPFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        if (videoCodec == VideoCodec.H264) {
            if (audioCodec == null || audioCodec == AudioCodec.AAC) {
                return Collections.singletonList(MediaFormatProfile.AVC_3GPP_BL_QCIF15_AAC);
            }
        } else if (videoCodec == VideoCodec.MPEG4 || videoCodec == VideoCodec.MSMPEG4) {
            if (audioCodec == null || audioCodec == AudioCodec.AAC) {
                return Collections.singletonList(MediaFormatProfile.MPEG4_P2_3GPP_SP_L0B_AAC);
            }
            if (audioCodec == AudioCodec.AMR) {
                return Collections.singletonList(MediaFormatProfile.MPEG4_P2_3GPP_SP_L0B_AMR);
            }
        } else if (videoCodec == VideoCodec.H263 && audioCodec == AudioCodec.AMR) {
            return Collections.singletonList(MediaFormatProfile.MPEG4_H263_3GPP_P0_L10_AMR);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("3GP video file %s does not match any supported DLNA profile", fileName));
    }

    protected static List<MediaFormatProfile> resolveVideoOGGFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.OGV);
    }

    protected static List<MediaFormatProfile> resolveVideoAVIFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        return Collections.singletonList(MediaFormatProfile.AVI);
    }

    protected static List<MediaFormatProfile> resolveVideoASFFormat(String fileName, VideoCodec videoCodec, AudioCodec audioCodec, Integer width, Integer height, Integer bitrate) throws UnsupportedDLNAMediaFileFormatException {
        if (videoCodec == VideoCodec.WMV && (audioCodec == null || audioCodec == AudioCodec.WMA || audioCodec == AudioCodec.WMA_PRO)) {
            if (width <= 720 && height <= 576) {
                if (audioCodec == null || audioCodec == AudioCodec.WMA) {
                    return Collections.singletonList(MediaFormatProfile.WMVMED_FULL);
                }
                return Collections.singletonList(MediaFormatProfile.WMVMED_PRO);
            }
            if (audioCodec == null || audioCodec == AudioCodec.WMA) {
                return Collections.singletonList(MediaFormatProfile.WMVHIGH_FULL);
            }
            return Collections.singletonList(MediaFormatProfile.WMVHIGH_PRO);
        }
        if (videoCodec == VideoCodec.VC1) {
            if (width <= 720 && height <= 576) {
                return Collections.singletonList(MediaFormatProfile.VC1_ASF_AP_L1_WMA);
            }
            if (width <= 1280 && height <= 720) {
                return Collections.singletonList(MediaFormatProfile.VC1_ASF_AP_L2_WMA);
            }
            if (width <= 1920 && height <= 1080) {
                return Collections.singletonList(MediaFormatProfile.VC1_ASF_AP_L3_WMA);
            }
        } else if (videoCodec == VideoCodec.MPEG2 || videoCodec == VideoCodec.MPEG1) {
            return Collections.singletonList(MediaFormatProfile.DVR_MS);
        }
        throw new UnsupportedDLNAMediaFileFormatException(String.format("ASF video file %s does not match any supported DLNA profile", fileName));
    }

    private static boolean isNoTimestamp(TransportStreamTimestamp timestampType) {
        return timestampType == null || timestampType == TransportStreamTimestamp.NONE;
    }
}

