/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.dlna;

import java.text.DecimalFormat;

public enum DisplayAspectRatio {
    DAR_16_9(16, 9);

    private int x;
    private int y;
    private static DecimalFormat df;

    private DisplayAspectRatio(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public float getRatio() {
        return (float)this.x / (float)this.y;
    }

    public static float getRatio(int width, int height, float sar) {
        return sar * (float)width / (float)height;
    }

    public boolean isEqualTo(int width, int height, float sar) {
        return df.format(this.getRatio()).equals(df.format(DisplayAspectRatio.getRatio(width, height, sar)));
    }

    public static DisplayAspectRatio fromString(String dar) {
        if (dar.equals("16:9")) {
            return DAR_16_9;
        }
        throw new IllegalArgumentException("DAR " + dar + "is not supported");
    }

    static {
        df = new DecimalFormat("##.##");
    }
}

