/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.dlna;

public enum AudioContainer {
    ANY{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into any");
        }
    }
    ,
    MP3{

        @Override
        public String getFFmpegContainerEncoderName() {
            return "mp3";
        }
    }
    ,
    MP2{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into mp2");
        }
    }
    ,
    ASF{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into asf");
        }
    }
    ,
    LPCM{

        @Override
        public String getFFmpegContainerEncoderName() {
            return "s16be";
        }
    }
    ,
    MP4{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into mp4");
        }
    }
    ,
    FLAC{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into flac");
        }
    }
    ,
    OGG{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into ogg");
        }
    }
    ,
    FLV{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into flv");
        }
    }
    ,
    RTP{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into rtp");
        }
    }
    ,
    RTSP{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into rtsp");
        }
    }
    ,
    ADTS{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into adts");
        }
    }
    ,
    WAVPACK{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into wavpack");
        }
    }
    ,
    MUSEPACK{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into musepack");
        }
    }
    ,
    APE{

        @Override
        public String getFFmpegContainerEncoderName() {
            throw new RuntimeException("Cannot transcode audio into Monkey's audio");
        }
    };


    public abstract String getFFmpegContainerEncoderName();

    public static AudioContainer getByName(String name) {
        if (name != null) {
            if (name.equals("*")) {
                return ANY;
            }
            if (name.equals("mp3")) {
                return MP3;
            }
            if (name.equals("mp2")) {
                return MP2;
            }
            if (name.equals("lpcm")) {
                return LPCM;
            }
            if (name.equals("asf") || name.equals("wmav1") || name.equals("wmav2")) {
                return ASF;
            }
            if (name.equals("mov") || name.equals("mp4") || name.equals("aac")) {
                return MP4;
            }
            if (name.equals("flac")) {
                return FLAC;
            }
            if (name.equals("ogg")) {
                return OGG;
            }
            if (name.equals("flv")) {
                return FLV;
            }
            if (name.equals("rtp")) {
                return RTP;
            }
            if (name.equals("rtsp")) {
                return RTSP;
            }
            if (name.equals("adts")) {
                return ADTS;
            }
            if (name.equals("wavpack")) {
                return WAVPACK;
            }
            if (name.equals("ape")) {
                return APE;
            }
            if (name.startsWith("musepack") || name.equals("mpc")) {
                return MUSEPACK;
            }
        }
        return null;
    }
}

